/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.jsonapi.models.Resource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExportFormatter
implements TableExportFormatter {
    private static final Logger log = LoggerFactory.getLogger(JsonExportFormatter.class);
    private static final String COMMA = ",";
    private ObjectMapper mapper;

    public JsonExportFormatter(Elide elide) {
        this.mapper = elide.getObjectMapper();
    }

    @Override
    public String format(PersistentResource resource, Integer recordNumber) {
        if (resource == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        if (recordNumber > 1) {
            str.append(COMMA);
        }
        str.append(JsonExportFormatter.resourceToJSON(this.mapper, resource));
        return str.toString();
    }

    public static String resourceToJSON(ObjectMapper mapper, PersistentResource resource) {
        if (resource == null || resource.getObject() == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        try {
            Resource jsonResource = resource.toResource(JsonExportFormatter.getRelationships(resource), JsonExportFormatter.getAttributes(resource));
            str.append(mapper.writeValueAsString((Object)jsonResource.getAttributes()));
        }
        catch (JsonProcessingException e) {
            log.error("Exception when converting to JSON {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
        return str.toString();
    }

    private static Map<String, Object> getAttributes(PersistentResource resource) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Set attrFields = resource.getRequestScope().getEntityProjection().getAttributes();
        for (Attribute field : attrFields) {
            String alias = field.getAlias();
            String fieldName = StringUtils.isNotEmpty((CharSequence)alias) ? alias : field.getName();
            attributes.put(fieldName, resource.getAttribute(field));
        }
        return attributes;
    }

    private static Map<String, Object> getRelationships(PersistentResource resource) {
        return Collections.emptyMap();
    }

    @Override
    public String preFormat(EntityProjection projection, TableExport query) {
        return "[";
    }

    @Override
    public String postFormat(EntityProjection projection, TableExport query) {
        return "]";
    }
}

