/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Union;
import com.yahoo.sketches.theta.UpdateSketch;

abstract class UnionImpl
extends SetOperation
implements Union {
    protected static final Family MY_FAMILY = Family.UNION;
    protected final short seedHash_;
    protected final UpdateSketch gadget_;
    protected long unionThetaLong_;

    UnionImpl(UpdateSketch gadget) {
        this.gadget_ = gadget;
        this.seedHash_ = UnionImpl.computeSeedHash(this.gadget_.getSeed());
        this.unionThetaLong_ = this.gadget_.getThetaLong();
    }

    UnionImpl(UpdateSketch gadget, Memory srcMem, long seed) {
        this.gadget_ = gadget;
        this.seedHash_ = UnionImpl.computeSeedHash(this.gadget_.getSeed());
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        this.unionThetaLong_ = srcMem.getLong(24L);
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        int k;
        int gadgetCurCount = this.gadget_.getRetainedEntries(true);
        if (gadgetCurCount > (k = 1 << this.gadget_.getLgNomLongs())) {
            this.gadget_.rebuild();
        }
        long thetaLongR = Math.min(this.gadget_.getThetaLong(), this.unionThetaLong_);
        double p = this.gadget_.getP();
        double thetaR = (double)thetaLongR / 9.223372036854776E18;
        long[] gadgetCache = this.gadget_.getCache();
        int curCountR = HashOperations.count(gadgetCache, thetaLongR);
        long[] compactCacheR = CompactSketch.compactCache(gadgetCache, curCountR, thetaLongR, dstOrdered);
        boolean emptyR = this.gadget_.isEmpty() && p >= thetaR && curCountR == 0;
        return CompactSketch.createCompactSketch(compactCacheR, emptyR, this.seedHash_, curCountR, thetaLongR, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public Union rebuild() {
        this.gadget_.rebuild();
        return this;
    }

    @Override
    public void reset() {
        this.gadget_.reset();
        this.unionThetaLong_ = this.gadget_.getThetaLong();
    }

    @Override
    public byte[] toByteArray() {
        byte[] gadgetByteArr = this.gadget_.toByteArray();
        NativeMemory mem = new NativeMemory(gadgetByteArr);
        mem.putLong(24L, this.unionThetaLong_);
        return gadgetByteArr;
    }

    @Override
    public void update(Sketch sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        long thetaLongIn = sketchIn.getThetaLong();
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        int curCountIn = sketchIn.getRetainedEntries(true);
        if (sketchIn.isOrdered()) {
            if (sketchIn.isDirect()) {
                int offsetBytes;
                long hashIn;
                Memory skMem = sketchIn.getMemory();
                int preambleLongs = skMem.getByte(0L) & 0x3F;
                for (int i = 0; i < curCountIn && (hashIn = skMem.getLong(offsetBytes = preambleLongs + i << 3)) < this.unionThetaLong_; ++i) {
                    this.gadget_.hashUpdate(hashIn);
                }
            } else {
                long hashIn;
                long[] cacheIn = sketchIn.getCache();
                for (int i = 0; i < curCountIn && (hashIn = cacheIn[i]) < this.unionThetaLong_; ++i) {
                    this.gadget_.hashUpdate(hashIn);
                }
            }
        } else {
            long[] cacheIn = sketchIn.getCache();
            int arrLongs = cacheIn.length;
            int c = 0;
            for (int i = 0; i < arrLongs && c < curCountIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                this.gadget_.hashUpdate(hashIn);
                ++c;
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    @Override
    public void update(Memory skMem) {
        if (skMem == null) {
            return;
        }
        int cap = (int)skMem.getCapacity();
        byte f = skMem.getByte(2L);
        if (f != 3) {
            throw new IllegalArgumentException("Family must be COMPACT or SET_SKETCH (old): " + f);
        }
        byte serVer = skMem.getByte(1L);
        if (serVer == 1) {
            if (cap <= 24) {
                return;
            }
            this.processVer1(skMem);
        } else if (serVer == 2) {
            if (cap <= 8) {
                return;
            }
            this.processVer2(skMem);
        } else if (serVer == 3) {
            if (cap <= 8) {
                return;
            }
            this.processVer3(skMem);
        } else {
            throw new IllegalArgumentException("SerVer is unknown: " + serVer);
        }
    }

    @Override
    public void update(long datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(double datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(String datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(byte[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(int[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(long[] data) {
        this.gadget_.update(data);
    }

    private void processVer1(Memory skMem) {
        int offsetBytes;
        long hashIn;
        long thetaLongIn = skMem.getLong(16L);
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        int curCount = skMem.getInt(8L);
        int preLongs = 3;
        for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    private void processVer2(Memory skMem) {
        int offsetBytes;
        long hashIn;
        long thetaLongIn;
        PreambleUtil.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
        int preLongs = skMem.getByte(0L) & 0x3F;
        int curCount = skMem.getInt(8L);
        if (preLongs == 1) {
            return;
        }
        if (preLongs == 2) {
            assert (curCount > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    private void processVer3(Memory skMem) {
        long thetaLongIn;
        PreambleUtil.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
        int preLongs = skMem.getByte(0L) & 0x3F;
        int curCount = skMem.getInt(8L);
        if (preLongs == 1) {
            return;
        }
        if (preLongs == 2) {
            assert (curCount > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        boolean ordered = skMem.isAnyBitsSet(5L, (byte)16);
        if (ordered) {
            int offsetBytes;
            long hashIn;
            for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
                this.gadget_.hashUpdate(hashIn);
            }
        } else {
            boolean compact = skMem.isAnyBitsSet(5L, (byte)8);
            int size = compact ? curCount : 1 << skMem.getByte(4L);
            for (int i = 0; i < size; ++i) {
                int offsetBytes = preLongs + i << 3;
                long hashIn = skMem.getLong(offsetBytes);
                if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                this.gadget_.hashUpdate(hashIn);
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }
}

