/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.SetOperationBuilder;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Union;
import com.yahoo.sketches.theta.UpdateSketchBuilder;

public final class Sketches {
    private Sketches() {
    }

    public static UpdateSketchBuilder updateSketchBuilder() {
        return new UpdateSketchBuilder();
    }

    public static Sketch heapifySketch(Memory srcMem) {
        return Sketch.heapify(srcMem);
    }

    public static Sketch heapifySketch(Memory srcMem, long seed) {
        return Sketch.heapify(srcMem, seed);
    }

    public static Sketch wrapSketch(Memory srcMem) {
        return Sketch.wrap(srcMem);
    }

    public static Sketch wrapSketch(Memory srcMem, long seed) {
        return Sketch.wrap(srcMem, seed);
    }

    public static SetOperationBuilder setOperationBuilder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapifySetOperation(Memory srcMem) {
        return SetOperation.heapify(srcMem);
    }

    public static SetOperation heapifySetOperation(Memory srcMem, long seed) {
        return SetOperation.heapify(srcMem, seed);
    }

    public static SetOperation wrapSetOperation(Memory srcMem) {
        return SetOperation.wrap(srcMem);
    }

    public static Union wrapUnion(Memory srcMem) {
        return (Union)((Object)SetOperation.wrap(srcMem));
    }

    public static Intersection wrapIntersection(Memory srcMem) {
        return (Intersection)((Object)SetOperation.wrap(srcMem));
    }

    public static SetOperation wrapSetOperation(Memory srcMem, long seed) {
        return SetOperation.wrap(srcMem, seed);
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        return Sketch.getMaxCompactSketchBytes(numberOfEntries);
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        return Sketch.getMaxUpdateSketchBytes(nomEntries);
    }

    public static int getSerializationVersion(Memory srcMem) {
        return Sketch.getSerializationVersion(srcMem);
    }

    public static int getMaxUnionBytes(int nomEntries) {
        return SetOperation.getMaxUnionBytes(nomEntries);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        return SetOperation.getMaxIntersectionBytes(nomEntries);
    }

    public static double getEstimate(Memory srcMem) {
        Sketches.checkIfValidThetaSketch(srcMem);
        return Sketch.estimate(Sketches.getThetaLong(srcMem), Sketches.getRetainedEntries(srcMem), Sketches.getEmpty(srcMem));
    }

    public static double getUpperBound(int numStdDev, Memory srcMem) {
        return Sketch.upperBound(numStdDev, Sketches.getThetaLong(srcMem), Sketches.getRetainedEntries(srcMem), Sketches.getEmpty(srcMem));
    }

    public static double getLowerBound(int numStdDev, Memory srcMem) {
        return Sketch.lowerBound(numStdDev, Sketches.getThetaLong(srcMem), Sketches.getRetainedEntries(srcMem), Sketches.getEmpty(srcMem));
    }

    static int getPreambleLongs(Memory srcMem) {
        return srcMem.getByte(0L) & 0x3F;
    }

    static int getRetainedEntries(Memory srcMem) {
        int preLongs = Sketches.getPreambleLongs(srcMem);
        return preLongs == 1 ? 0 : srcMem.getInt(8L);
    }

    static long getThetaLong(Memory srcMem) {
        int preLongs = Sketches.getPreambleLongs(srcMem);
        return preLongs < 3 ? Long.MAX_VALUE : srcMem.getLong(16L);
    }

    static boolean getEmpty(Memory srcMem) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 1) {
            return Sketches.getThetaLong(srcMem) == Long.MAX_VALUE && Sketches.getRetainedEntries(srcMem) == 0;
        }
        return srcMem.isAnyBitsSet(5L, (byte)4);
    }

    static void checkIfValidThetaSketch(Memory srcMem) {
        byte fam = srcMem.getByte(2L);
        if (!Sketch.isValidSketchID(fam)) {
            throw new IllegalArgumentException("Source Memory not a valid Sketch. Family: " + Family.idToFamily(fam).toString());
        }
    }
}

