/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.AnotB;
import com.yahoo.sketches.theta.DirectIntersection;
import com.yahoo.sketches.theta.DirectUnion;
import com.yahoo.sketches.theta.HeapAnotB;
import com.yahoo.sketches.theta.HeapIntersection;
import com.yahoo.sketches.theta.HeapUnion;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.ResizeFactor;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Union;

public class SetOperationBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private float bP = 1.0f;
    private Memory bDstMem = null;

    public SetOperationBuilder setNominalEntries(int nomEntries) {
        Util.checkIfPowerOf2(nomEntries, "nomEntries");
        this.bLgNomLongs = Integer.numberOfTrailingZeros(nomEntries);
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public SetOperationBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public SetOperationBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new IllegalArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public SetOperationBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public SetOperationBuilder initMemory(Memory dstMem) {
        this.bDstMem = dstMem;
        return this;
    }

    public Memory getMemory() {
        return this.bDstMem;
    }

    public SetOperation build(Family family) {
        SetOperation setOp = null;
        switch (family) {
            case UNION: {
                if (this.bDstMem == null) {
                    setOp = new HeapUnion(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                setOp = new DirectUnion(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, this.bDstMem);
                break;
            }
            case INTERSECTION: {
                if (this.bDstMem == null) {
                    setOp = new HeapIntersection(this.bSeed);
                    break;
                }
                setOp = new DirectIntersection(this.bSeed, this.bDstMem);
                break;
            }
            case A_NOT_B: {
                if (this.bDstMem == null) {
                    setOp = new HeapAnotB(this.bSeed);
                    break;
                }
                throw new IllegalArgumentException("AnotB is a stateless operation and cannot be persisted.");
            }
            default: {
                throw new IllegalArgumentException("Given Family cannot be built as a SetOperation: " + family.toString());
            }
        }
        return setOp;
    }

    public SetOperation build(int nomEntries, Family family) {
        Util.checkIfPowerOf2(nomEntries, "nomEntries");
        this.bLgNomLongs = Integer.numberOfTrailingZeros(nomEntries);
        return this.build(family);
    }

    public Union buildUnion() {
        return (Union)((Object)this.build(Family.UNION));
    }

    public Union buildUnion(int nomEntries) {
        return (Union)((Object)this.build(nomEntries, Family.UNION));
    }

    public Intersection buildIntersection() {
        return (Intersection)((Object)this.build(Family.INTERSECTION));
    }

    public AnotB buildANotB() {
        return (AnotB)((Object)this.build(Family.A_NOT_B));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SetOperationBuilder configuration:").append(Util.LS).append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS).append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS).append("Seed:").append('\t').append(this.bSeed).append(Util.LS).append("p:").append('\t').append(this.bP).append(Util.LS).append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS).append("DstMemory:").append('\t').append(this.bDstMem != null).append(Util.LS);
        return sb.toString();
    }
}

