/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.DirectIntersection;
import com.yahoo.sketches.theta.DirectUnion;
import com.yahoo.sketches.theta.HeapIntersection;
import com.yahoo.sketches.theta.HeapUnion;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperationBuilder;

public class SetOperation {
    static final int CONST_PREAMBLE_LONGS = 3;

    SetOperation() {
    }

    public static final SetOperationBuilder builder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapify(Memory srcMem) {
        return SetOperation.heapify(srcMem, 9001L);
    }

    public static SetOperation heapify(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case UNION: {
                return new HeapUnion(srcMem, seed);
            }
            case INTERSECTION: {
                return new HeapIntersection(srcMem, seed);
            }
        }
        throw new IllegalArgumentException("SetOperation cannot heapify family: " + family.toString());
    }

    public static SetOperation wrap(Memory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new IllegalArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return new DirectUnion(srcMem, seed);
            }
            case INTERSECTION: {
                return new DirectIntersection(srcMem, seed);
            }
        }
        throw new IllegalArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static int getMaxUnionBytes(int nomEntries) {
        Util.checkIfPowerOf2(nomEntries, "Nominal Entries");
        return (nomEntries << 4) + (Family.UNION.getMaxPreLongs() << 3);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        Util.checkIfPowerOf2(nomEntries, "Nominal Entries");
        int bytes = (nomEntries << 4) + (Family.INTERSECTION.getMaxPreLongs() << 3);
        return bytes;
    }

    static short computeSeedHash(long seed) {
        return PreambleUtil.computeSeedHash(seed);
    }

    static final int computeMinLgArrLongsFromCount(int count) {
        int upperCount = (int)Math.ceil((double)count / 0.9375);
        int arrLongs = Math.max(Util.ceilingPowerOf2(upperCount), 32);
        int newLgArrLongs = Integer.numberOfTrailingZeros(arrLongs);
        return newLgArrLongs;
    }

    static boolean isValidSetOpID(int id) {
        int loID = Family.UNION.getID();
        int hiID = Family.A_NOT_B.getID();
        return (hiID - id | id - loID) >= 0;
    }
}

