/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRequest;
import com.yahoo.sketches.memory.MemoryUtil;
import com.yahoo.sketches.theta.PreambleUtil;

final class Rebuilder {
    private Rebuilder() {
    }

    static final Memory resizeMoveOrRebuild(Memory srcMem, int preambleLongs, int lgNomLongs, int lgArrLongs, int curCount, long thetaLong) {
        int curMemBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        int reqMemBytesFull = PreambleUtil.getReqMemBytesFull(lgNomLongs, preambleLongs);
        Memory dstMem = srcMem;
        if (curMemBytes >= reqMemBytesFull) {
            assert (lgArrLongs == lgNomLongs + 1) : "lgArr: " + lgArrLongs + ", lgNom: " + lgNomLongs;
            Rebuilder.quickSelectAndRebuild(srcMem, preambleLongs, lgNomLongs, lgArrLongs, curCount);
        } else {
            long curCapBytes;
            int dstLgArrLongs = lgArrLongs + 1;
            int reqBytes = PreambleUtil.getMemBytes(dstLgArrLongs, preambleLongs);
            if ((long)reqBytes <= (curCapBytes = srcMem.getCapacity())) {
                Rebuilder.resize(srcMem, preambleLongs, lgArrLongs, dstLgArrLongs);
            } else {
                MemoryRequest memReq = srcMem.getMemoryRequest();
                dstMem = memReq.request(reqBytes);
                if (dstMem == null) {
                    throw new IllegalArgumentException("Requested memory cannot be null.");
                }
                long newCap = dstMem.getCapacity();
                if (newCap < (long)reqBytes) {
                    memReq.free(dstMem);
                    throw new IllegalArgumentException("Requested memory not granted: " + newCap + " < " + reqBytes);
                }
                Rebuilder.moveAndResize(srcMem, preambleLongs, lgArrLongs, dstMem, dstLgArrLongs, thetaLong);
                memReq.free(srcMem, dstMem);
            }
        }
        return dstMem;
    }

    static final void quickSelectAndRebuild(Memory mem, int preambleLongs, int lgNomLongs, int lgArrLongs, int curCount) {
        int arrLongs = 1 << lgArrLongs;
        long[] tmpArr = new long[arrLongs];
        int preBytes = preambleLongs << 3;
        mem.getLongArray(preBytes, tmpArr, 0, arrLongs);
        int pivot = (1 << lgNomLongs) + 1;
        long newThetaLong = QuickSelect.selectExcludingZeros(tmpArr, curCount, pivot);
        mem.putLong(16L, newThetaLong);
        long[] tgtArr = new long[arrLongs];
        int newCurCount = HashOperations.hashArrayInsert(tmpArr, tgtArr, lgArrLongs, newThetaLong);
        mem.putInt(8L, newCurCount);
        mem.putLongArray(preBytes, tgtArr, 0, arrLongs);
    }

    private static final void moveAndResize(Memory srcMem, int preambleLongs, int srcLgArrLongs, Memory dstMem, int dstLgArrLongs, long thetaLong) {
        int preBytes = preambleLongs << 3;
        MemoryUtil.copy(srcMem, 0L, dstMem, 0L, preBytes);
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        srcMem.getLongArray(preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        dstMem.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        dstMem.putByte(4L, (byte)dstLgArrLongs);
    }

    private static final void resize(Memory mem, int preambleLongs, int srcLgArrLongs, int dstLgArrLongs) {
        int preBytes = preambleLongs << 3;
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        mem.getLongArray(preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        long thetaLong = mem.getLong(16L);
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        mem.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        mem.putByte(4L, (byte)dstLgArrLongs);
    }
}

