/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

class HeapIntersection
extends SetOperation
implements Intersection {
    private static final Family MY_FAMILY = Family.INTERSECTION;
    private final short seedHash_;
    private int lgArrLongs_ = 0;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] hashTable_ = null;

    HeapIntersection(long seed) {
        this.seedHash_ = HeapIntersection.computeSeedHash(seed);
        this.empty_ = false;
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
    }

    HeapIntersection(Memory srcMem, long seed) {
        int preambleLongs = srcMem.getByte(0L) & 0x3F;
        if (preambleLongs != 3) {
            throw new IllegalArgumentException("PreambleLongs must = 3.");
        }
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new IllegalArgumentException("Ser Version must = 3");
        }
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        this.lgArrLongs_ = srcMem.getByte(4L);
        this.empty_ = srcMem.isAnyBitsSet(5L, (byte)4);
        this.seedHash_ = HeapIntersection.computeSeedHash(seed);
        short seedHashMem = srcMem.getShort(6L);
        PreambleUtil.checkSeedHashes(seedHashMem, this.seedHash_);
        this.curCount_ = srcMem.getInt(8L);
        this.thetaLong_ = srcMem.getLong(16L);
        if (this.empty_) {
            if (this.curCount_ != 0) {
                throw new IllegalArgumentException("srcMem empty state inconsistent with curCount: " + this.empty_ + "," + this.curCount_);
            }
        } else if (this.curCount_ > 0) {
            this.hashTable_ = new long[1 << this.lgArrLongs_];
            srcMem.getLongArray(24L, this.hashTable_, 0, 1 << this.lgArrLongs_);
        }
    }

    @Override
    public void update(Sketch sketchIn) {
        boolean skInIsValidAndNonZero;
        boolean bl = skInIsValidAndNonZero = sketchIn != null && sketchIn.getRetainedEntries(true) > 0;
        if (this.curCount_ == 0 || !skInIsValidAndNonZero) {
            if (sketchIn != null) {
                PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                this.empty_ |= sketchIn.isEmpty();
            } else {
                this.empty_ = true;
            }
            this.curCount_ = 0;
            this.hashTable_ = null;
        } else if (this.curCount_ < 0) {
            PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
            this.empty_ |= sketchIn.isEmpty();
            this.curCount_ = sketchIn.getRetainedEntries(true);
            this.lgArrLongs_ = HeapIntersection.computeMinLgArrLongsFromCount(this.curCount_);
            this.hashTable_ = new long[1 << this.lgArrLongs_];
            this.moveDataToHT(sketchIn.getCache(), this.curCount_);
        } else {
            PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
            this.empty_ |= sketchIn.isEmpty();
            this.performIntersect(sketchIn);
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        if (this.curCount_ < 0) {
            throw new IllegalStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        long[] compactCacheR = CompactSketch.compactCachePart(this.hashTable_, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.curCount_ >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        NativeMemory memOut = new NativeMemory(byteArrOut);
        memOut.putByte(0L, (byte)3);
        memOut.putByte(1L, (byte)3);
        memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
        memOut.putByte(3L, (byte)0);
        memOut.putByte(4L, (byte)this.lgArrLongs_);
        if (this.empty_) {
            memOut.setBits(5L, (byte)4);
        } else {
            memOut.clearBits(5L, (byte)4);
        }
        memOut.putShort(6L, this.seedHash_);
        memOut.putInt(8L, this.curCount_);
        memOut.putFloat(12L, 1.0f);
        memOut.putLong(16L, this.thetaLong_);
        if (this.curCount_ > 0) {
            memOut.putLongArray(preBytes, this.hashTable_, 0, 1 << this.lgArrLongs_);
        }
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.hashTable_ = null;
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = false;
    }

    private void performIntersect(Sketch sketchIn) {
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L) continue;
                if (hashIn < this.thetaLong_) {
                    int foundIdx = HashOperations.hashSearch(this.hashTable_, this.lgArrLongs_, hashIn);
                    if (foundIdx == -1) continue;
                    matchSet[matchSetCount++] = hashIn;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(this.hashTable_, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.lgArrLongs_ = HeapIntersection.computeMinLgArrLongsFromCount(matchSetCount);
        this.curCount_ = matchSetCount;
        Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        this.moveDataToHT(matchSet, matchSetCount);
    }

    private void moveDataToHT(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        for (int i = 0; i < arrLongsIn; ++i) {
            long hashIn = arr[i];
            if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
            tmpCnt += HashOperations.hashSearchOrInsert(this.hashTable_, this.lgArrLongs_, hashIn) < 0 ? 1 : 0;
        }
        assert (tmpCnt == count);
    }
}

