/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.UpdateSketch;

class HeapCompactOrderedSketch
extends CompactSketch {
    private final long[] cache_;

    HeapCompactOrderedSketch(Memory srcMem) {
        super(srcMem.isAnyBitsSet(5L, (byte)4), srcMem.getShort(6L), HeapCompactOrderedSketch.getCurCount(srcMem), HeapCompactOrderedSketch.getThetaLong(srcMem));
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        this.cache_ = new long[this.curCount_];
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int preBytes = HeapCompactOrderedSketch.compactPreambleLongs(this.thetaLong_, this.empty_) << 3;
        assert (preLongs << 3 == preBytes);
        srcMem.getLongArray(preBytes, this.cache_, 0, this.curCount_);
    }

    HeapCompactOrderedSketch(UpdateSketch sketch) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        boolean ordered = true;
        this.cache_ = CompactSketch.compactCache(sketch.getCache(), this.curCount_, this.thetaLong_, ordered);
    }

    HeapCompactOrderedSketch(long[] compactOrderedCache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
        assert (compactOrderedCache != null);
        this.cache_ = curCount == 0 ? new long[]{} : compactOrderedCache;
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getCurrentBytes(true)];
        Memory dstMem = new NativeMemory(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        dstMem = HeapCompactOrderedSketch.loadCompactMemory(this.getCache(), this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstMem, flags);
        return byteArray;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

