/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRequest;
import com.yahoo.sketches.memory.MemoryUtil;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.DirectUpdateSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Rebuilder;
import com.yahoo.sketches.theta.ResizeFactor;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;

class DirectQuickSelectSketch
extends DirectUpdateSketch {
    private static final double DQS_RESIZE_THRESHOLD = 0.9375;
    private final int preambleLongs_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private Memory mem_;

    private DirectQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, int preambleLongs) {
        super(lgNomLongs, seed, p, rf);
        this.preambleLongs_ = preambleLongs;
    }

    static DirectQuickSelectSketch getInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, Memory dstMem, boolean unionGadget) {
        int minReqBytes;
        ResizeFactor myRF;
        int lgArrLongs;
        Family family;
        int preambleLongs;
        if (lgNomLongs < 4) {
            throw new IllegalArgumentException("This sketch requires a minimum nominal entries of 16");
        }
        if (unionGadget) {
            preambleLongs = Family.UNION.getMinPreLongs();
            family = Family.UNION;
        } else {
            preambleLongs = Family.QUICKSELECT.getMinPreLongs();
            family = Family.QUICKSELECT;
        }
        MemoryRequest memReq = dstMem.getMemoryRequest();
        if (memReq == null) {
            lgArrLongs = lgNomLongs + 1;
            myRF = ResizeFactor.X1;
            minReqBytes = PreambleUtil.getReqMemBytesFull(lgNomLongs, preambleLongs);
        } else {
            lgArrLongs = 5;
            myRF = ResizeFactor.X2;
            minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        }
        long curMemCapBytes = dstMem.getCapacity();
        if (curMemCapBytes < (long)minReqBytes) {
            throw new IllegalArgumentException("Memory capacity is too small: " + curMemCapBytes + " < " + minReqBytes);
        }
        int curCount = 0;
        long pre0 = PreambleUtil.insertPreLongs(preambleLongs, 0L);
        pre0 = PreambleUtil.insertResizeFactor(myRF.lg(), pre0);
        pre0 = PreambleUtil.insertSerVer(3, pre0);
        pre0 = PreambleUtil.insertFamilyID(family.getID(), pre0);
        pre0 = PreambleUtil.insertLgNomLongs(lgNomLongs, pre0);
        pre0 = PreambleUtil.insertLgArrLongs(lgArrLongs, pre0);
        pre0 = PreambleUtil.insertFlags(4, pre0);
        pre0 = PreambleUtil.insertSeedHash(PreambleUtil.computeSeedHash(seed), pre0);
        long pre1 = curCount;
        pre1 = PreambleUtil.insertP(p, pre1);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        long[] preArr = new long[]{pre0, pre1, thetaLong};
        dstMem.putLongArray(0L, preArr, 0, 3);
        dstMem.clear(preambleLongs << 3, 8 << lgArrLongs);
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(lgNomLongs, seed, p, myRF, preambleLongs);
        dqss.lgArrLongs_ = lgArrLongs;
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        dqss.curCount_ = curCount;
        dqss.thetaLong_ = thetaLong;
        dqss.empty_ = true;
        dqss.mem_ = dstMem;
        return dqss;
    }

    static DirectQuickSelectSketch getInstance(Memory srcMem, long seed) {
        long[] preArr = new long[3];
        srcMem.getLongArray(0L, preArr, 0, 3);
        long long0 = preArr[0];
        int preambleLongs = PreambleUtil.extractPreLongs(long0);
        ResizeFactor myRF = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(long0));
        int serVer = PreambleUtil.extractSerVer(long0);
        int familyID = PreambleUtil.extractFamilyID(long0);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(long0);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(long0);
        int flags = PreambleUtil.extractFlags(long0);
        short seedHash = (short)PreambleUtil.extractSeedHash(long0);
        long long1 = preArr[1];
        int curCount = PreambleUtil.extractCurCount(long1);
        float p = PreambleUtil.extractP(long1);
        long thetaLong = preArr[2];
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.UNION)) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new IllegalArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (family.equals((Object)Family.QUICKSELECT)) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new IllegalArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            throw new IllegalArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (serVer != 3) {
            throw new IllegalArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        int flagsMask = 27;
        if ((flags & flagsMask) > 0) {
            throw new IllegalArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
        PreambleUtil.checkSeedHashes(seedHash, PreambleUtil.computeSeedHash(seed));
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new IllegalArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new IllegalArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(lgNomLongs, seed, p, myRF, preambleLongs);
        dqss.lgArrLongs_ = lgArrLongs;
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        dqss.curCount_ = curCount;
        dqss.thetaLong_ = thetaLong;
        dqss.empty_ = (flags & 4) > 0;
        dqss.mem_ = srcMem;
        return dqss;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        int lengthBytes = this.preambleLongs_ + (1 << this.lgArrLongs_) << 3;
        byte[] byteArray = new byte[lengthBytes];
        NativeMemory mem = new NativeMemory(byteArray);
        MemoryUtil.copy(this.mem_, 0L, mem, 0L, lengthBytes);
        return byteArray;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            Rebuilder.quickSelectAndRebuild(this.mem_, this.preambleLongs_, this.lgNomLongs_, this.lgArrLongs_, this.curCount_);
            this.curCount_ = this.mem_.getInt(8L);
            this.thetaLong_ = this.mem_.getLong(16L);
        }
        return this;
    }

    @Override
    public final void reset() {
        int arrLongs = 1 << this.getLgArrLongs();
        int preBytes = this.preambleLongs_ << 3;
        this.mem_.clear(preBytes, arrLongs * 8);
        this.mem_.putByte(5L, (byte)4);
        this.empty_ = true;
        this.curCount_ = DirectQuickSelectSketch.setCurCount(this.mem_, 0);
        float p = this.mem_.getFloat(12L);
        this.thetaLong_ = DirectQuickSelectSketch.setThetaLong(this.mem_, (long)((double)p * 9.223372036854776E18));
    }

    @Override
    int getPreambleLongs() {
        return this.preambleLongs_;
    }

    @Override
    long[] getCache() {
        long[] cacheArr = new long[1 << this.lgArrLongs_];
        NativeMemory mem = new NativeMemory(cacheArr);
        MemoryUtil.copy(this.mem_, this.preambleLongs_ << 3, mem, 0L, 8 << this.lgArrLongs_);
        return cacheArr;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        if (this.empty_) {
            this.mem_.clearBits(5L, (byte)4);
            this.empty_ = false;
        }
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        if (HashOperations.hashSearchOrInsert(this.mem_, this.lgArrLongs_, hash, this.preambleLongs_ << 3) >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        this.mem_.putInt(8L, ++this.curCount_);
        if (this.curCount_ > this.hashTableThreshold_) {
            this.mem_ = Rebuilder.resizeMoveOrRebuild(this.mem_, this.preambleLongs_, this.lgNomLongs_, this.lgArrLongs_, this.curCount_, this.thetaLong_);
            this.curCount_ = this.mem_.getInt(8L);
            this.thetaLong_ = this.mem_.getLong(16L);
            this.lgArrLongs_ = this.mem_.getByte(4L);
            this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    private static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }

    private static final long setThetaLong(Memory mem, long newThetaLong) {
        mem.putLong(16L, newThetaLong);
        return newThetaLong;
    }

    private static final int setCurCount(Memory mem, int newCurCount) {
        mem.putInt(8L, newCurCount);
        return newCurCount;
    }

    static void println(String s) {
        System.out.println(s);
    }
}

