/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryUtil;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;

class DirectIntersection
extends SetOperation
implements Intersection {
    private static final Family MY_FAMILY = Family.INTERSECTION;
    private final short seedHash_;
    private int lgArrLongs_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private final int maxLgArrLongs_;
    private final Memory mem_;

    DirectIntersection(long seed, Memory dstMem) {
        int preBytes = 24;
        this.maxLgArrLongs_ = DirectIntersection.checkMaxLgArrLongs(dstMem);
        this.mem_ = dstMem;
        this.mem_.clear(0L, preBytes);
        this.mem_.putByte(0L, (byte)3);
        this.mem_.putByte(1L, (byte)3);
        this.mem_.putByte(2L, (byte)Family.stringToFamily("Intersection").getID());
        this.lgArrLongs_ = this.setLgArrLongs(5);
        this.empty_ = this.setEmpty(false);
        this.seedHash_ = DirectIntersection.computeSeedHash(seed);
        this.mem_.putShort(6L, this.seedHash_);
        this.curCount_ = this.setCurCount(-1);
        this.mem_.putFloat(12L, 1.0f);
        this.thetaLong_ = this.setThetaLong(Long.MAX_VALUE);
    }

    DirectIntersection(Memory srcMem, long seed) {
        int preambleLongs = srcMem.getByte(0L) & 0x3F;
        if (preambleLongs != 3) {
            throw new IllegalArgumentException("PreambleLongs must = 3.");
        }
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new IllegalArgumentException("Ser Version must = 3");
        }
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        this.lgArrLongs_ = srcMem.getByte(4L);
        this.maxLgArrLongs_ = DirectIntersection.checkMaxLgArrLongs(srcMem);
        this.empty_ = srcMem.isAnyBitsSet(5L, (byte)4);
        this.seedHash_ = DirectIntersection.computeSeedHash(seed);
        short seedHashMem = srcMem.getShort(6L);
        PreambleUtil.checkSeedHashes(seedHashMem, this.seedHash_);
        this.curCount_ = srcMem.getInt(8L);
        this.thetaLong_ = srcMem.getLong(16L);
        if (this.empty_ && this.curCount_ != 0) {
            throw new IllegalArgumentException("srcMem empty state inconsistent with curCount: " + this.empty_ + "," + this.curCount_);
        }
        this.mem_ = srcMem;
    }

    @Override
    public void update(Sketch sketchIn) {
        boolean skInIsValidAndNonZero;
        boolean bl = skInIsValidAndNonZero = sketchIn != null && sketchIn.getRetainedEntries(true) > 0;
        if (this.curCount_ == 0 || !skInIsValidAndNonZero) {
            if (sketchIn != null) {
                PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
                this.empty_ = this.setEmpty(this.empty_ | sketchIn.isEmpty());
            } else {
                this.empty_ = this.setEmpty(true);
            }
            this.curCount_ = this.setCurCount(0);
        } else if (this.curCount_ < 0) {
            PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
            this.empty_ = this.setEmpty(this.empty_ | sketchIn.isEmpty());
            this.curCount_ = this.setCurCount(sketchIn.getRetainedEntries(true));
            int newLgArrLongs = this.setLgArrLongs(DirectIntersection.computeMinLgArrLongsFromCount(this.curCount_));
            int preBytes = 24;
            if (newLgArrLongs > this.maxLgArrLongs_) {
                throw new IllegalArgumentException("Insufficient dstMem hash table space: " + (1 << newLgArrLongs) + " > " + (1 << this.lgArrLongs_));
            }
            this.lgArrLongs_ = this.setLgArrLongs(newLgArrLongs);
            this.mem_.clear(preBytes, 8 << this.lgArrLongs_);
            this.moveDataToHT(sketchIn.getCache(), this.curCount_);
        } else {
            PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
            this.empty_ = this.setEmpty(this.empty_ | sketchIn.isEmpty());
            this.performIntersect(sketchIn);
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        if (this.curCount_ < 0) {
            throw new IllegalStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        int htLen = 1 << this.lgArrLongs_;
        long[] hashTable = new long[htLen];
        this.mem_.getLongArray(24L, hashTable, 0, htLen);
        long[] compactCacheR = CompactSketch.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.mem_.getInt(8L) >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        NativeMemory memOut = new NativeMemory(byteArrOut);
        memOut.putByte(0L, (byte)3);
        memOut.putByte(1L, (byte)3);
        memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
        memOut.putByte(3L, (byte)0);
        memOut.putByte(4L, (byte)this.lgArrLongs_);
        if (this.empty_) {
            memOut.setBits(5L, (byte)4);
        } else {
            memOut.clearBits(5L, (byte)4);
        }
        memOut.putShort(6L, this.seedHash_);
        memOut.putInt(8L, this.curCount_);
        memOut.putFloat(12L, 1.0f);
        memOut.putLong(16L, this.thetaLong_);
        if (this.curCount_ > 0) {
            MemoryUtil.copy(this.mem_, preBytes, memOut, preBytes, dataBytes);
        }
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.lgArrLongs_ = 0;
        this.mem_.putByte(4L, (byte)this.lgArrLongs_);
        this.curCount_ = -1;
        this.mem_.putInt(8L, -1);
        this.thetaLong_ = Long.MAX_VALUE;
        this.mem_.putLong(16L, Long.MAX_VALUE);
        this.empty_ = false;
        this.mem_.clearBits(5L, (byte)4);
        this.mem_.clear(24L, 8 << this.lgArrLongs_);
    }

    private void performIntersect(Sketch sketchIn) {
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int htLen = 1 << this.lgArrLongs_;
        long[] hashTable = new long[htLen];
        this.mem_.getLongArray(24L, hashTable, 0, htLen);
        int arrLongsIn = cacheIn.length;
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L) continue;
                if (hashIn < this.thetaLong_) {
                    int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                    if (foundIdx == -1) continue;
                    matchSet[matchSetCount++] = hashIn;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.lgArrLongs_ = this.setLgArrLongs(DirectIntersection.computeMinLgArrLongsFromCount(this.curCount_));
        this.curCount_ = this.setCurCount(matchSetCount);
        this.mem_.fill(24L, 8 << this.lgArrLongs_, (byte)0);
        this.moveDataToHT(matchSet, matchSetCount);
    }

    private void moveDataToHT(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        int preBytes = 24;
        for (int i = 0; i < arrLongsIn; ++i) {
            long hashIn = arr[i];
            if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
            tmpCnt += HashOperations.hashSearchOrInsert(this.mem_, this.lgArrLongs_, hashIn, preBytes) < 0 ? 1 : 0;
        }
        if (tmpCnt != count) {
            throw new IllegalArgumentException("Count Check Exception: got: " + tmpCnt + ", expected: " + count);
        }
    }

    private static final int checkMaxLgArrLongs(Memory dstMem) {
        int preBytes = 24;
        long cap = dstMem.getCapacity();
        int maxLgArrLongs = Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - (long)preBytes)) >>> 3);
        if (maxLgArrLongs < 5) {
            throw new IllegalArgumentException("dstMem not large enough for minimum sized hash table: " + cap);
        }
        return maxLgArrLongs;
    }

    private final boolean setEmpty(boolean empty) {
        if (empty) {
            this.mem_.setBits(5L, (byte)4);
        } else {
            this.mem_.clearBits(5L, (byte)4);
        }
        return empty;
    }

    private final int setLgArrLongs(int lgArrLongs) {
        this.mem_.putByte(4L, (byte)lgArrLongs);
        return lgArrLongs;
    }

    private final long setThetaLong(long thetaLong) {
        this.mem_.putLong(16L, thetaLong);
        return thetaLong;
    }

    private final long minThetaLong(long skThetaLong) {
        if (skThetaLong < this.thetaLong_) {
            this.mem_.putLong(16L, skThetaLong);
            return skThetaLong;
        }
        return this.thetaLong_;
    }

    private final int setCurCount(int curCount) {
        this.mem_.putInt(8L, curCount);
        return curCount;
    }
}

