/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.UpdateSketch;

class DirectCompactOrderedSketch
extends CompactSketch {
    private Memory mem_;

    DirectCompactOrderedSketch(Memory srcMem) {
        super(srcMem.isAnyBitsSet(5L, (byte)4), srcMem.getShort(6L), DirectCompactOrderedSketch.getCurCount(srcMem), DirectCompactOrderedSketch.getThetaLong(srcMem));
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        this.mem_ = srcMem;
    }

    DirectCompactOrderedSketch(UpdateSketch sketch, Memory dstMem) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        int emptyBit = this.empty_ ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        boolean ordered = true;
        long[] compactOrderedCache = CompactSketch.compactCache(sketch.getCache(), this.curCount_, this.thetaLong_, ordered);
        this.mem_ = DirectCompactOrderedSketch.loadCompactMemory(compactOrderedCache, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstMem, flags);
    }

    DirectCompactOrderedSketch(long[] compactOrderedCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem) {
        super(empty, seedHash, curCount, thetaLong);
        int emptyBit = this.empty_ ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        this.mem_ = DirectCompactOrderedSketch.loadCompactMemory(compactOrderedCache, empty, seedHash, curCount, thetaLong, dstMem, flags);
    }

    @Override
    public byte[] toByteArray() {
        return DirectCompactSketch.compactMemoryToByteArray(this.mem_, this.curCount_);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    long[] getCache() {
        long[] cache = new long[this.curCount_];
        int preLongs = this.mem_.getByte(0L) & 0x3F;
        this.mem_.getLongArray(preLongs << 3, cache, 0, this.curCount_);
        return cache;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

