/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.quantiles.HeapQuantilesSketch;
import com.yahoo.sketches.quantiles.QuantilesSketch;
import java.util.Arrays;

final class Util {
    public static String LS = System.getProperty("line.separator");
    public static final char TAB = '\t';

    Util() {
    }

    static void checkK(int k) {
        if (k < 1 || k > 65535) {
            throw new IllegalArgumentException("K must be >= 1 and < 65536");
        }
    }

    static void checkSerVer(int serVer) {
        if (serVer != 1) {
            throw new IllegalArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
    }

    static void checkFamilyID(int familyID) {
        Family family = Family.idToFamily(familyID);
        if (!family.equals((Object)Family.QUANTILES)) {
            throw new IllegalArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
    }

    static void checkBufAllocAndCap(int k, long n, int memBufAlloc, long memCapBytes) {
        int computedBufAlloc = Util.bufferElementCapacity(k, n);
        if (memBufAlloc != computedBufAlloc) {
            throw new IllegalArgumentException("Possible corruption: Invalid Buffer Allocated Count: " + memBufAlloc + " != " + computedBufAlloc);
        }
        int maxPre = Family.QUANTILES.getMaxPreLongs();
        int reqBufBytes = maxPre + memBufAlloc << 3;
        if (memCapBytes < (long)reqBufBytes) {
            throw new IllegalArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static boolean checkPreLongsFlagsCap(int preambleLongs, int flags, long memCapBytes) {
        boolean valid;
        boolean empty = (flags & 4) > 0;
        int minPre = Family.QUANTILES.getMinPreLongs();
        int maxPre = Family.QUANTILES.getMaxPreLongs();
        boolean bl = valid = preambleLongs == minPre && empty || preambleLongs == maxPre && !empty;
        if (!valid) {
            throw new IllegalArgumentException("Possible corruption: PreambleLongs inconsistent with empty state: " + preambleLongs);
        }
        Util.checkFlags(flags);
        if (!empty && memCapBytes < (long)(maxPre << 3)) {
            throw new IllegalArgumentException("Possible corruption: Insufficient capacity for preamble: " + memCapBytes);
        }
        return empty;
    }

    static void checkFlags(int flags) {
        int flagsMask = 27;
        if ((flags & flagsMask) > 0) {
            throw new IllegalArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
    }

    static final void validateSequential(double[] values) {
        for (int j = 0; j < values.length - 1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new IllegalArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    static double sumOfSamplesInSketch(HeapQuantilesSketch sketch) {
        long bits;
        double[] combinedBuffer = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        double total = Util.sumOfDoublesInSubArray(combinedBuffer, 0, bbCount);
        int k = sketch.getK();
        assert (bits == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (bits = sketch.getBitPattern(); bits != 0L; bits >>>= 1) {
            if ((bits & 1L) > 0L) {
                total += Util.sumOfDoublesInSubArray(combinedBuffer, (2 + lvl) * k, k);
            }
            ++lvl;
        }
        return total;
    }

    static long[] internalBuildHistogram(double[] splitPoints, HeapQuantilesSketch sketch) {
        long myBitPattern;
        double[] levelsArr;
        double[] baseBuffer = levelsArr = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        Util.validateSequential(splitPoints);
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            Util.bilinearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        } else {
            Arrays.sort(baseBuffer, 0, bbCount);
            Util.linearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                Util.linearTimeIncrementHistogramCounters(levelsArr, (2 + lvl) * k, k, weight, splitPoints, counters);
            }
            ++lvl;
        }
        return counters;
    }

    static void processFullBaseBuffer(HeapQuantilesSketch sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        Util.maybeGrowLevels(n, sketch);
        double[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount);
        Util.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        assert (n / (long)(2 * sketch.getK()) == sketch.getBitPattern());
    }

    static void inPlacePropagateCarry(int startingLevel, double[] sizeKBuf, int sizeKStart, double[] size2KBuf, int size2KStart, boolean doUpdateVersion, HeapQuantilesSketch sketch) {
        double[] levelsArr = sketch.getCombinedBuffer();
        long bitPattern = sketch.getBitPattern();
        int k = sketch.getK();
        int endingLevel = Util.positionOfLowestZeroBitStartingAt(bitPattern, startingLevel);
        if (doUpdateVersion) {
            Util.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        } else {
            System.arraycopy(sizeKBuf, sizeKStart, levelsArr, (2 + endingLevel) * k, k);
        }
        for (int lvl = startingLevel; lvl < endingLevel; ++lvl) {
            assert ((bitPattern & 1L << lvl) > 0L);
            Util.mergeTwoSizeKBuffers(levelsArr, (2 + lvl) * k, levelsArr, (2 + endingLevel) * k, size2KBuf, size2KStart, k);
            Util.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        }
        sketch.bitPattern_ = bitPattern + (1L << startingLevel);
    }

    static void maybeGrowLevels(long newN, HeapQuantilesSketch sketch) {
        int k = sketch.getK();
        int numLevelsNeeded = Util.computeNumLevelsNeeded(k, newN);
        if (numLevelsNeeded == 0) {
            return;
        }
        assert (newN >= 2L * (long)k);
        assert (numLevelsNeeded > 0);
        int spaceNeeded = (2 + numLevelsNeeded) * k;
        if (spaceNeeded <= sketch.getCombinedBufferAllocatedCount()) {
            return;
        }
        double[] newCombinedBuffer = Arrays.copyOf(sketch.getCombinedBuffer(), spaceNeeded);
        sketch.combinedBufferAllocatedCount_ = spaceNeeded;
        sketch.combinedBuffer_ = newCombinedBuffer;
    }

    static void growBaseBuffer(HeapQuantilesSketch sketch) {
        int newSize;
        double[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferAllocatedCount_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        double[] newBuf = Arrays.copyOf(baseBuffer, newSize);
        sketch.combinedBuffer_ = newBuf;
    }

    static void downSamplingMergeInto(HeapQuantilesSketch src, HeapQuantilesSketch tgt) {
        int targetK = tgt.getK();
        int sourceK = src.getK();
        if (sourceK % targetK != 0) {
            throw new IllegalArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = sourceK / targetK;
        com.yahoo.sketches.Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        double[] sourceLevels = src.getCombinedBuffer();
        double[] sourceBaseBuffer = src.getCombinedBuffer();
        long nFinal = tgt.getN() + src.getN();
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(sourceBaseBuffer[i]);
        }
        Util.maybeGrowLevels(nFinal, tgt);
        double[] scratchBuf = new double[2 * targetK];
        double[] downBuf = new double[targetK];
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                Util.justZipWithStride(sourceLevels, (2 + srcLvl) * sourceK, downBuf, 0, targetK, downFactor);
                Util.inPlacePropagateCarry(srcLvl + lgDownFactor, downBuf, 0, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * targetK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.maxValue_ = srcMax;
        }
        if (srcMin < tgtMin) {
            tgt.minValue_ = srcMin;
        }
    }

    static String toString(boolean sketchSummary, boolean dataDetail, HeapQuantilesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int bbCount = sketch.getBaseBufferCount();
        int combAllocCount = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        long bitPattern = sketch.getBitPattern();
        if (dataDetail) {
            sb.append(LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(LS);
            double[] levelsArr = sketch.getCombinedBuffer();
            double[] baseBuffer = sketch.getCombinedBuffer();
            sb.append("   BaseBuffer   : ");
            if (bbCount > 0) {
                for (int i = 0; i < bbCount; ++i) {
                    sb.append(String.format("%10.1f", baseBuffer[i]));
                }
            }
            sb.append(LS);
            int items = combAllocCount;
            if (items > 2 * k) {
                sb.append("   Valid | Level");
                for (int j = 2 * k; j < items; ++j) {
                    if (j % k == 0) {
                        int levelNum = j > 2 * k ? (j - 2 * k) / k : 0;
                        String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                        String lvl = String.format("%5d", levelNum);
                        sb.append(LS).append("   ").append(validLvl).append(" ").append(lvl).append(": ");
                    }
                    sb.append(String.format("%10.1f", levelsArr[j]));
                }
                sb.append(LS);
            }
            sb.append("### END DATA DETAIL").append(LS);
        }
        if (sketchSummary) {
            long n = sketch.getN();
            String nStr = String.format("%,d", n);
            int numLevels = Util.computeNumLevelsNeeded(k, n);
            int bufBytes = combAllocCount * 8;
            String bufCntStr = String.format("%,d", combAllocCount);
            int preBytes = 36;
            double eps = EpsilonFromK.getAdjustedEpsilon(k);
            String epsPct = String.format("%.3f%%", eps * 100.0);
            int numSamples = sketch.getRetainedEntries();
            String numSampStr = String.format("%,d", numSamples);
            sb.append(LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(LS);
            sb.append("   K                            : ").append(k).append(LS);
            sb.append("   N                            : ").append(nStr).append(LS);
            sb.append("   Seed                         : ").append(sketch.getSeed()).append(LS);
            sb.append("   BaseBufferCount              : ").append(bbCount).append(LS);
            sb.append("   CombinedBufferAllocatedCount : ").append(bufCntStr).append(LS);
            sb.append("   Total Levels                 : ").append(numLevels).append(LS);
            sb.append("   Valid Levels                 : ").append(Util.numValidLevels(bitPattern)).append(LS);
            sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(LS);
            sb.append("   Valid Samples                : ").append(numSampStr).append(LS);
            sb.append("   Buffer Storage Bytes         : ").append(String.format("%,d", bufBytes)).append(LS);
            sb.append("   Preamble Bytes               : ").append(preBytes).append(LS);
            sb.append("   Normalized Rank Error        : ").append(epsPct).append(LS);
            sb.append("   Min Value                    : ").append(String.format("%,.3f", sketch.getMinValue())).append(LS);
            sb.append("   Max Value                    : ").append(String.format("%,.3f", sketch.getMaxValue())).append(LS);
            sb.append("### END SKETCH SUMMARY").append(LS);
        }
        return sb.toString();
    }

    static void zipSize2KBuffer(double[] bufA, int startA, double[] bufC, int startC, int k) {
        int randomOffset = QuantilesSketch.rand.nextBoolean() ? 1 : 0;
        int limC = startC + k;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += 2;
        }
    }

    static void justZipWithStride(double[] bufA, int startA, double[] bufC, int startC, int kC, int stride) {
        int randomOffset = QuantilesSketch.rand.nextInt(stride);
        int limC = startC + kC;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += stride;
        }
    }

    static void mergeTwoSizeKBuffers(double[] keySrc1, int arrStart1, double[] keySrc2, int arrStart2, double[] keyDst, int arrStart3, int k) {
        int arrStop1 = arrStart1 + k;
        int arrStop2 = arrStart2 + k;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc2[i2] < keySrc1[i1]) {
                keyDst[i3++] = keySrc2[i2++];
                continue;
            }
            keyDst[i3++] = keySrc1[i1++];
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc1, i1, keyDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc1, i2, keyDst, i3, arrStop2 - i2);
        }
    }

    static boolean sameStructurePredicate(HeapQuantilesSketch mq1, HeapQuantilesSketch mq2) {
        return mq1.getK() == mq2.getK() && mq1.getN() == mq2.getN() && mq1.getCombinedBufferAllocatedCount() == mq2.getCombinedBufferAllocatedCount() && mq1.getBaseBufferCount() == mq2.getBaseBufferCount() && mq1.getBitPattern() == mq2.getBitPattern() && mq1.getMinValue() == mq2.getMinValue() && mq1.getMaxValue() == mq2.getMaxValue();
    }

    static int bufferElementCapacity(int k, long n) {
        int maxLevels = Util.computeNumLevelsNeeded(k, n);
        if (maxLevels > 0) {
            return (2 + maxLevels) * k;
        }
        assert (n < (long)(2 * k));
        int m = Math.min(4, 2 * k);
        if (n <= (long)m) {
            return m;
        }
        int q = Util.intDivideRoundUp(n, m);
        assert (q >= 1);
        int q2 = com.yahoo.sketches.Util.ceilingPowerOf2(q);
        int x = m * q2;
        return Math.min(x, 2 * k);
    }

    private static int intDivideRoundUp(long n, int m) {
        int q = (int)n / m;
        if ((long)(q * m) == n) {
            return q;
        }
        return q + 1;
    }

    static int numValidLevels(long bitPattern) {
        return Long.bitCount(bitPattern);
    }

    static int computeBaseBufferCount(int k, long n) {
        return (int)(n % (2L * (long)k));
    }

    static long computeBitPattern(int k, long n) {
        return n / (2L * (long)k);
    }

    static double lg(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    static int computeNumLevelsNeeded(int k, long n) {
        return 1 + Util.hiBitPos(n / (2L * (long)k));
    }

    static int hiBitPos(long num) {
        return 63 - Long.numberOfLeadingZeros(num);
    }

    static int positionOfLowestZeroBitStartingAt(long numIn, int startingPos) {
        long num = numIn >>> startingPos;
        int pos = 0;
        while ((num & 1L) != 0L) {
            num >>>= 1;
            ++pos;
        }
        return pos + startingPos;
    }

    static double sumOfDoublesInSubArray(double[] arr, int subArrayStart, int subArrayLength) {
        double total = 0.0;
        int subArrayStop = subArrayStart + subArrayLength;
        for (int i = subArrayStart; i < subArrayStop; ++i) {
            total += arr[i];
        }
        return total;
    }

    static void bilinearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            double splitpoint;
            double sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && !(sample < (splitpoint = splitPoints[j])); ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    static void linearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        int numSplitPoints = splitPoints.length;
        int i = 0;
        int j = 0;
        while (i < numSamples && j < numSplitPoints) {
            if (samples[i + offset] < splitPoints[j]) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == numSplitPoints) {
            int n = numSplitPoints;
            counters[n] = counters[n] + weight * (long)(numSamples - i);
        }
    }

    static void blockyTandemMergeSort(double[] keyArr, long[] valArr, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        Util.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] keySrc, long[] valSrc, double[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        Util.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim);
        Util.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        Util.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1);
    }

    private static void tandemMerge(double[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] keyDst, long[] valDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc[i2] < keySrc[i1]) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            keyDst[i3] = keySrc[i1];
            valDst[i3] = valSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }

    static class EpsilonFromK {
        private static final double deltaForEps = 0.01;
        private static final double adjustKForEps = 1.3333333333333333;
        private static final double bracketedBinarySearchForEpsTol = 1.0E-15;

        EpsilonFromK() {
        }

        static double getAdjustedEpsilon(int k) {
            if (k == 1) {
                return 1.0;
            }
            return EpsilonFromK.getTheoreticalEpsilon(k, 1.3333333333333333);
        }

        private static double getTheoreticalEpsilon(int k, double ff) {
            if (k < 2) {
                throw new IllegalArgumentException("K must be greater than one.");
            }
            double kf = (double)k * ff;
            assert (kf >= 2.15);
            assert (kf < 1.0E12);
            double lo = 1.0E-16;
            double hi = 0.9999999999999999;
            assert (EpsilonFromK.epsForKPredicate(lo, kf));
            assert (!EpsilonFromK.epsForKPredicate(hi, kf));
            return EpsilonFromK.bracketedBinarySearchForEps(kf, lo, hi);
        }

        private static double kOfEpsFormula(double eps) {
            return 1.0 / eps * Math.sqrt(Math.log(1.0 / (eps * 0.01)));
        }

        private static boolean epsForKPredicate(double eps, double kf) {
            return EpsilonFromK.kOfEpsFormula(eps) >= kf;
        }

        private static double bracketedBinarySearchForEps(double kf, double lo, double hi) {
            assert (lo < hi);
            assert (EpsilonFromK.epsForKPredicate(lo, kf));
            assert (!EpsilonFromK.epsForKPredicate(hi, kf));
            if ((hi - lo) / lo < 1.0E-15) {
                return lo;
            }
            double mid = (lo + hi) / 2.0;
            assert (mid > lo);
            assert (mid < hi);
            if (EpsilonFromK.epsForKPredicate(mid, kf)) {
                return EpsilonFromK.bracketedBinarySearchForEps(kf, mid, hi);
            }
            return EpsilonFromK.bracketedBinarySearchForEps(kf, lo, mid);
        }
    }
}

