/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.quantiles.HeapQuantilesSketch;
import com.yahoo.sketches.quantiles.QuantilesSketch;
import com.yahoo.sketches.quantiles.Util;

public class QuantilesSketchBuilder {
    private int bK = 128;
    private short bSeed = 0;

    public QuantilesSketchBuilder setK(int k) {
        Util.checkK(k);
        this.bK = k;
        return this;
    }

    public int getK() {
        return this.bK;
    }

    public QuantilesSketchBuilder setSeed(short seed) {
        this.bSeed = seed;
        return this;
    }

    public int getSeed() {
        return this.bSeed;
    }

    public QuantilesSketch build() {
        return HeapQuantilesSketch.getInstance(this.bK, this.bSeed);
    }

    public QuantilesSketch build(int k) {
        this.setK(k);
        return this.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuantileSketchBuilder configuration:").append(Util.LS);
        sb.append("K:").append('\t').append(this.bK).append(Util.LS);
        sb.append("Seed:").append('\t').append(this.bSeed).append(Util.LS);
        return sb.toString();
    }
}

