/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.quantiles.HeapQuantilesSketch;
import com.yahoo.sketches.quantiles.QuantilesSketchBuilder;
import com.yahoo.sketches.quantiles.Util;
import java.util.Random;

public abstract class QuantilesSketch {
    static final int MIN_BASE_BUF_SIZE = 4;
    protected final int k_;
    protected final short seed_;
    protected static final Random rand = new Random();
    static final short DEFAULT_SEED = 0;
    static final int DEFAULT_K = 128;

    QuantilesSketch(int k, short seed) {
        Util.checkK(k);
        this.k_ = k;
        this.seed_ = seed;
    }

    public static final QuantilesSketchBuilder builder() {
        return new QuantilesSketchBuilder();
    }

    public abstract void update(double var1);

    public abstract double getQuantile(double var1);

    public abstract double[] getQuantiles(double[] var1);

    public abstract double[] getPMF(double[] var1);

    public abstract double[] getCDF(double[] var1);

    public abstract int getK();

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public abstract long getN();

    public double getNormalizedRankError() {
        return QuantilesSketch.getNormalizedRankError(this.getK());
    }

    public static double getNormalizedRankError(int k) {
        return Util.EpsilonFromK.getAdjustedEpsilon(k);
    }

    public abstract short getSeed();

    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    public abstract void reset();

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false);
    }

    public abstract String toString(boolean var1, boolean var2);

    public abstract QuantilesSketch downSample(int var1);

    public static QuantilesSketch heapify(Memory srcMem) {
        return HeapQuantilesSketch.getInstance(srcMem);
    }

    public int getRetainedEntries() {
        int k = this.getK();
        long n = this.getN();
        int bbCnt = Util.computeBaseBufferCount(k, n);
        long bitPattern = Util.computeBitPattern(k, n);
        int validLevels = Long.bitCount(bitPattern);
        return bbCnt + validLevels * k;
    }

    public int getStorageBytes() {
        if (this.isEmpty()) {
            return 8;
        }
        return 40 + 8 * Util.bufferElementCapacity(this.getK(), this.getN());
    }

    public abstract void putMemory(Memory var1);

    abstract int getBaseBufferCount();

    abstract int getCombinedBufferAllocatedCount();

    abstract long getBitPattern();

    abstract double[] getCombinedBuffer();
}

