/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.quantiles.Util;
import java.nio.ByteOrder;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int K_SHORT = 4;
    static final int SEED_SHORT = 6;
    static final int N_LONG = 8;
    static final int MIN_DOUBLE = 16;
    static final int MAX_DOUBLE = 24;
    static final int BUFFER_DOUBLES_ALLOC_INT = 32;
    static final int SER_VER = 1;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private PreambleUtil() {
    }

    public static String toString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.toString(mem);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.memoryToString(mem);
    }

    private static String memoryToString(Memory mem) {
        int preLongs = mem.getByte(0L) & 0xFF;
        byte serVer = mem.getByte(1L);
        byte familyID = mem.getByte(2L);
        String famName = Family.idToFamily(familyID).toString();
        byte flags = mem.getByte(3L);
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean empty = (flags & 4) > 0;
        short k = mem.getShort(4L);
        short seed = mem.getShort(6L);
        long n = 0L;
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        int bufDoublesAlloc = 0;
        int requiredBytes = 8;
        if (preLongs == 5) {
            n = mem.getLong(8L);
            minValue = mem.getDouble(16L);
            maxValue = mem.getDouble(24L);
            bufDoublesAlloc = mem.getInt(32L);
            requiredBytes = bufDoublesAlloc * 8 + 40;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### QUANTILES SKETCH PREAMBLE SUMMARY:").append(Util.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS);
        sb.append("Byte  2: Family               : ").append(famName).append(Util.LS);
        sb.append("Byte  3: Flags Field          : ").append(String.format("%02o", flags)).append(Util.LS);
        sb.append("  BIG_ENDIAN_STORAGE          : ").append(bigEndian).append(Util.LS);
        sb.append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("Bytes  4-5  : K               : ").append(k).append(Util.LS);
        sb.append("Bytes  6-7  : SEED            : ").append(seed).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
        }
        sb.append("Bytes  8-15 : N                : ").append(n).append(Util.LS);
        sb.append("Bytes 16-23 : MIN              : ").append(minValue).append(Util.LS);
        sb.append("Bytes 24-31 : MAX              : ").append(maxValue).append(Util.LS);
        sb.append("Bytes 32-35 : BUF DOUBLES      : ").append(bufDoublesAlloc).append(Util.LS);
        sb.append("TOTAL Allocated Sketch Bytes   : ").append(mem.getCapacity()).append(Util.LS);
        sb.append("TOTAL Required Sketch Bytes    : ").append(requiredBytes).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(long pre0) {
        long mask = 255L;
        return (int)(pre0 & mask);
    }

    static int extractSerVer(long pre0) {
        int shift = 8;
        long mask = 255L;
        return (int)(pre0 >>> shift & mask);
    }

    static int extractFamilyID(long pre0) {
        int shift = 16;
        long mask = 255L;
        return (int)(pre0 >>> shift & mask);
    }

    static int extractFlags(long pre0) {
        int shift = 24;
        long mask = 255L;
        return (int)(pre0 >>> shift & mask);
    }

    static int extractK(long pre1) {
        int shift = 32;
        long mask = 65535L;
        return (int)(pre1 >>> shift & mask);
    }

    static int extractSeed(long pre0) {
        int shift = 48;
        long mask = 65535L;
        return (int)(pre0 >>> shift & mask);
    }

    static int extractBufAlloc(long pre4) {
        long mask = 0xFFFFFFFFL;
        return (int)(pre4 & mask);
    }

    static long insertPreLongs(int preLongs, long pre0) {
        long mask = 255L;
        return (long)preLongs & mask | (mask ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertSerVer(int serVer, long pre0) {
        int shift = 8;
        long mask = 255L;
        return ((long)serVer & mask) << shift | (mask << shift ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertFamilyID(int familyID, long pre0) {
        int shift = 16;
        long mask = 255L;
        return ((long)familyID & mask) << shift | (mask << shift ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertFlags(int flags, long pre0) {
        int shift = 24;
        long mask = 255L;
        return ((long)flags & mask) << shift | (mask << shift ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertK(int k, long pre0) {
        int shift = 32;
        long mask = 65535L;
        return ((long)k & mask) << shift | (mask << shift ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertSeed(int seed, long pre0) {
        int shift = 48;
        long mask = 65535L;
        return ((long)seed & mask) << shift | (mask << shift ^ 0xFFFFFFFFFFFFFFFFL) & pre0;
    }

    static long insertBufAlloc(int bufAlloc, long pre4) {
        long mask = 0xFFFFFFFFL;
        return (long)bufAlloc & mask | (mask ^ 0xFFFFFFFFFFFFFFFFL) & pre4;
    }
}

