/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.quantiles.HeapQuantilesSketch;
import com.yahoo.sketches.quantiles.QuantilesSketch;
import com.yahoo.sketches.quantiles.Union;
import com.yahoo.sketches.quantiles.Util;

class HeapUnion
extends Union {
    private HeapQuantilesSketch gadget_ = null;

    HeapUnion() {
    }

    HeapUnion(QuantilesSketch sketch) {
        this.gadget_ = (HeapQuantilesSketch)sketch;
    }

    HeapUnion(Memory srcMem) {
        this.gadget_ = HeapQuantilesSketch.getInstance(srcMem);
    }

    @Override
    public void update(QuantilesSketch sketchIn) {
        this.gadget_ = HeapUnion.unionUpdateLogic(this.gadget_, (HeapQuantilesSketch)sketchIn);
    }

    @Override
    public void update(Memory srcMem) {
        HeapQuantilesSketch that = HeapQuantilesSketch.getInstance(srcMem);
        this.gadget_ = HeapUnion.unionUpdateLogic(this.gadget_, that);
    }

    @Override
    public void update(double dataItem) {
        this.gadget_.update(dataItem);
    }

    @Override
    public QuantilesSketch getResult() {
        if (this.gadget_ == null) {
            return null;
        }
        return HeapQuantilesSketch.copy(this.gadget_);
    }

    @Override
    public void reset() {
        this.gadget_ = null;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        return this.gadget_.toString(sketchSummary, dataDetail);
    }

    static HeapQuantilesSketch unionUpdateLogic(HeapQuantilesSketch qs1, HeapQuantilesSketch qs2) {
        int sw1;
        int n = qs1 == null ? 0 : (sw1 = qs1.isEmpty() ? 4 : 8);
        int n2 = qs2 == null ? 0 : (qs2.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 2;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
            }
        }
        switch (outCase) {
            case 0: {
                return null;
            }
            case 1: {
                return qs1;
            }
            case 2: {
                return HeapQuantilesSketch.copy(qs2);
            }
        }
        if (qs1.getK() <= qs2.getK()) {
            HeapUnion.mergeInto(qs2, qs1);
            return qs1;
        }
        HeapQuantilesSketch copyQS2 = HeapQuantilesSketch.copy(qs2);
        HeapUnion.mergeInto(qs1, copyQS2);
        return copyQS2;
    }

    static void mergeInto(QuantilesSketch source, QuantilesSketch target) {
        long srcBitPattern;
        double[] srcLevels;
        HeapQuantilesSketch src = (HeapQuantilesSketch)source;
        HeapQuantilesSketch tgt = (HeapQuantilesSketch)target;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long srcN = src.getN();
        long tgtN = tgt.getN();
        if (srcK != tgtK) {
            Util.downSamplingMergeInto(src, tgt);
            return;
        }
        double[] srcBaseBuffer = srcLevels = src.getCombinedBuffer();
        long nFinal = tgtN + srcN;
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(srcBaseBuffer[i]);
        }
        Util.maybeGrowLevels(nFinal, tgt);
        double[] scratchBuf = new double[2 * tgtK];
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        int srcLvl = 0;
        for (srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                Util.inPlacePropagateCarry(srcLvl, srcLevels, (2 + srcLvl) * tgtK, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * tgtK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.maxValue_ = srcMax;
        }
        if (srcMin < tgtMin) {
            tgt.minValue_ = srcMin;
        }
    }
}

