/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.quantiles.Auxiliary;
import com.yahoo.sketches.quantiles.PreambleUtil;
import com.yahoo.sketches.quantiles.QuantilesSketch;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

class HeapQuantilesSketch
extends QuantilesSketch {
    long n_;
    double minValue_;
    double maxValue_;
    int combinedBufferAllocatedCount_;
    int baseBufferCount_;
    long bitPattern_;
    double[] combinedBuffer_;

    private HeapQuantilesSketch(int k, short seed) {
        super(k, seed);
        if (seed != 0) {
            QuantilesSketch.rand.setSeed(seed);
        }
    }

    static HeapQuantilesSketch getInstance(int k, short seed) {
        HeapQuantilesSketch hqs = new HeapQuantilesSketch(k, seed);
        int bufAlloc = Math.min(4, 2 * k);
        hqs.n_ = 0L;
        hqs.combinedBufferAllocatedCount_ = bufAlloc;
        hqs.combinedBuffer_ = new double[bufAlloc];
        hqs.baseBufferCount_ = 0;
        hqs.bitPattern_ = 0L;
        hqs.minValue_ = Double.POSITIVE_INFINITY;
        hqs.maxValue_ = Double.NEGATIVE_INFINITY;
        return hqs;
    }

    static HeapQuantilesSketch getInstance(Memory srcMem) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new IllegalArgumentException("Memory too small: " + memCapBytes);
        }
        long pre0 = srcMem.getLong(0L);
        int preambleLongs = PreambleUtil.extractPreLongs(pre0);
        int serVer = PreambleUtil.extractSerVer(pre0);
        int familyID = PreambleUtil.extractFamilyID(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        int k = PreambleUtil.extractK(pre0);
        short seed = (short)PreambleUtil.extractSeed(pre0);
        boolean empty = Util.checkPreLongsFlagsCap(preambleLongs, flags, memCapBytes);
        Util.checkFamilyID(familyID);
        Util.checkSerVer(serVer);
        HeapQuantilesSketch hqs = new HeapQuantilesSketch(k, seed);
        if (empty) {
            return hqs;
        }
        long[] remainderPreArr = new long[4];
        srcMem.getLongArray(8L, remainderPreArr, 0, 4);
        long n = remainderPreArr[0];
        double minValue = Double.longBitsToDouble(remainderPreArr[1]);
        double maxValue = Double.longBitsToDouble(remainderPreArr[2]);
        int memBufAlloc = (int)remainderPreArr[3];
        Util.checkBufAllocAndCap(k, n, memBufAlloc, memCapBytes);
        hqs.n_ = n;
        hqs.combinedBufferAllocatedCount_ = memBufAlloc;
        hqs.minValue_ = minValue;
        hqs.maxValue_ = maxValue;
        hqs.baseBufferCount_ = Util.computeBaseBufferCount(k, n);
        hqs.bitPattern_ = Util.computeBitPattern(k, n);
        hqs.combinedBuffer_ = new double[memBufAlloc];
        srcMem.getDoubleArray(40L, hqs.combinedBuffer_, 0, memBufAlloc);
        return hqs;
    }

    static HeapQuantilesSketch copy(QuantilesSketch sketch) {
        HeapQuantilesSketch qsCopy = HeapQuantilesSketch.getInstance(sketch.getK(), sketch.getSeed());
        qsCopy.n_ = sketch.getN();
        qsCopy.minValue_ = sketch.getMinValue();
        qsCopy.maxValue_ = sketch.getMaxValue();
        qsCopy.combinedBufferAllocatedCount_ = sketch.getCombinedBufferAllocatedCount();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    @Override
    public void update(double dataItem) {
        if (Double.isNaN(dataItem)) {
            return;
        }
        if (dataItem > this.maxValue_) {
            this.maxValue_ = dataItem;
        }
        if (dataItem < this.minValue_) {
            this.minValue_ = dataItem;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferAllocatedCount_) {
            Util.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = dataItem;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            Util.processFullBaseBuffer(this);
        }
    }

    @Override
    public double getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.minValue_;
        }
        if (fraction == 1.0) {
            return this.maxValue_;
        }
        Auxiliary aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    @Override
    public double[] getQuantiles(double[] fractions) {
        Util.validateSequential(fractions);
        Auxiliary aux = null;
        double[] answers = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction < 0.0 || fraction > 1.0) {
                throw new IllegalArgumentException("Fraction cannot be less than zero or greater than 1.0");
            }
            if (fraction == 0.0) {
                answers[i] = this.minValue_;
                continue;
            }
            if (fraction == 1.0) {
                answers[i] = this.maxValue_;
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            answers[i] = aux.getQuantile(fraction);
        }
        return answers;
    }

    @Override
    public double[] getPMF(double[] splitPoints) {
        long[] counters = Util.internalBuildHistogram(splitPoints, this);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = this.n_;
        long subtotal = 0L;
        for (int j = 0; j < numCounters; ++j) {
            long count = counters[j];
            subtotal += count;
            result[j] = (double)count / n;
        }
        assert ((double)subtotal == n);
        return result;
    }

    @Override
    public double[] getCDF(double[] splitPoints) {
        long[] counters = Util.internalBuildHistogram(splitPoints, this);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = this.n_;
        long subtotal = 0L;
        for (int j = 0; j < numCounters; ++j) {
            long count = counters[j];
            result[j] = (double)(subtotal += count) / n;
        }
        assert ((double)subtotal == n);
        return result;
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public short getSeed() {
        return this.seed_;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        this.combinedBufferAllocatedCount_ = Math.min(4, 2 * this.k_);
        this.combinedBuffer_ = new double[this.combinedBufferAllocatedCount_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = Double.POSITIVE_INFINITY;
        this.maxValue_ = Double.NEGATIVE_INFINITY;
    }

    @Override
    public byte[] toByteArray() {
        int flags;
        int arrLongs;
        int preLongs;
        boolean empty = this.isEmpty();
        if (empty) {
            preLongs = 1;
            arrLongs = 1;
            flags = 4;
        } else {
            preLongs = 5;
            arrLongs = preLongs + this.combinedBuffer_.length;
            flags = 0;
        }
        byte[] outArr = new byte[arrLongs << 3];
        NativeMemory mem = new NativeMemory(outArr);
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(1, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.QUANTILES.getID(), pre0);
        pre0 = PreambleUtil.insertFlags(flags, pre0);
        pre0 = PreambleUtil.insertK(this.k_, pre0);
        if (empty) {
            mem.putLong(0L, pre0);
        } else {
            long[] preArr = new long[]{pre0, this.n_, Double.doubleToLongBits(this.minValue_), Double.doubleToLongBits(this.maxValue_), this.combinedBufferAllocatedCount_};
            mem.putLongArray(0L, preArr, 0, 5);
            mem.putDoubleArray(40L, this.combinedBuffer_, 0, this.combinedBuffer_.length);
        }
        return outArr;
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        return Util.toString(sketchSummary, dataDetail, this);
    }

    @Override
    public QuantilesSketch downSample(int newK) {
        HeapQuantilesSketch oldSketch = this;
        HeapQuantilesSketch newSketch = HeapQuantilesSketch.getInstance(newK, (short)0);
        Util.downSamplingMergeInto(oldSketch, newSketch);
        return newSketch;
    }

    @Override
    public void putMemory(Memory dstMem) {
        byte[] byteArr = this.toByteArray();
        int arrLen = byteArr.length;
        long memCap = dstMem.getCapacity();
        if (memCap < (long)arrLen) {
            throw new IllegalArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
        }
        dstMem.putByteArray(0L, byteArr, 0, arrLen);
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferAllocatedCount() {
        return this.combinedBufferAllocatedCount_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    Auxiliary constructAuxiliary() {
        return new Auxiliary(this);
    }
}

