/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.quantiles.HeapQuantilesSketch;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

class Auxiliary {
    long auxN_;
    double[] auxSamplesArr_;
    long[] auxCumWtsArr_;

    Auxiliary(HeapQuantilesSketch qs) {
        int k = qs.getK();
        long n = qs.getN();
        long bitPattern = qs.getBitPattern();
        double[] combinedBuffer = qs.getCombinedBuffer();
        int baseBufferCount = qs.getBaseBufferCount();
        int numSamples = qs.getRetainedEntries();
        double[] itemsArr = new double[numSamples];
        long[] cumWtsArr = new long[numSamples + 1];
        Auxiliary.populateFromQuantilesSketch(k, n, bitPattern, combinedBuffer, baseBufferCount, numSamples, itemsArr, cumWtsArr);
        Util.blockyTandemMergeSort(itemsArr, cumWtsArr, numSamples, k);
        long subtot = 0L;
        for (int i = 0; i < numSamples + 1; ++i) {
            long newSubtot = subtot + cumWtsArr[i];
            cumWtsArr[i] = subtot;
            subtot = newSubtot;
        }
        assert (subtot == n);
        this.auxN_ = n;
        this.auxSamplesArr_ = itemsArr;
        this.auxCumWtsArr_ = cumWtsArr;
    }

    double getQuantile(double phi) {
        assert (0.0 <= phi);
        assert (phi <= 1.0);
        long pos = Auxiliary.posOfPhi(phi, this.auxN_);
        return this.approximatelyAnswerPositionalQuery(pos);
    }

    private static final void populateFromQuantilesSketch(int k, long n, long bitPattern, double[] combinedBuffer, int baseBufferCount, int numSamples, double[] itemsArr, long[] cumWtsArr) {
        long bits;
        long weight = 1L;
        int nxt = 0;
        assert (bits == n / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight *= 2L;
            if ((bits & 1L) > 0L) {
                int offset = (2 + lvl) * k;
                for (int i = 0; i < k; ++i) {
                    itemsArr[nxt] = combinedBuffer[i + offset];
                    cumWtsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        for (int i = 0; i < baseBufferCount; ++i) {
            itemsArr[nxt] = combinedBuffer[i];
            cumWtsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == numSamples);
        Arrays.sort(itemsArr, startOfBaseBufferBlock, numSamples);
        cumWtsArr[numSamples] = 0L;
    }

    private static int searchForChunkContainingPos(long[] arr, long q, int l, int r) {
        assert (l < r);
        assert (arr[l] <= q);
        assert (q < arr[r]);
        if (l + 1 == r) {
            return l;
        }
        int m = l + (r - l) / 2;
        if (arr[m] <= q) {
            return Auxiliary.searchForChunkContainingPos(arr, q, m, r);
        }
        return Auxiliary.searchForChunkContainingPos(arr, q, l, m);
    }

    private static int chunkContainingPos(long[] arr, long q) {
        int nominalLength = arr.length - 1;
        assert (nominalLength > 0);
        long n = arr[nominalLength];
        assert (0L <= q);
        assert (q < n);
        int l = 0;
        int r = nominalLength;
        assert (l < r);
        assert (arr[l] <= q);
        assert (q < arr[r]);
        return Auxiliary.searchForChunkContainingPos(arr, q, l, r);
    }

    private double approximatelyAnswerPositionalQuery(long pos) {
        assert (0L <= pos);
        assert (pos < this.auxN_);
        int index = Auxiliary.chunkContainingPos(this.auxCumWtsArr_, pos);
        return this.auxSamplesArr_[index];
    }

    private static long posOfPhi(double phi, long n) {
        long pos = (long)Math.floor(phi * (double)n);
        return pos == n ? n - 1L : pos;
    }
}

