/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.memory;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.UnsafeUtil;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    public static void copy(Memory source, long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        Object srcParent;
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, source.getCapacity());
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, destination.getCapacity());
        long srcAdd = srcOffsetBytes;
        long dstAdd = dstOffsetBytes;
        Object dstParent = destination;
        for (srcParent = source; srcParent != null && srcParent instanceof Memory; srcParent = srcParent.getParent()) {
            srcAdd = srcParent.getAddress(srcAdd);
        }
        while (dstParent != null && dstParent instanceof Memory) {
            dstAdd = dstParent.getAddress(dstAdd);
            dstParent = dstParent.getParent();
        }
        while (lengthBytes > 0L) {
            long size = lengthBytes > 0x100000L ? 0x100000L : lengthBytes;
            UnsafeUtil.unsafe.copyMemory(srcParent, srcAdd, dstParent, dstAdd, lengthBytes);
            lengthBytes -= size;
            srcAdd += size;
            dstAdd += size;
        }
    }

    public static int binarySearchLongs(Memory mem, int fromLongIndex, int toLongIndex, long key) {
        UnsafeUtil.assertBounds(fromLongIndex << 3, toLongIndex - fromLongIndex << 3, mem.getCapacity());
        int low = fromLongIndex;
        int high = toLongIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = mem.getLong(mid << 3);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

