/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.hll.BucketIterator;
import com.yahoo.sketches.hll.Fields;

class HllUtils {
    HllUtils() {
    }

    static double computeInvPow2Sum(int numBuckets, BucketIterator iter) {
        double retVal = 0.0;
        while (iter.next()) {
            retVal += HllUtils.invPow2(iter.getValue());
            --numBuckets;
        }
        return retVal += (double)numBuckets;
    }

    static Fields unionBucketIterator(Fields fields, BucketIterator iter, Fields.UpdateCallback updateCallback) {
        while (iter.next()) {
            fields = fields.updateBucket(iter.getKey(), iter.getValue(), updateCallback);
        }
        return fields;
    }

    static final double invPow2(int e) {
        assert ((e | 1024 - e - 1) >= 0) : "e cannot be negative or greater than 1023: " + e;
        return Double.longBitsToDouble(1023L - (long)e << 52);
    }
}

