/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.Util;
import com.yahoo.sketches.hll.DenseCompressedFieldsFactory;
import com.yahoo.sketches.hll.DenseFieldsFactory;
import com.yahoo.sketches.hll.Fields;
import com.yahoo.sketches.hll.FieldsFactory;
import com.yahoo.sketches.hll.HashUtils;
import com.yahoo.sketches.hll.HipHllSketch;
import com.yahoo.sketches.hll.HllSketch;
import com.yahoo.sketches.hll.OnHeapHashFields;
import com.yahoo.sketches.hll.Preamble;

public class HllSketchBuilder {
    private Preamble preamble = Preamble.fromLogK(Integer.numberOfTrailingZeros(4096));
    private boolean compressedDense = false;
    private boolean denseMode = false;
    private boolean hipEstimator = false;

    public HllSketchBuilder copy() {
        HllSketchBuilder retVal = new HllSketchBuilder();
        retVal.preamble = this.preamble;
        retVal.compressedDense = this.compressedDense;
        retVal.denseMode = this.denseMode;
        retVal.hipEstimator = this.hipEstimator;
        return retVal;
    }

    public HllSketchBuilder setLogBuckets(int logBuckets) {
        this.preamble = Preamble.fromLogK((byte)logBuckets);
        return this;
    }

    public int getLogBuckets() {
        return this.preamble.getLogConfigK();
    }

    public HllSketchBuilder setPreamble(Preamble preamble) {
        this.preamble = preamble;
        return this;
    }

    public Preamble getPreamble() {
        return this.preamble;
    }

    public HllSketchBuilder setDenseMode(boolean denseMode) {
        this.denseMode = denseMode;
        return this;
    }

    public boolean isDenseMode() {
        return this.denseMode;
    }

    public HllSketchBuilder setCompressedDense(boolean compressedDense) {
        this.compressedDense = compressedDense;
        return this;
    }

    public boolean isCompressedDense() {
        return this.compressedDense;
    }

    public HllSketchBuilder setHipEstimator(boolean hipEstimator) {
        this.hipEstimator = hipEstimator;
        return this;
    }

    public boolean isHipEstimator() {
        return this.hipEstimator;
    }

    public HllSketch build() {
        FieldsFactory denseFactory = this.compressedDense ? new DenseCompressedFieldsFactory() : new DenseFieldsFactory();
        Fields fields = this.denseMode ? denseFactory.make(this.preamble) : new OnHeapHashFields(this.preamble, 16, HashUtils.MAX_HASH_SIZE[this.preamble.getLogConfigK()], denseFactory);
        if (this.hipEstimator) {
            return new HipHllSketch(fields);
        }
        return new HllSketch(fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HllSketchBuilder configuration:").append(Util.LS).append("LgK:").append('\t').append(this.preamble.getLogConfigK()).append(Util.LS).append("K:").append('\t').append(this.preamble.getConfigK()).append(Util.LS).append("DenseMode:").append('\t').append(this.denseMode).append(Util.LS).append("HIP Estimator:").append('\t').append(this.hipEstimator).append(Util.LS).append("Compressed Dense:").append('\t').append(this.compressedDense).append(Util.LS);
        return sb.toString();
    }
}

