/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

public final class Util {
    public static final int MIN_LG_ARR_LONGS = 5;
    public static final int MIN_LG_NOM_LONGS = 4;
    public static final double REBUILD_THRESHOLD = 0.9375;
    public static final double RESIZE_THRESHOLD = 0.5;
    public static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    public static final long DEFAULT_UPDATE_SEED = 9001L;
    public static final String LS = System.getProperty("line.separator");
    public static final char TAB = '\t';
    private static final int IntTopPwrOf2 = 0x40000000;

    private Util() {
    }

    public static void checkIfMultipleOf8AndGT0(long v, String argName) {
        if ((v & 7L) == 0L && v > 0L) {
            return;
        }
        throw new IllegalArgumentException("The value of the parameter \"" + argName + "\" must be a positive multiple of 8 and greater than zero: " + v);
    }

    public static boolean isMultipleOf8AndGT0(long v) {
        return (v & 7L) == 0L && v > 0L;
    }

    public static boolean isPowerOf2(int v) {
        return v > 0 && (v & v - 1) == 0;
    }

    public static void checkIfPowerOf2(int v, String argName) {
        if (v > 0 && (v & v - 1) == 0) {
            return;
        }
        throw new IllegalArgumentException("The value of the parameter \"" + argName + "\" must be a positive integer-power of 2" + " and greater than 0: " + v);
    }

    public static void checkProbability(double p, String argName) {
        if (p >= 0.0 && p <= 1.0) {
            return;
        }
        throw new IllegalArgumentException("The value of the parameter \"" + argName + "\" must be between 0.0 inclusive and 1.0 inclusive: " + p);
    }

    public static int ceilingPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        if (n >= 0x40000000) {
            return 0x40000000;
        }
        int floor = Util.floorPowerOf2(n);
        if (n == floor) {
            return n;
        }
        return floor << 1;
    }

    public static int floorPowerOf2(int n) {
        if (n <= 0) {
            return 1;
        }
        return Integer.highestOneBit(n);
    }

    public static boolean isLessThanUnsigned(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }

    public static final String zeroPad(String s, int fieldLength) {
        char[] chArr = s.toCharArray();
        int sLen = chArr.length;
        if (sLen < fieldLength) {
            int i;
            char[] out = new char[fieldLength];
            int zeros = fieldLength - sLen;
            for (i = 0; i < zeros; ++i) {
                out[i] = 48;
            }
            for (i = zeros; i < fieldLength; ++i) {
                out[i] = chArr[i - zeros];
            }
            return String.valueOf(out);
        }
        return s;
    }
}

