/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.Bounds;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.DirectQuickSelectSketch;
import com.yahoo.sketches.theta.ForwardCompatibility;
import com.yahoo.sketches.theta.HeapAlphaSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactSketch;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.UpdateSketch;

public abstract class Sketch {
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;

    Sketch() {
    }

    public double getEstimate() {
        return Sketch.estimate(this.getThetaLong(), this.getRetainedEntries(true), this.isEmpty());
    }

    public double getLowerBound(int numStdDev) {
        return Sketch.lowerBound(numStdDev, this.getThetaLong(), this.getRetainedEntries(true), this.isEmpty());
    }

    public abstract int getRetainedEntries(boolean var1);

    public double getTheta() {
        return (double)this.getThetaLong() / 9.223372036854776E18;
    }

    public double getUpperBound(int numStdDev) {
        return Sketch.upperBound(numStdDev, this.getThetaLong(), this.getRetainedEntries(true), this.isEmpty());
    }

    public abstract boolean isEmpty();

    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false, 8, true);
    }

    public String toString(boolean sketchSummary, boolean dataDetail, int width, boolean hexMode) {
        StringBuilder sb = new StringBuilder();
        long[] cache = this.getCache();
        int nomLongs = 0;
        int arrLongs = cache.length;
        long seed = 0L;
        float p = 0.0f;
        int rf = 0;
        boolean updateSketch = this instanceof UpdateSketch;
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        if (updateSketch) {
            UpdateSketch uis = (UpdateSketch)this;
            nomLongs = 1 << uis.getLgNomLongs();
            seed = uis.getSeed();
            arrLongs = 1 << uis.getLgArrLongs();
            p = uis.getP();
            rf = 1 << uis.getLgResizeFactor();
        }
        if (dataDetail) {
            int w;
            int n = w = width > 0 ? width : 8;
            if (curCount > 0) {
                sb.append("### SKETCH DATA DETAIL");
                int j = 0;
                for (int i = 0; i < arrLongs; ++i) {
                    long h = cache[i];
                    if (h <= 0L || h >= thetaLong) continue;
                    if (j % w == 0) {
                        sb.append(Util.LS).append(String.format("   %6d", j + 1));
                    }
                    if (hexMode) {
                        sb.append(" " + Util.zeroPad(Long.toHexString(h), 16) + ",");
                    } else {
                        sb.append(String.format(" %20d,", h));
                    }
                    ++j;
                }
                sb.append(Util.LS).append("### END DATA DETAIL").append(Util.LS + Util.LS);
            }
        }
        if (sketchSummary) {
            double thetaDbl = (double)thetaLong / 9.223372036854776E18;
            String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
            String thisSimpleName = this.getClass().getSimpleName();
            short seedHash = this.getSeedHash();
            sb.append(Util.LS);
            sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            if (updateSketch) {
                sb.append("   Nominal Entries (k)     : ").append(nomLongs).append(Util.LS);
            }
            sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
            sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
            sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
            if (updateSketch) {
                sb.append("   p                       : ").append(p).append(Util.LS);
            }
            sb.append("   Theta (double)          : ").append(thetaDbl).append(Util.LS);
            sb.append("   Theta (long)            : ").append(thetaLong).append(Util.LS);
            sb.append("   Theta (long, hex        : ").append(thetaHex).append(Util.LS);
            sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
            sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
            if (updateSketch) {
                sb.append("   Resize Factor           : ").append(rf).append(Util.LS);
            }
            sb.append("   Array Size Entries      : ").append(arrLongs).append(Util.LS);
            sb.append("   Retained Entries        : ").append(curCount).append(Util.LS);
            if (updateSketch) {
                sb.append("   Update Seed             : ").append(Long.toString(seed)).append(Util.LS);
            }
            sb.append("   Seed Hash               : ").append(Integer.toHexString(seedHash)).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }

    public static Sketch heapify(Memory srcMem) {
        return Sketch.heapify(srcMem, 9001L);
    }

    public static Sketch heapify(Memory srcMem, long seed) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 3) {
            byte famID = srcMem.getByte(2L);
            boolean ordered = srcMem.isAnyBitsSet(5L, (byte)16);
            return Sketch.constructHeapSketch(famID, ordered, srcMem, seed);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seed);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seed);
        }
        throw new IllegalArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static Sketch wrap(Memory srcMem) {
        return Sketch.wrap(srcMem, 9001L);
    }

    public static Sketch wrap(Memory srcMem, long seed) {
        byte serVer = srcMem.getByte(1L);
        if (serVer < 3) {
            throw new IllegalArgumentException("Sketch cannot wrap Serialization Versions 1 or 2.");
        }
        byte famID = srcMem.getByte(2L);
        boolean ordered = srcMem.isAnyBitsSet(5L, (byte)16);
        return Sketch.constructDirectSketch(famID, ordered, srcMem, seed);
    }

    public int getCurrentBytes(boolean compact) {
        int preBytes = this.getCurrentPreambleLongs(compact) << 3;
        int dataBytes = this.getCurrentDataLongs(compact) << 3;
        return preBytes + dataBytes;
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        return (numberOfEntries << 3) + (Family.COMPACT.getMaxPreLongs() << 3);
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        Util.checkIfPowerOf2(nomEntries, "nomEntries");
        return (nomEntries << 4) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public static int getSerializationVersion(Memory mem) {
        return mem.getByte(1L);
    }

    public abstract boolean isCompact();

    public abstract boolean isOrdered();

    public abstract boolean isDirect();

    final int getCurrentDataLongs(boolean compact) {
        int longs = this instanceof CompactSketch || compact ? this.getRetainedEntries(true) : 1 << ((UpdateSketch)this).getLgArrLongs();
        return longs;
    }

    final int getCurrentPreambleLongs(boolean compact) {
        return compact ? Sketch.compactPreambleLongs(this.getThetaLong(), this.isEmpty()) : this.getPreambleLongs();
    }

    static final int compactPreambleLongs(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : 2);
    }

    abstract int getPreambleLongs();

    abstract short getSeedHash();

    abstract long getThetaLong();

    abstract long[] getCache();

    abstract Memory getMemory();

    static final boolean estMode(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE && !empty;
    }

    static final double estimate(long thetaLong, int curCount, boolean empty) {
        if (Sketch.estMode(thetaLong, empty)) {
            double theta = (double)thetaLong / 9.223372036854776E18;
            return (double)curCount / theta;
        }
        return curCount;
    }

    static final double lowerBound(int numStdDev, long thetaLong, int curCount, boolean empty) {
        if (numStdDev < 1 || numStdDev > 3) {
            throw new IllegalArgumentException("numStdDev can only be the values 1, 2 or 3: " + numStdDev);
        }
        double theta = (double)thetaLong / 9.223372036854776E18;
        return Bounds.approxLBforUsers(curCount, theta, numStdDev, empty);
    }

    static final double upperBound(int numStdDev, long thetaLong, int curCount, boolean empty) {
        if (numStdDev < 1 || numStdDev > 3) {
            throw new IllegalArgumentException("numStdDev can only be the values 1, 2 or 3:" + numStdDev);
        }
        double theta = (double)thetaLong / 9.223372036854776E18;
        return Bounds.approxUBforUsers(curCount, theta, numStdDev, empty);
    }

    private static final Sketch constructDirectSketch(byte famID, boolean ordered, Memory srcMem, long seed) {
        boolean compact = srcMem.isAnyBitsSet(5L, (byte)8);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case QUICKSELECT: {
                if (compact) {
                    throw new IllegalArgumentException("Corrupted " + (Object)((Object)family) + " image: cannot be compact");
                }
                return new DirectQuickSelectSketch(srcMem, seed);
            }
            case COMPACT: {
                if (!compact) {
                    throw new IllegalArgumentException("Corrupted " + (Object)((Object)family) + " image: must be compact");
                }
                return ordered ? new DirectCompactOrderedSketch(srcMem) : new DirectCompactSketch(srcMem);
            }
        }
        throw new IllegalArgumentException("Sketch cannot wrap family: " + (Object)((Object)family) + " as a Sketch");
    }

    private static final Sketch constructHeapSketch(byte famID, boolean ordered, Memory srcMem, long seed) {
        boolean compact = srcMem.isAnyBitsSet(5L, (byte)8);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case ALPHA: {
                if (compact) {
                    throw new IllegalArgumentException("Corrupted " + (Object)((Object)family) + " image: cannot be compact");
                }
                return new HeapAlphaSketch(srcMem, seed);
            }
            case QUICKSELECT: {
                if (compact) {
                    throw new IllegalArgumentException("Corrupted " + (Object)((Object)family) + " image: cannot be compact");
                }
                return new HeapQuickSelectSketch(srcMem, seed);
            }
            case COMPACT: {
                if (!compact) {
                    throw new IllegalArgumentException("Corrupted " + (Object)((Object)family) + " image: must be compact");
                }
                return ordered ? new HeapCompactOrderedSketch(srcMem) : new HeapCompactSketch(srcMem);
            }
        }
        throw new IllegalArgumentException("Sketch cannot heapify family: " + (Object)((Object)family) + " as a Sketch");
    }
}

