/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import java.nio.ByteOrder;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int LG_NOM_LONGS_BYTE = 3;
    static final int LG_ARR_LONGS_BYTE = 4;
    static final int FLAGS_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int RETAINED_ENTRIES_INT = 8;
    static final int P_FLOAT = 12;
    static final int THETA_LONG = 16;
    static final int UNION_THETA_LONG = 24;
    static final int FLAGS_BYTE_V1 = 6;
    static final int LG_RESIZE_RATIO_BYTE_V1 = 5;
    static final int SER_VER = 3;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final double MAX_THETA_LONG_AS_DOUBLE = 9.223372036854776E18;

    private PreambleUtil() {
    }

    public static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new IllegalArgumentException("The given seed: " + seed + " produced a seedHash of zero. " + "You must choose a different seed.");
        }
        return seedHash;
    }

    public static final void checkSeedHashes(short seedHashA, short seedHashB) {
        if (seedHashA != seedHashB) {
            throw new IllegalArgumentException("Incompatible Seed Hashes. " + seedHashA + ", " + seedHashB);
        }
    }

    public static String toString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.toString(mem);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.memoryToString(mem);
    }

    private static String memoryToString(Memory mem) {
        long thetaLong;
        int preLongs = mem.getByte(0L) & 0x3F;
        byte serVer = mem.getByte(1L);
        byte familyID = mem.getByte(2L);
        String famName = Family.idToFamily(familyID).toString();
        byte lgNomLongs = mem.getByte(3L);
        byte lgArrLongs = mem.getByte(4L);
        byte flags = mem.getByte(5L);
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        short seedHash = mem.getShort(6L);
        int curCount = 0;
        float p = 1.0f;
        long thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        if (preLongs == 2) {
            curCount = mem.getInt(8L);
            p = mem.getFloat(12L);
            thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        } else if (preLongs == 3) {
            curCount = mem.getInt(8L);
            p = mem.getFloat(12L);
            thetaULong = thetaLong = mem.getLong(16L);
        } else if (preLongs == 4) {
            curCount = mem.getInt(8L);
            p = mem.getFloat(12L);
            thetaLong = mem.getLong(16L);
            thetaULong = mem.getLong(24L);
        }
        double thetaDbl = (double)thetaLong / 9.223372036854776E18;
        String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
        double thetaUDbl = (double)thetaULong / 9.223372036854776E18;
        String thetaUHex = Util.zeroPad(Long.toHexString(thetaULong), 16);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### SKETCH PREAMBLE SUMMARY:").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(famName).append(Util.LS).append("Byte  3: LgNomLongs           : ").append(lgNomLongs).append(Util.LS).append("Byte  4: LgArrLongs           : ").append(lgArrLongs).append(Util.LS).append("Byte  5: Flags Field          : ").append(String.format("%02o", flags)).append(Util.LS).append("  BIG_ENDIAN_STORAGE          : ").append(bigEndian).append(Util.LS).append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS).append("  READ_ONLY                   : ").append(readOnly).append(Util.LS).append("  EMPTY                       : ").append(empty).append(Util.LS).append("  COMPACT                     : ").append(compact).append(Util.LS).append("  ORDERED                     : ").append(ordered).append(Util.LS).append("Bytes 6-7  : Seed Hash        : ").append(Integer.toHexString(seedHash)).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-24: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-32: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        if (preLongs == 2) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 16-24: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-32: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        if (preLongs == 3) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-24: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 25-32: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        if (preLongs == 4) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-24: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-32: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        sb.append("TOTAL Sketch Bytes            : ").append(mem.getCapacity()).append(Util.LS).append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }
}

