/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.HashOperations;
import com.yahoo.sketches.theta.HeapUpdateSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.ResizeFactor;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;
import java.util.Arrays;

class HeapQuickSelectSketch
extends HeapUpdateSketch {
    static final int HQS_MIN_LG_ARR_LONGS = 5;
    static final int HQS_MIN_LG_NOM_LONGS = 4;
    static final double HQS_REBUILD_THRESHOLD = 0.9375;
    static final double HQS_RESIZE_THRESHOLD = 0.5;
    private final Family MY_FAMILY;
    private final int preambleLongs_;
    private long[] cache_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private boolean dirty_;

    HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, boolean unionGadget) {
        super(lgNomLongs, seed, p, rf);
        if (this.lgNomLongs_ < 4) {
            throw new IllegalArgumentException("This sketch requires a minimum nominal entries of 16");
        }
        if (unionGadget) {
            this.preambleLongs_ = Family.UNION.getMinPreLongs();
            this.MY_FAMILY = Family.UNION;
        } else {
            this.preambleLongs_ = Family.QUICKSELECT.getMinPreLongs();
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.lgArrLongs_ = HeapQuickSelectSketch.startingSubMultiple(this.lgNomLongs_ + 1, rf, 5);
        this.cache_ = new long[1 << this.lgArrLongs_];
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)p * 9.223372036854776E18);
        this.dirty_ = false;
    }

    HeapQuickSelectSketch(Memory srcMem, long seed) {
        super(srcMem.getByte(3L), seed, srcMem.getFloat(12L), ResizeFactor.getRF(srcMem.getByte(0L) >>> 6));
        short seedHashMem = srcMem.getShort(6L);
        short seedHashArg = PreambleUtil.computeSeedHash(seed);
        PreambleUtil.checkSeedHashes(seedHashMem, seedHashArg);
        byte familyID = srcMem.getByte(2L);
        if (familyID == Family.UNION.getID()) {
            this.preambleLongs_ = Family.UNION.getMinPreLongs() & 0x3F;
            this.MY_FAMILY = Family.UNION;
        } else {
            this.preambleLongs_ = Family.QUICKSELECT.getMinPreLongs() & 0x3F;
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.lgArrLongs_ = srcMem.getByte(4L);
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.curCount_ = srcMem.getInt(8L);
        this.thetaLong_ = srcMem.getLong(16L);
        this.empty_ = srcMem.isAnyBitsSet(5L, (byte)4);
        this.dirty_ = false;
        this.cache_ = new long[1 << this.lgArrLongs_];
        srcMem.getLongArray(this.preambleLongs_ << 3, this.cache_, 0, 1 << this.lgArrLongs_);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.preambleLongs_, (byte)this.MY_FAMILY.getID());
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            this.quickSelectAndRebuild();
        }
        return this;
    }

    @Override
    public final void reset() {
        int lgArrLongsSM = HeapQuickSelectSketch.startingSubMultiple(this.lgNomLongs_ + 1, this.rf_, 5);
        if (lgArrLongsSM == this.lgArrLongs_) {
            int arrLongs = this.cache_.length;
            assert (1 << this.lgArrLongs_ == arrLongs);
            Arrays.fill(this.cache_, 0L);
        } else {
            this.cache_ = new long[1 << lgArrLongsSM];
            this.lgArrLongs_ = lgArrLongsSM;
        }
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)this.p_ * 9.223372036854776E18);
    }

    @Override
    int getPreambleLongs() {
        return this.preambleLongs_;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return this.dirty_;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        this.empty_ = false;
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        boolean inserted = HashOperations.hashInsert(this.cache_, this.lgArrLongs_, hash);
        if (inserted) {
            ++this.curCount_;
            if (this.curCount_ > this.hashTableThreshold_) {
                if (this.lgArrLongs_ <= this.lgNomLongs_) {
                    this.resizeCache();
                } else {
                    assert (this.lgArrLongs_ == this.lgNomLongs_ + 1) : "lgArr: " + this.lgArrLongs_ + ", lgNom: " + this.lgNomLongs_;
                    this.quickSelectAndRebuild();
                }
            }
            return UpdateReturnState.InsertedCountIncremented;
        }
        return UpdateReturnState.RejectedDuplicate;
    }

    private final void resizeCache() {
        int lgTgtLongs = this.lgNomLongs_ + 1;
        int lgDeltaLongs = lgTgtLongs - this.lgArrLongs_;
        int lgResizeFactor = Math.max(Math.min(this.rf_.lg(), lgDeltaLongs), 1);
        this.lgArrLongs_ += lgResizeFactor;
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        int newCount = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        assert (newCount == this.curCount_);
        this.curCount_ = newCount;
        this.cache_ = tgtArr;
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void quickSelectAndRebuild() {
        int arrLongs = 1 << this.lgArrLongs_;
        int pivot = (1 << this.lgNomLongs_) + 1;
        this.thetaLong_ = QuickSelect.selectExcludingZeros(this.cache_, this.curCount_, pivot);
        long[] tgtArr = new long[arrLongs];
        this.curCount_ = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        this.cache_ = tgtArr;
    }

    static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.5 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

