/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.ResizeFactor;
import com.yahoo.sketches.theta.UpdateSketch;

abstract class DirectUpdateSketch
extends UpdateSketch {
    final long seed_;
    final int lgNomLongs_;
    final float p_;
    final ResizeFactor rf_;

    DirectUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        this.seed_ = seed;
        this.lgNomLongs_ = lgNomLongs;
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public abstract byte[] toByteArray();

    @Override
    public boolean isCompact() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    abstract int getPreambleLongs();

    @Override
    int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    int getLgResizeFactor() {
        return this.rf_.lg();
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    short getSeedHash() {
        return PreambleUtil.computeSeedHash(this.getSeed());
    }

    @Override
    abstract long[] getCache();
}

