/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactSketch;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

public abstract class CompactSketch
extends Sketch {
    final short seedHash_;
    final boolean empty_;
    final int curCount_;
    final long thetaLong_;

    CompactSketch(boolean empty, short seedHash, int curCount, long thetaLong) {
        this.empty_ = empty;
        this.seedHash_ = seedHash;
        this.curCount_ = curCount;
        this.thetaLong_ = thetaLong;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    int getPreambleLongs() {
        return CompactSketch.compactPreambleLongs(this.getThetaLong(), this.isEmpty());
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final CompactSketch createCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, boolean dstOrdered, Memory dstMem) {
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = new HeapCompactSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 1: {
                sketchOut = new DirectCompactSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
                break;
            }
            case 2: {
                sketchOut = new HeapCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 3: {
                sketchOut = new DirectCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
            }
        }
        return sketchOut;
    }

    static final Memory loadCompactMemory(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem, byte flags) {
        int dstBytes;
        int preLongs = CompactSketch.compactPreambleLongs(thetaLong, empty);
        int preBytes = preLongs << 3;
        int outBytes = (curCount << 3) + preBytes;
        if (outBytes > (dstBytes = (int)dstMem.getCapacity())) {
            throw new IllegalArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte fam = (byte)Family.stringToFamily("Compact").getID();
        dstMem.clear(0L, outBytes);
        dstMem.putByte(0L, (byte)preLongs);
        dstMem.putByte(1L, (byte)3);
        dstMem.putByte(2L, fam);
        dstMem.putByte(5L, flags);
        dstMem.putShort(6L, seedHash);
        if (preLongs > 1) {
            dstMem.putInt(8L, curCount);
            dstMem.putFloat(12L, 1.0f);
        }
        if (preLongs > 2) {
            dstMem.putLong(16L, thetaLong);
        }
        if (compactCache != null && curCount > 0) {
            dstMem.putLongArray(preBytes, compactCache, 0, compactCache.length);
        }
        return dstMem;
    }

    static final int getCurCount(Memory srcMem) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
        return curCount;
    }

    static final long getThetaLong(Memory srcMem) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        long thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        return thetaLong;
    }
}

