/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.theta.EquivTables;

final class Bounds {
    private static double[] deltaOfNumSDev = new double[]{0.5, 0.15865531915860265, 0.02275026189041357, 0.0013498126861731796};

    private Bounds() {
    }

    private static double contClassicLB(double numSamplesF, double theta, double numSDev) {
        double nHat = (numSamplesF - 0.5) / theta;
        double b = numSDev * Math.sqrt((1.0 - theta) / theta);
        double d = 0.5 * b * Math.sqrt(b * b + 4.0 * nHat);
        double center = nHat + 0.5 * (b * b);
        return center - d;
    }

    private static double contClassicUB(double numSamplesF, double theta, double numSDev) {
        double nHat = (numSamplesF + 0.5) / theta;
        double b = numSDev * Math.sqrt((1.0 - theta) / theta);
        double d = 0.5 * b * Math.sqrt(b * b + 4.0 * nHat);
        double center = nHat + 0.5 * (b * b);
        return center + d;
    }

    private static long specialNStar(long numSamplesI, double p, double delta) {
        Bounds.assertTrue(numSamplesI >= 1L);
        Bounds.assertTrue(0.0 < p && p < 1.0);
        Bounds.assertTrue(0.0 < delta && delta < 1.0);
        double q = 1.0 - p;
        double numSamplesF = numSamplesI;
        Bounds.assertTrue(numSamplesF / p < 500.0);
        double curTerm = Math.pow(p, numSamplesF);
        Bounds.assertTrue(curTerm > 1.0E-100);
        double tot = curTerm;
        long m = numSamplesI;
        while (tot <= delta) {
            curTerm = curTerm * q * (double)m / (double)(m + 1L - numSamplesI);
            tot += curTerm;
            ++m;
        }
        return m - 1L;
    }

    private static long specialNPrimeB(long numSamplesI, double p, double delta) {
        Bounds.assertTrue(numSamplesI >= 1L);
        Bounds.assertTrue(0.0 < p && p < 1.0);
        Bounds.assertTrue(0.0 < delta && delta < 1.0);
        double q = 1.0 - p;
        double oneMinusDelta = 1.0 - delta;
        double numSamplesF = numSamplesI;
        double curTerm = Math.pow(p, numSamplesF);
        Bounds.assertTrue(curTerm > 1.0E-100);
        double tot = curTerm;
        long m = numSamplesI;
        while (tot < oneMinusDelta) {
            curTerm = curTerm * q * (double)m / (double)(m + 1L - numSamplesI);
            tot += curTerm;
            ++m;
        }
        return m;
    }

    private static long specialNPrimeF(long numSamplesI, double p, double delta) {
        Bounds.assertTrue((double)numSamplesI / p < 500.0);
        return Bounds.specialNPrimeB(numSamplesI + 1L, p, delta);
    }

    private static double computeApproxBinoLB(long numSamplesI, double theta, int numSDev) {
        Bounds.assertTrue(numSDev >= 1 && numSDev <= 3);
        Bounds.assertTrue(numSamplesI >= 0L);
        Bounds.assertTrue(0.0 < theta && theta <= 1.0);
        if (theta == 1.0) {
            return numSamplesI;
        }
        if (numSamplesI == 0L) {
            return 0.0;
        }
        if (numSamplesI == 1L) {
            double delta = deltaOfNumSDev[numSDev];
            double rawLB = Math.log(1.0 - delta) / Math.log(1.0 - theta);
            return Math.floor(rawLB);
        }
        if (numSamplesI > 120L) {
            double rawLB = Bounds.contClassicLB(numSamplesI, theta, numSDev);
            return rawLB - 0.5;
        }
        if (theta > 0.99999) {
            return numSamplesI;
        }
        if (theta < (double)numSamplesI / 360.0) {
            int index = 3 * (int)numSamplesI + (numSDev - 1);
            double rawLB = Bounds.contClassicLB(numSamplesI, theta, EquivTables.lbEquivTable[index]);
            return rawLB - 0.5;
        }
        double delta = deltaOfNumSDev[numSDev];
        long nstar = Bounds.specialNStar(numSamplesI, theta, delta);
        return nstar;
    }

    private static double computeApproxBinoUB(long numSamplesI, double theta, int numSDev) {
        Bounds.assertTrue(numSDev >= 1 && numSDev <= 3);
        Bounds.assertTrue(numSamplesI >= 0L);
        Bounds.assertTrue(0.0 < theta && theta <= 1.0);
        if (theta == 1.0) {
            return numSamplesI;
        }
        if (numSamplesI == 0L) {
            double delta = deltaOfNumSDev[numSDev];
            double rawUB = Math.log(delta) / Math.log(1.0 - theta);
            return Math.ceil(rawUB);
        }
        if (numSamplesI > 120L) {
            double rawUB = Bounds.contClassicUB(numSamplesI, theta, numSDev);
            return rawUB + 0.5;
        }
        if (theta > 0.99999) {
            return numSamplesI + 1L;
        }
        if (theta < (double)numSamplesI / 360.0) {
            int index = 3 * (int)numSamplesI + (numSDev - 1);
            double rawUB = Bounds.contClassicUB(numSamplesI, theta, EquivTables.ubEquivTable[index]);
            return rawUB + 0.5;
        }
        double delta = deltaOfNumSDev[numSDev];
        long nprimef = Bounds.specialNPrimeF(numSamplesI, theta, delta);
        return nprimef;
    }

    public static double approxLBforUsers(long numSamplesI, double theta, int numSDev, boolean noDataSeen) {
        if (noDataSeen) {
            return 0.0;
        }
        double lb = Bounds.computeApproxBinoLB(numSamplesI, theta, numSDev);
        double numSamplesF = numSamplesI;
        double est = numSamplesF / theta;
        return Math.min(est, Math.max(numSamplesF, lb));
    }

    public static double approxUBforUsers(long numSamplesI, double theta, int numSDev, boolean noDataSeen) {
        if (noDataSeen) {
            return 0.0;
        }
        double ub = Bounds.computeApproxBinoUB(numSamplesI, theta, numSDev);
        double numSamplesF = numSamplesI;
        double est = numSamplesF / theta;
        return Math.max(est, ub);
    }

    private static void assertTrue(boolean truth) {
        assert (truth);
    }
}

