/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.memory;

import java.lang.reflect.Constructor;
import sun.misc.Unsafe;

final class UnsafeUtil {
    static final Unsafe unsafe;
    static final JDKCompatibility compatibilityMethods;
    static final int ADDRESS_BYTES;
    static final int BOOLEAN_ARRAY_BASE_OFFSET;
    static final int BYTE_ARRAY_BASE_OFFSET;
    static final int CHAR_ARRAY_BASE_OFFSET;
    static final int DOUBLE_ARRAY_BASE_OFFSET;
    static final int FLOAT_ARRAY_BASE_OFFSET;
    static final int INT_ARRAY_BASE_OFFSET;
    static final int LONG_ARRAY_BASE_OFFSET;
    static final int SHORT_ARRAY_BASE_OFFSET;
    static final int BOOLEAN_SIZE = 1;
    static final int BYTE_SIZE = 1;
    static final int CHAR_SIZE = 2;
    static final int DOUBLE_SIZE = 8;
    static final int FLOAT_SIZE = 4;
    static final int INT_SIZE = 4;
    static final int LONG_SIZE = 8;
    static final int SHORT_SIZE = 2;
    static final int BOOLEAN_SHIFT = 0;
    static final int BYTE_SHIFT = 0;
    static final int CHAR_SHIFT = 1;
    static final int DOUBLE_SHIFT = 3;
    static final int FLOAT_SHIFT = 2;
    static final int INT_SHIFT = 2;
    static final int LONG_SHIFT = 3;
    static final int SHORT_SHIFT = 1;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeUtil() {
    }

    static void assertBounds(long reqOff, long reqLen, long allocSize) {
        assert ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) >= 0L) : "offset: " + reqOff + ", reqLength: " + reqLen + ", size: " + allocSize;
    }

    static boolean checkOverlap(long srcOff, long dstOff, long length) {
        long max;
        long min = Math.min(srcOff, dstOff);
        return min + length <= (max = Math.max(srcOff, dstOff));
    }

    static {
        try {
            Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
            ADDRESS_BYTES = unsafe.addressSize();
            BOOLEAN_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
            BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
            CHAR_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
            DOUBLE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
            FLOAT_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
            INT_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
            LONG_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
            SHORT_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
            boolean onJDK8 = true;
            try {
                unsafe.getClass().getMethod("getAndSetInt", Object.class, Long.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                onJDK8 = false;
            }
            compatibilityMethods = onJDK8 ? new JDK8Compatible(unsafe) : new JDK7Compatible(unsafe);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to acquire Unsafe. ", e);
        }
    }

    private static class JDK7Compatible
    implements JDKCompatibility {
        private final Unsafe myUnsafe;

        JDK7Compatible(Unsafe unsafe) {
            this.myUnsafe = unsafe;
        }

        @Override
        public int getAndAddInt(Object obj, long address, int increment) {
            int retVal;
            while (!this.myUnsafe.compareAndSwapInt(obj, address, retVal = this.myUnsafe.getIntVolatile(obj, address), retVal + increment)) {
            }
            return retVal;
        }

        @Override
        public int getAndSetInt(Object obj, long address, int value) {
            int retVal;
            while (!this.myUnsafe.compareAndSwapInt(obj, address, retVal = this.myUnsafe.getIntVolatile(obj, address), value)) {
            }
            return retVal;
        }

        @Override
        public long getAndAddLong(Object obj, long address, long increment) {
            long retVal;
            while (!this.myUnsafe.compareAndSwapLong(obj, address, retVal = this.myUnsafe.getLongVolatile(obj, address), retVal + increment)) {
            }
            return retVal;
        }

        @Override
        public long getAndSetLong(Object obj, long address, long value) {
            long retVal;
            while (!this.myUnsafe.compareAndSwapLong(obj, address, retVal = this.myUnsafe.getLongVolatile(obj, address), value)) {
            }
            return retVal;
        }
    }

    private static class JDK8Compatible
    implements JDKCompatibility {
        private final Unsafe myUnsafe;

        JDK8Compatible(Unsafe unsafe) {
            this.myUnsafe = unsafe;
        }

        @Override
        public int getAndAddInt(Object obj, long address, int increment) {
            return this.myUnsafe.getAndAddInt(obj, address, increment);
        }

        @Override
        public int getAndSetInt(Object obj, long address, int value) {
            return this.myUnsafe.getAndSetInt(obj, address, value);
        }

        @Override
        public long getAndAddLong(Object obj, long address, long increment) {
            return this.myUnsafe.getAndAddLong(obj, address, increment);
        }

        @Override
        public long getAndSetLong(Object obj, long address, long value) {
            return this.myUnsafe.getAndSetLong(obj, address, value);
        }
    }

    static interface JDKCompatibility {
        public int getAndAddInt(Object var1, long var2, int var4);

        public int getAndSetInt(Object var1, long var2, int var4);

        public long getAndAddLong(Object var1, long var2, long var4);

        public long getAndSetLong(Object var1, long var2, long var4);
    }
}

