/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.memory;

import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRequest;
import com.yahoo.sketches.memory.UnsafeUtil;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class NativeMemory
implements Memory {
    protected final long objectBaseOffset_;
    protected final Object memArray_;
    protected MemoryRequest memReq_ = null;
    protected final ByteBuffer byteBuf_;
    protected long nativeRawStartAddress_;
    protected long capacityBytes_;

    protected NativeMemory(long objectBaseOffset, Object memArray, ByteBuffer byteBuf, long nativeRawStartAddress, long capacityBytes) {
        this.objectBaseOffset_ = objectBaseOffset;
        this.memArray_ = memArray;
        this.byteBuf_ = byteBuf;
        this.nativeRawStartAddress_ = nativeRawStartAddress;
        this.capacityBytes_ = capacityBytes;
    }

    public NativeMemory(byte[] byteArray) {
        int arrLen = byteArray.length;
        this.memArray_ = byteArray;
        this.objectBaseOffset_ = UnsafeUtil.BYTE_ARRAY_BASE_OFFSET;
        this.nativeRawStartAddress_ = 0L;
        this.capacityBytes_ = arrLen;
        this.byteBuf_ = null;
    }

    public NativeMemory(long[] longArray) {
        int arrLen = longArray.length;
        if (arrLen <= 0) {
            throw new IllegalArgumentException("longArray must have a length greater than zero.");
        }
        this.memArray_ = longArray;
        this.objectBaseOffset_ = UnsafeUtil.LONG_ARRAY_BASE_OFFSET;
        this.nativeRawStartAddress_ = 0L;
        this.capacityBytes_ = arrLen << 3;
        this.byteBuf_ = null;
    }

    public NativeMemory(ByteBuffer byteBuf) {
        this.capacityBytes_ = byteBuf.capacity();
        this.byteBuf_ = byteBuf;
        if (this.byteBuf_.isDirect()) {
            this.memArray_ = null;
            this.objectBaseOffset_ = 0L;
            this.nativeRawStartAddress_ = ((DirectBuffer)((Object)byteBuf)).address();
        } else {
            this.memArray_ = this.byteBuf_.array();
            this.objectBaseOffset_ = UnsafeUtil.BYTE_ARRAY_BASE_OFFSET;
            this.nativeRawStartAddress_ = 0L;
        }
    }

    @Override
    public void clear() {
        this.fill(0L, this.capacityBytes_, (byte)0);
    }

    @Override
    public void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public void clearBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.memArray_, this.getAddress(offsetBytes), (byte)(value &= ~bitMask));
    }

    @Override
    public void copy(long srcOffsetBytes, long dstOffsetBytes, long lengthBytes) {
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, this.capacityBytes_);
        assert (UnsafeUtil.checkOverlap(srcOffsetBytes, dstOffsetBytes, lengthBytes)) : "regions must not overlap";
        long srcAdd = this.getAddress(srcOffsetBytes);
        long dstAdd = this.getAddress(dstOffsetBytes);
        while (lengthBytes > 0L) {
            long size = lengthBytes > 0x100000L ? 0x100000L : lengthBytes;
            UnsafeUtil.unsafe.copyMemory(this.memArray_, srcAdd, this.memArray_, dstAdd, lengthBytes);
            lengthBytes -= size;
            srcAdd += size;
            dstAdd += size;
        }
    }

    @Override
    public int getAndAddInt(long offsetBytes, int delta) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        return UnsafeUtil.compatibilityMethods.getAndAddInt(this.memArray_, unsafeRawAddress, delta);
    }

    @Override
    public long getAndAddLong(long offsetBytes, long increment) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        return UnsafeUtil.compatibilityMethods.getAndAddLong(this.memArray_, unsafeRawAddress, increment);
    }

    @Override
    public int getAndSetInt(long offsetBytes, int newValue) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        return UnsafeUtil.compatibilityMethods.getAndSetInt(this.memArray_, unsafeRawAddress, newValue);
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        return UnsafeUtil.compatibilityMethods.getAndSetLong(this.memArray_, unsafeRawAddress, newValue);
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getBoolean(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.BOOLEAN_ARRAY_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public byte getByte(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public char getChar(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 2L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getChar(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.CHAR_ARRAY_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public double getDouble(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getDouble(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.DOUBLE_ARRAY_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public float getFloat(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getFloat(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.FLOAT_ARRAY_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public int getInt(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getInt(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.INT_ARRAY_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public long getLong(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getLong(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.LONG_ARRAY_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public short getShort(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 2L, this.capacityBytes_);
        return UnsafeUtil.unsafe.getShort(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.SHORT_ARRAY_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public boolean isAllBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAllBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAnyBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public boolean isAnyBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public void putBoolean(long offsetBytes, boolean srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        UnsafeUtil.unsafe.putBoolean(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.BOOLEAN_ARRAY_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putByte(long offsetBytes, byte srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        UnsafeUtil.unsafe.putByte(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putChar(long offsetBytes, char srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 2L, this.capacityBytes_);
        UnsafeUtil.unsafe.putChar(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.CHAR_ARRAY_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        UnsafeUtil.unsafe.putDouble(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.DOUBLE_ARRAY_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        UnsafeUtil.unsafe.putFloat(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.FLOAT_ARRAY_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putInt(long offsetBytes, int srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 4L, this.capacityBytes_);
        UnsafeUtil.unsafe.putInt(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.INT_ARRAY_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putLong(long offsetBytes, long srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 8L, this.capacityBytes_);
        UnsafeUtil.unsafe.putLong(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.LONG_ARRAY_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putShort(long offsetBytes, short srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, 2L, this.capacityBytes_);
        UnsafeUtil.unsafe.putShort(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.SHORT_ARRAY_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void fill(byte value) {
        this.fill(0L, this.capacityBytes_, value);
    }

    @Override
    public void fill(long offsetBytes, long lengthBytes, byte value) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.setMemory(this.memArray_, this.getAddress(offsetBytes), lengthBytes, value);
    }

    @Override
    public void setBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, 1L, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        byte value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress);
        UnsafeUtil.unsafe.putByte(this.memArray_, unsafeRawAddress, (byte)(value | bitMask));
    }

    @Override
    public final long getAddress(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 0L, this.capacityBytes_);
        assert (this.nativeRawStartAddress_ > 0L ^ this.objectBaseOffset_ > 0L);
        return this.nativeRawStartAddress_ + this.objectBaseOffset_ + offsetBytes;
    }

    @Override
    public long getCapacity() {
        return this.capacityBytes_;
    }

    @Override
    public MemoryRequest getMemoryRequest() {
        return this.memReq_;
    }

    @Override
    public Object getParent() {
        return this.memArray_;
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append("\n");
        String s1 = String.format("(%d, %d)", offsetBytes, lengthBytes);
        sb.append(this.getClass().getName());
        sb.append(".toHexString").append(s1).append(", hash: ").append(this.hashCode()).append(":");
        return this.toHex(sb.toString(), offsetBytes, lengthBytes);
    }

    public Object array() {
        return this.memArray_;
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuf_;
    }

    public void freeMemory() {
        if (this.requiresFree()) {
            UnsafeUtil.unsafe.freeMemory(this.nativeRawStartAddress_);
            this.nativeRawStartAddress_ = 0L;
        }
        this.capacityBytes_ = 0L;
    }

    public boolean hasArray() {
        return this.memArray_ != null;
    }

    public boolean hasByteBuffer() {
        return this.byteBuf_ != null;
    }

    public boolean isAllocated() {
        return this.capacityBytes_ > 0L;
    }

    private String toHex(String header, long offsetBytes, int lengthBytes) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        long address = this.getAddress(offsetBytes);
        StringBuilder sb = new StringBuilder();
        sb.append(header).append("\n");
        sb.append("Raw Address         : ").append(this.nativeRawStartAddress_).append("\n");
        sb.append("Object Offset       : ").append(this.objectBaseOffset_).append(": ");
        sb.append(this.memArray_ == null ? "null" : this.memArray_.getClass().getSimpleName()).append("\n");
        sb.append("Relative Offset     : ").append(offsetBytes).append("\n");
        sb.append("Total Offset        : ").append(address).append("\n");
        sb.append("Native Region       :  0  1  2  3  4  5  6  7");
        long j = offsetBytes;
        StringBuilder sb2 = new StringBuilder();
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = UnsafeUtil.unsafe.getByte(this.memArray_, address + i) & 0xFF;
            if (i != 0L && i % 8L == 0L) {
                sb.append(String.format("\n%20s: ", j)).append((CharSequence)sb2);
                j += 8L;
                sb2.setLength(0);
            }
            sb2.append(String.format("%02x ", b));
        }
        sb.append(String.format("\n%20s: ", j)).append((CharSequence)sb2).append("\n");
        return sb.toString();
    }

    protected boolean requiresFree() {
        return this.nativeRawStartAddress_ != 0L && this.byteBuf_ == null;
    }
}

