/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.hll.PreambleFlags;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRegion;
import com.yahoo.sketches.memory.NativeMemory;

public class Preamble {
    public static final byte PREAMBLE_LONGS = 1;
    public static final byte PREAMBLE_VERSION = 8;
    public static final byte HLL_PREAMBLE_FAMILY_ID = (byte)Family.HLL.getID();
    public static final int[] AUX_SIZE = new int[]{1, 4, 4, 4, 4, 4, 4, 8, 8, 8, 16, 16, 32, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144};
    private byte preambleSize;
    private byte version;
    private byte familyId;
    private byte logConfigK;
    private byte flags;
    private short seedHash;

    private Preamble(byte preambleSize, byte version, byte familyId, byte logConfigK, byte flags, short seedHash) {
        this.preambleSize = preambleSize;
        this.version = version;
        this.familyId = familyId;
        this.logConfigK = logConfigK;
        this.flags = flags;
        this.seedHash = seedHash;
        if (logConfigK < 7 || logConfigK > 21) {
            throw new IllegalArgumentException(String.format("logConfigK[%s] is out of bounds, should be between [%s] and [%s]", logConfigK, 7, 21));
        }
    }

    public static Preamble fromMemory(Memory memory) {
        Builder builder = new Builder().setPreambleSize(memory.getByte(0L)).setVersion(memory.getByte(1L)).setFamilyId(memory.getByte(2L)).setLogConfigK(memory.getByte(3L)).setFlags(memory.getByte(5L));
        short seedHash = memory.getShort(6L);
        return builder.setSeedHash(seedHash).build();
    }

    private static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new IllegalArgumentException("The given seed: " + seed + " produced a seedHash of zero. " + "You must choose a different seed.");
        }
        return seedHash;
    }

    public static Preamble fromLogK(int logK) {
        if (logK > 255) {
            throw new IllegalArgumentException("logK is greater than a byte, make it smaller");
        }
        byte flags = new PreambleFlags.Builder().setBigEndian(false).setReadOnly(true).setEmpty(true).setSharedPreambleMode(true).setSparseMode(true).setUnionMode(true).setEightBytePadding(false).build();
        short seedHash = Preamble.computeSeedHash(9001L);
        return new Builder().setLogConfigK((byte)logK).setFlags(flags).setSeedHash(seedHash).build();
    }

    public byte[] toByteArray() {
        byte[] retVal = new byte[this.getPreambleSize() << 3];
        this.intoByteArray(retVal, 0);
        return retVal;
    }

    public int intoByteArray(byte[] bytes, int offset) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("bytes too small");
        }
        MemoryRegion mem = new MemoryRegion(new NativeMemory(bytes), offset, 8L);
        mem.putByte(0L, this.getPreambleSize());
        mem.putByte(1L, this.getVersion());
        mem.putByte(2L, this.getFamilyId());
        mem.putByte(3L, this.getLogConfigK());
        mem.putByte(5L, this.getFlags());
        mem.putShort(6L, this.getSeedHash());
        return offset + 8;
    }

    public byte getPreambleSize() {
        return this.preambleSize;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getFamilyId() {
        return this.familyId;
    }

    public byte getLogConfigK() {
        return this.logConfigK;
    }

    public int getConfigK() {
        return 1 << this.logConfigK;
    }

    public int getMaxAuxSize() {
        return AUX_SIZE[this.logConfigK] << 2;
    }

    public byte getFlags() {
        return this.flags;
    }

    public short getSeedHash() {
        return this.seedHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preamble preamble = (Preamble)o;
        return this.familyId == preamble.familyId && this.flags == preamble.flags && this.logConfigK == preamble.logConfigK && this.preambleSize == preamble.preambleSize && this.seedHash == preamble.seedHash && this.version == preamble.version;
    }

    public int hashCode() {
        int result = this.preambleSize;
        result = 31 * result + this.version;
        result = 31 * result + this.familyId;
        result = 31 * result + this.logConfigK;
        result = 31 * result + this.flags;
        result = 31 * result + this.seedHash;
        return result;
    }

    public static class Builder {
        private byte preambleSize = 1;
        private byte version = (byte)8;
        private byte familyId = HLL_PREAMBLE_FAMILY_ID;
        private byte logConfigK = (byte)Integer.numberOfTrailingZeros(4096);
        private byte flags;
        private short seedHash = Preamble.access$000(9001L);

        public Builder setPreambleSize(byte preambleSize) {
            this.preambleSize = preambleSize;
            return this;
        }

        public Builder setVersion(byte version) {
            this.version = version;
            return this;
        }

        public Builder setFamilyId(byte familyId) {
            this.familyId = familyId;
            return this;
        }

        public Builder setLogConfigK(byte logConfigK) {
            this.logConfigK = logConfigK;
            return this;
        }

        public Builder setFlags(byte flags) {
            this.flags = flags;
            return this;
        }

        public Builder setSeed(long seed) {
            return this.setSeedHash(Preamble.computeSeedHash(seed));
        }

        public Builder setSeedHash(short seedHash) {
            this.seedHash = seedHash;
            return this;
        }

        public Preamble build() {
            return new Preamble(this.preambleSize, this.version, this.familyId, this.logConfigK, this.flags, this.seedHash);
        }
    }
}

