/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.hll.BucketIterator;
import com.yahoo.sketches.hll.Fields;

class HllUtils {
    static double[] invPow2Table = new double[256];

    HllUtils() {
    }

    static double computeInvPow2Sum(int numBuckets, BucketIterator iter) {
        double retVal = 0.0;
        while (iter.next()) {
            retVal += invPow2Table[iter.getValue()];
            --numBuckets;
        }
        return retVal += (double)numBuckets * invPow2Table[0];
    }

    static Fields unionBucketIterator(Fields fields, BucketIterator iter, Fields.UpdateCallback updateCallback) {
        while (iter.next()) {
            fields = fields.updateBucket(iter.getKey(), iter.getValue(), updateCallback);
        }
        return fields;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            HllUtils.invPow2Table[i] = Math.pow(2.0, -1.0 * (double)i);
        }
    }
}

