/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequest;
import com.yahoo.memory.NativeMemoryR;
import com.yahoo.memory.ReadOnlyMemoryException;
import com.yahoo.memory.UnsafeUtil;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class NativeMemory
implements Memory {
    protected final long objectBaseOffset_;
    protected final Object memArray_;
    protected final ByteBuffer byteBuf_;
    protected volatile long nativeRawStartAddress_;
    protected volatile long capacityBytes_;
    protected volatile MemoryRequest memReq_ = null;

    protected NativeMemory(long objectBaseOffset, Object memArray, ByteBuffer byteBuf) {
        this.objectBaseOffset_ = objectBaseOffset;
        this.memArray_ = memArray;
        this.byteBuf_ = byteBuf;
    }

    public NativeMemory(byte[] byteArray) {
        this(UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, byteArray, null);
        if (byteArray == null || byteArray.length == 0) {
            throw new IllegalArgumentException("Array must must not be null and have a length greater than zero.");
        }
        this.nativeRawStartAddress_ = 0L;
        this.capacityBytes_ = byteArray.length;
    }

    public NativeMemory(long[] longArray) {
        this(UnsafeUtil.ARRAY_LONG_BASE_OFFSET, longArray, null);
        if (longArray == null || longArray.length == 0) {
            throw new IllegalArgumentException("Array must must not be null and have a length greater than zero.");
        }
        this.nativeRawStartAddress_ = 0L;
        this.capacityBytes_ = longArray.length << 3;
    }

    public NativeMemory(ByteBuffer byteBuf) {
        if (byteBuf.isDirect()) {
            this.objectBaseOffset_ = 0L;
            this.memArray_ = null;
            this.nativeRawStartAddress_ = ((DirectBuffer)((Object)byteBuf)).address();
        } else {
            this.objectBaseOffset_ = UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + byteBuf.arrayOffset() * UnsafeUtil.ARRAY_BYTE_INDEX_SCALE;
            this.memArray_ = byteBuf.array();
            this.nativeRawStartAddress_ = 0L;
        }
        this.byteBuf_ = byteBuf;
        this.capacityBytes_ = byteBuf.capacity();
    }

    @Override
    public void clear() {
        this.fill(0L, this.capacityBytes_, (byte)0);
    }

    @Override
    public void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public void clearBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.memArray_, unsafeRawAddress, (byte)(value &= ~bitMask));
    }

    @Override
    public void copy(long srcOffsetBytes, long dstOffsetBytes, long lengthBytes) {
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, this.capacityBytes_);
        assert (UnsafeUtil.checkOverlap(srcOffsetBytes, dstOffsetBytes, lengthBytes)) : "regions must not overlap";
        long srcAdd = this.getAddress(srcOffsetBytes);
        long dstAdd = this.getAddress(dstOffsetBytes);
        long lenBytes = lengthBytes;
        while (lenBytes > 0L) {
            long size = lenBytes > 0x100000L ? 0x100000L : lenBytes;
            UnsafeUtil.unsafe.copyMemory(this.memArray_, srcAdd, this.memArray_, dstAdd, lenBytes);
            lenBytes -= size;
            srcAdd += size;
            dstAdd += size;
        }
    }

    @Override
    public void fill(byte value) {
        this.fill(0L, this.capacityBytes_, value);
    }

    @Override
    public void fill(long offsetBytes, long lengthBytes, byte value) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.setMemory(this.memArray_, this.getAddress(offsetBytes), lengthBytes, value);
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getBoolean(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public byte getByte(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public char getChar(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getChar(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public double getDouble(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getDouble(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public float getFloat(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getFloat(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public int getInt(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getInt(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public long getLong(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getLong(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public short getShort(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getShort(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public boolean isAllBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAllBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAnyBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public boolean isAnyBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public void putBoolean(long offsetBytes, boolean srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putBoolean(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putByte(long offsetBytes, byte srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putByte(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putChar(long offsetBytes, char srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putChar(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putDouble(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putFloat(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putInt(long offsetBytes, int srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putInt(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putLong(long offsetBytes, long srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putLong(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putShort(long offsetBytes, short srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putShort(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void setBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        byte value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress);
        UnsafeUtil.unsafe.putByte(this.memArray_, unsafeRawAddress, (byte)(value | bitMask));
    }

    @Override
    public int addAndGetInt(long offsetBytes, int delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndAddInt(this.memArray_, this.getAddress(offsetBytes), delta) + delta;
    }

    @Override
    public long addAndGetLong(long offsetBytes, long delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndAddLong(this.memArray_, this.getAddress(offsetBytes), delta) + delta;
    }

    @Override
    public boolean compareAndSwapInt(long offsetBytes, int expect, int update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.compareAndSwapInt(this.memArray_, this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.compareAndSwapLong(this.memArray_, this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public int getAndSetInt(long offsetBytes, int newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndSetInt(this.memArray_, this.getAddress(offsetBytes), newValue);
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndSetLong(this.memArray_, this.getAddress(offsetBytes), newValue);
    }

    @Override
    public Object array() {
        return this.memArray_;
    }

    @Override
    public Memory asReadOnlyMemory() {
        NativeMemoryR nmr = new NativeMemoryR(this.objectBaseOffset_, this.memArray_, this.byteBuf_);
        nmr.nativeRawStartAddress_ = this.nativeRawStartAddress_;
        nmr.capacityBytes_ = this.capacityBytes_;
        nmr.memReq_ = this.memReq_;
        return nmr;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuf_;
    }

    @Override
    public final long getAddress(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 0L, this.capacityBytes_);
        assert (this.nativeRawStartAddress_ > 0L ^ this.objectBaseOffset_ > 0L);
        return this.nativeRawStartAddress_ + this.objectBaseOffset_ + offsetBytes;
    }

    @Override
    public long getCapacity() {
        return this.capacityBytes_;
    }

    @Override
    public long getCumulativeOffset(long offsetBytes) {
        return this.getAddress(offsetBytes);
    }

    @Override
    public MemoryRequest getMemoryRequest() {
        return this.memReq_;
    }

    @Override
    public NativeMemory getNativeMemory() {
        return this;
    }

    @Override
    public Object getParent() {
        return this.memArray_;
    }

    @Override
    public boolean hasArray() {
        return this.memArray_ != null;
    }

    @Override
    public boolean hasByteBuffer() {
        return this.byteBuf_ != null;
    }

    @Override
    public boolean isAllocated() {
        return this.capacityBytes_ > 0L;
    }

    @Override
    public boolean isDirect() {
        return this.nativeRawStartAddress_ > 0L;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setMemoryRequest(MemoryRequest memReq) {
        this.memReq_ = memReq;
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(UnsafeUtil.LS);
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        sb.append(this.getClass().getSimpleName()).append(".toHexString").append(s1).append(", hash: ").append(this.hashCode()).append(UnsafeUtil.LS);
        sb.append("  MemoryRequest: ");
        if (this.memReq_ != null) {
            sb.append(this.memReq_.getClass().getSimpleName()).append(", hash: ").append(this.memReq_.hashCode());
        } else {
            sb.append("null");
        }
        return this.toHex(sb.toString(), offsetBytes, lengthBytes);
    }

    public static final void copy(Memory source, long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, source.getCapacity());
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, destination.getCapacity());
        if (destination.isReadOnly()) {
            throw new ReadOnlyMemoryException();
        }
        long srcAdd = source.getCumulativeOffset(srcOffsetBytes);
        long dstAdd = destination.getCumulativeOffset(dstOffsetBytes);
        Object srcParent = source.isDirect() ? null : source.getNativeMemory().memArray_;
        Object dstParent = destination.isDirect() ? null : destination.getNativeMemory().memArray_;
        long lenBytes = lengthBytes;
        while (lenBytes > 0L) {
            long chunkBytes = lenBytes > 0x100000L ? 0x100000L : lenBytes;
            UnsafeUtil.unsafe.copyMemory(srcParent, srcAdd, dstParent, dstAdd, lenBytes);
            lenBytes -= chunkBytes;
            srcAdd += chunkBytes;
            dstAdd += chunkBytes;
        }
    }

    public void freeMemory() {
        if (this.requiresFree()) {
            UnsafeUtil.unsafe.freeMemory(this.nativeRawStartAddress_);
            this.nativeRawStartAddress_ = 0L;
        }
        this.capacityBytes_ = 0L;
        this.memReq_ = null;
    }

    private String toHex(String header, long offsetBytes, int lengthBytes) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(UnsafeUtil.LS);
        sb.append("Raw Address         : ").append(this.nativeRawStartAddress_).append(UnsafeUtil.LS);
        sb.append("Object Offset       : ").append(this.objectBaseOffset_).append(": ");
        sb.append(this.memArray_ == null ? "null" : this.memArray_.getClass().getSimpleName()).append(UnsafeUtil.LS);
        sb.append("Relative Offset     : ").append(offsetBytes).append(UnsafeUtil.LS);
        sb.append("Total Offset        : ").append(unsafeRawAddress).append(UnsafeUtil.LS);
        sb.append("Native Region       :  0  1  2  3  4  5  6  7");
        long j = offsetBytes;
        StringBuilder sb2 = new StringBuilder();
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress + i) & 0xFF;
            if (i != 0L && i % 8L == 0L) {
                sb.append(String.format("%n%20s: ", j)).append((CharSequence)sb2);
                j += 8L;
                sb2.setLength(0);
            }
            sb2.append(String.format("%02x ", b));
        }
        sb.append(String.format("%n%20s: ", j)).append((CharSequence)sb2).append(UnsafeUtil.LS);
        return sb.toString();
    }

    protected boolean requiresFree() {
        return this.nativeRawStartAddress_ != 0L && this.byteBuf_ == null;
    }
}

