/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequest;
import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    @Deprecated
    public static void copy(Memory source, long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        NativeMemory.copy(source, srcOffsetBytes, destination, dstOffsetBytes, lengthBytes);
    }

    public static int binarySearchLongs(Memory mem, int fromLongIndex, int toLongIndex, long key) {
        UnsafeUtil.assertBounds(fromLongIndex << 3, toLongIndex - fromLongIndex << 3, mem.getCapacity());
        int low = fromLongIndex;
        int high = toLongIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = mem.getLong(mid << 3);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static Memory requestMemoryHandler(Memory origMem, long newCapacityBytes) {
        MemoryRequest memReq = origMem.getMemoryRequest();
        if (memReq == null) {
            throw new IllegalArgumentException("MemoryRequest callback cannot be null.");
        }
        Memory newDstMem = memReq.request(newCapacityBytes);
        if (newDstMem == null) {
            throw new IllegalArgumentException("Requested memory cannot be null.");
        }
        long newCap = newDstMem.getCapacity();
        if (newCap < newCapacityBytes) {
            memReq.free(newDstMem);
            throw new IllegalArgumentException("Requested memory capacity not granted: " + newCap + " < " + newCapacityBytes);
        }
        return newDstMem;
    }
}

