/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRegionR;
import com.yahoo.memory.MemoryRequest;
import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;
import java.nio.ByteBuffer;

public class MemoryRegion
implements Memory {
    private final Memory mem_;
    private volatile long memOffsetBytes_;
    private volatile long capacityBytes_;
    private volatile MemoryRequest memReq_ = null;

    public MemoryRegion(Memory memory, long memOffsetBytes, long capacityBytes) {
        UnsafeUtil.assertBounds(memOffsetBytes, capacityBytes, memory.getCapacity());
        this.mem_ = memory;
        this.memOffsetBytes_ = memOffsetBytes;
        this.capacityBytes_ = capacityBytes;
    }

    public MemoryRegion(Memory memory, long memOffsetBytes, long capacityBytes, MemoryRequest memReq) {
        UnsafeUtil.assertBounds(memOffsetBytes, capacityBytes, memory.getCapacity());
        this.mem_ = memory;
        this.memOffsetBytes_ = memOffsetBytes;
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = memReq;
    }

    public void reassign(long memOffsetBytes, long capacityBytes) {
        UnsafeUtil.assertBounds(memOffsetBytes, capacityBytes, this.mem_.getCapacity());
        this.memOffsetBytes_ = memOffsetBytes;
        this.capacityBytes_ = capacityBytes;
    }

    @Override
    public void clear() {
        this.fill(0L, this.capacityBytes_, (byte)0);
    }

    @Override
    public void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public void clearBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        this.mem_.clearBits(this.getAddress(offsetBytes), bitMask);
    }

    @Override
    public void copy(long srcOffsetBytes, long dstOffsetBytes, long lengthBytes) {
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.capacityBytes_);
        long min = Math.min(srcOffsetBytes, dstOffsetBytes);
        long max = Math.max(srcOffsetBytes, dstOffsetBytes);
        UnsafeUtil.assertBounds(min, lengthBytes, max);
        long srcAdd = this.getAddress(srcOffsetBytes);
        long dstAdd = this.getAddress(dstOffsetBytes);
        this.mem_.copy(srcAdd, dstAdd, lengthBytes);
    }

    @Override
    public void fill(byte value) {
        this.fill(0L, this.capacityBytes_, value);
    }

    @Override
    public void fill(long offsetBytes, long lengthBytes, byte value) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        this.mem_.fill(this.getAddress(offsetBytes), lengthBytes, value);
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getBoolean(this.getAddress(offsetBytes));
    }

    @Override
    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getBooleanArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public byte getByte(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getByte(this.getAddress(offsetBytes));
    }

    @Override
    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getByteArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public char getChar(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getChar(this.getAddress(offsetBytes));
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getCharArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public double getDouble(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getDouble(this.getAddress(offsetBytes));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getDoubleArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public float getFloat(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getFloat(this.getAddress(offsetBytes));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getFloatArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public int getInt(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getInt(this.getAddress(offsetBytes));
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getIntArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public long getLong(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getLong(this.getAddress(offsetBytes));
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getLongArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public short getShort(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getShort(this.getAddress(offsetBytes));
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        this.mem_.getShortArray(this.getAddress(offsetBytes), dstArray, dstOffset, length);
    }

    @Override
    public boolean isAllBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~this.mem_.getByte(this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAllBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = this.mem_.getByte(this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAnyBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~this.mem_.getByte(this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public boolean isAnyBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = this.mem_.getByte(this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public void putBoolean(long offsetBytes, boolean srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putBoolean(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putBooleanArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putByte(long offsetBytes, byte srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putByte(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putByteArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putChar(long offsetBytes, char srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putChar(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putCharArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putDouble(long offsetBytes, double srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putDouble(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putDoubleArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putFloat(long offsetBytes, float srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putFloat(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putFloatArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putInt(long offsetBytes, int srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putInt(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putIntArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putLong(long offsetBytes, long srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putLong(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putLongArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void putShort(long offsetBytes, short srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        this.mem_.putShort(this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        this.mem_.putShortArray(this.getAddress(offsetBytes), srcArray, srcOffset, length);
    }

    @Override
    public void setBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        long relativeOffset = this.getAddress(offsetBytes);
        byte value = this.mem_.getByte(relativeOffset);
        this.mem_.putByte(relativeOffset, (byte)(value | bitMask));
    }

    @Override
    public int addAndGetInt(long offsetBytes, int delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.addAndGetInt(this.getAddress(offsetBytes), delta);
    }

    @Override
    public long addAndGetLong(long offsetBytes, long delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.addAndGetLong(this.getAddress(offsetBytes), delta);
    }

    @Override
    public boolean compareAndSwapInt(long offsetBytes, int expect, int update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.compareAndSwapInt(this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.compareAndSwapLong(this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public int getAndSetInt(long offsetBytes, int newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getAndSetInt(this.getAddress(offsetBytes), newValue);
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return this.mem_.getAndSetLong(this.getAddress(offsetBytes), newValue);
    }

    @Override
    public Object array() {
        return this.mem_.array();
    }

    @Override
    public Memory asReadOnlyMemory() {
        Memory readOnlyMem = this.mem_.asReadOnlyMemory();
        return new MemoryRegionR(readOnlyMem, this.memOffsetBytes_, this.capacityBytes_, this.memReq_);
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.mem_.byteBuffer();
    }

    @Override
    public final long getAddress(long offsetBytes) {
        return this.memOffsetBytes_ + offsetBytes;
    }

    @Override
    public long getCapacity() {
        return this.capacityBytes_;
    }

    @Override
    public long getCumulativeOffset(long offsetBytes) {
        return this.mem_.getCumulativeOffset(0L) + this.getAddress(offsetBytes);
    }

    @Override
    public MemoryRequest getMemoryRequest() {
        return this.memReq_;
    }

    @Override
    public NativeMemory getNativeMemory() {
        return this.mem_.getNativeMemory();
    }

    @Override
    public Object getParent() {
        return this.mem_;
    }

    @Override
    public boolean hasArray() {
        return this.mem_.hasArray();
    }

    @Override
    public boolean hasByteBuffer() {
        return this.mem_.hasByteBuffer();
    }

    @Override
    public boolean isAllocated() {
        return this.capacityBytes_ > 0L;
    }

    @Override
    public boolean isDirect() {
        return this.mem_.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setMemoryRequest(MemoryRequest memReq) {
        this.memReq_ = memReq;
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(UnsafeUtil.LS);
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        sb.append(this.getClass().getSimpleName()).append(".toHexString").append(s1).append(", hash: ").append(this.hashCode()).append(UnsafeUtil.LS);
        sb.append("  MemoryRequest: ");
        if (this.memReq_ != null) {
            sb.append(this.memReq_.getClass().getSimpleName()).append(", hash: ").append(this.memReq_.hashCode());
        } else {
            sb.append("null");
        }
        return this.mem_.toHexString(sb.toString(), this.getAddress(offsetBytes), lengthBytes);
    }
}

