/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.NonNativeWritableBufferImpl;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableMemory;
import java.nio.ByteOrder;

final class NonNativeWritableMemoryImpl
extends BaseWritableMemoryImpl {
    NonNativeWritableMemoryImpl(ResourceState state, boolean localReadOnly) {
        super(state, localReadOnly);
        if (state.getResourceOrder() == ByteOrder.nativeOrder()) {
            throw new IllegalStateException("Expected non-native ordered state. This may be a bug in the Memory library.");
        }
    }

    @Override
    WritableMemory writableRegionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly) {
        this.checkValidAndBounds(offsetBytes, capacityBytes);
        ResourceState newState = this.state.copy();
        newState.putRegionOffset(newState.getRegionOffset() + offsetBytes);
        newState.putCapacity(capacityBytes);
        return new NonNativeWritableMemoryImpl(newState, localReadOnly);
    }

    @Override
    WritableBuffer asWritableBufferImpl(boolean localReadOnly) {
        this.checkValid();
        NonNativeWritableBufferImpl wbuf = new NonNativeWritableBufferImpl(this.state, localReadOnly, this);
        wbuf.setAndCheckStartPositionEnd(0L, 0L, this.capacity);
        return wbuf;
    }

    @Override
    public char getChar(long offsetBytes) {
        return Character.reverseBytes(this.getNativeOrderedChar(offsetBytes));
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeChars(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetChars, lengthChars);
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + offsetBytes)));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeDoubles(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + offsetBytes)));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeFloats(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    @Override
    public int getInt(long offsetBytes) {
        return Integer.reverseBytes(this.getNativeOrderedInt(offsetBytes));
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeInts(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetInts, lengthInts);
    }

    @Override
    public long getLong(long offsetBytes) {
        return Long.reverseBytes(this.getNativeOrderedLong(offsetBytes));
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeLongs(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    @Override
    public short getShort(long offsetBytes) {
        return Short.reverseBytes(this.getNativeOrderedShort(offsetBytes));
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        CompareAndCopy.getNonNativeShorts(this.unsafeObj, this.cumBaseOffset, offsetBytes, copyBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.putNativeOrderedChar(offsetBytes, Character.reverseBytes(value));
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeChars(srcArray, srcOffsetChars, lengthChars, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeDoubles(srcArray, srcOffsetDoubles, lengthDoubles, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + offsetBytes, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeFloats(srcArray, srcOffsetFloats, lengthFloats, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.putNativeOrderedInt(offsetBytes, Integer.reverseBytes(value));
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeInts(srcArray, srcOffsetInts, lengthInts, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.putNativeOrderedLong(offsetBytes, Long.reverseBytes(value));
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeLongs(srcArray, srcOffsetLongs, lengthLongs, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.putNativeOrderedShort(offsetBytes, Short.reverseBytes(value));
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        CompareAndCopy.putNonNativeShorts(srcArray, srcOffsetShorts, lengthShorts, copyBytes, this.unsafeObj, this.cumBaseOffset, offsetBytes);
    }

    @Override
    public long getAndAddLong(long offsetBytes, long delta) {
        long oldVal;
        long newValReverseBytes;
        long oldValReverseBytes;
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        long addr = this.cumBaseOffset + offsetBytes;
        while (!UnsafeUtil.unsafe.compareAndSwapLong(this.unsafeObj, addr, oldValReverseBytes = UnsafeUtil.unsafe.getLongVolatile(this.unsafeObj, addr), newValReverseBytes = Long.reverseBytes((oldVal = Long.reverseBytes(oldValReverseBytes)) + delta))) {
        }
        return oldVal;
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        long oldVal;
        long oldValReverseBytes;
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        long addr = this.cumBaseOffset + offsetBytes;
        long newValueReverseBytes = Long.reverseBytes(newValue);
        do {
            oldValReverseBytes = UnsafeUtil.unsafe.getLongVolatile(this.unsafeObj, addr);
            oldVal = Long.reverseBytes(oldValReverseBytes);
        } while (!UnsafeUtil.unsafe.compareAndSwapLong(this.unsafeObj, addr, oldValReverseBytes, newValueReverseBytes));
        return oldVal;
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        return UnsafeUtil.unsafe.compareAndSwapLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, Long.reverseBytes(expect), Long.reverseBytes(update));
    }
}

