/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;

final class NioBits {
    private static final Class<?> VM_CLASS;
    private static final Method VM_MAX_DIRECT_MEMORY_METHOD;
    private static final Method VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD;
    private static final Class<?> NIO_BITS_CLASS;
    private static final Method NIO_BITS_RESERVE_MEMORY_METHOD;
    private static final Method NIO_BITS_UNRESERVE_MEMORY_METHOD;
    private static final AtomicLong nioBitsCount;
    private static final AtomicLong nioBitsReservedMemory;
    private static final AtomicLong nioBitsTotalCapacity;
    private static int pageSize;
    private static final long maxDBBMemory;
    private static final boolean isPageAligned;

    private NioBits() {
    }

    static long getDirectAllocationsCount() {
        try {
            long count = nioBitsCount.get();
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read Bits.count " + e);
        }
    }

    static long getReservedMemory() {
        try {
            long resMem = nioBitsReservedMemory.get();
            return resMem;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read Bits.reservedMemory " + e);
        }
    }

    static long getTotalCapacity() {
        try {
            long resMem = nioBitsTotalCapacity.get();
            return resMem;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read Bits.totalCapacity " + e);
        }
    }

    static int pageSize() {
        return pageSize;
    }

    static int pageCount(long bytes) {
        return (int)(bytes + (long)NioBits.pageSize() - 1L) / NioBits.pageSize();
    }

    static long getMaxDirectByteBufferMemory() {
        return maxDBBMemory;
    }

    static boolean isPageAligned() {
        return isPageAligned;
    }

    static void reserveMemory(long capacity) {
        try {
            NioBits.reserveUnreserve(capacity, NIO_BITS_RESERVE_MEMORY_METHOD);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke java.nio.Bits.reserveMemory(...): capacity = " + capacity + "\n" + e);
        }
    }

    static void unreserveMemory(long capacity) {
        try {
            NioBits.reserveUnreserve(capacity, NIO_BITS_UNRESERVE_MEMORY_METHOD);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke java.nio.Bits.unreserveMemory(...): capacity = " + capacity + "\n" + e);
        }
    }

    private static void reserveUnreserve(long capacity, Method method) throws Exception {
        Util.zeroCheck(capacity, "capacity");
        long chunkSizeLimit = 0x40000000L;
        while (capacity > 0L) {
            long chunk = Math.min(capacity, 0x40000000L);
            method.invoke(null, chunk, (int)chunk);
            capacity -= chunk;
        }
    }

    static {
        pageSize = UnsafeUtil.unsafe.pageSize();
        try {
            VM_CLASS = Class.forName("sun.misc.VM");
            VM_MAX_DIRECT_MEMORY_METHOD = VM_CLASS.getDeclaredMethod("maxDirectMemory", new Class[0]);
            VM_MAX_DIRECT_MEMORY_METHOD.setAccessible(true);
            maxDBBMemory = (Long)VM_MAX_DIRECT_MEMORY_METHOD.invoke(null, new Object[0]);
            VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD = VM_CLASS.getDeclaredMethod("isDirectMemoryPageAligned", new Class[0]);
            VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD.setAccessible(true);
            isPageAligned = (Boolean)VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD.invoke(null, new Object[0]);
            NIO_BITS_CLASS = Class.forName("java.nio.Bits");
            NIO_BITS_RESERVE_MEMORY_METHOD = NIO_BITS_CLASS.getDeclaredMethod("reserveMemory", Long.TYPE, Integer.TYPE);
            NIO_BITS_RESERVE_MEMORY_METHOD.setAccessible(true);
            NIO_BITS_UNRESERVE_MEMORY_METHOD = NIO_BITS_CLASS.getDeclaredMethod("unreserveMemory", Long.TYPE, Integer.TYPE);
            NIO_BITS_UNRESERVE_MEMORY_METHOD.setAccessible(true);
            Field countField = NIO_BITS_CLASS.getDeclaredField("count");
            countField.setAccessible(true);
            nioBitsCount = (AtomicLong)countField.get(null);
            Field reservedMemoryField = NIO_BITS_CLASS.getDeclaredField("reservedMemory");
            reservedMemoryField.setAccessible(true);
            nioBitsReservedMemory = (AtomicLong)reservedMemoryField.get(null);
            Field totalCapacityField = NIO_BITS_CLASS.getDeclaredField("totalCapacity");
            totalCapacityField.setAccessible(true);
            nioBitsTotalCapacity = (AtomicLong)totalCapacityField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not acquire java.nio.Bits class: " + e.getClass() + UnsafeUtil.tryIllegalAccessPermit);
        }
    }
}

