/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AllocateDirectMap;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.Buffer;
import com.yahoo.memory.MapHandle;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Utf8CodingException;
import com.yahoo.memory.Util;
import com.yahoo.memory.WritableMemory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public abstract class Memory {
    public static Memory wrap(ByteBuffer byteBuf) {
        return WritableMemory.wrapBB(byteBuf, true);
    }

    public static MapHandle map(File file) throws IOException {
        return Memory.map(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static MapHandle map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        Util.zeroCheck(capacityBytes, "Capacity");
        Util.nullCheck(file, "file is null");
        Util.negativeCheck(fileOffsetBytes, "File offset is negative");
        ResourceState state = new ResourceState(AllocateDirectMap.isFileReadOnly(file));
        state.putCapacity(capacityBytes);
        state.putResourceOrder(byteOrder);
        return MapHandle.map(state, file, fileOffsetBytes);
    }

    public abstract Memory region(long var1, long var3);

    public abstract Buffer asBuffer();

    public static Memory wrap(boolean[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.BOOLEAN, arr.length), true);
    }

    public static Memory wrap(byte[] arr) {
        return Memory.wrap(arr, 0, arr.length, ByteOrder.nativeOrder());
    }

    public static Memory wrap(byte[] arr, ByteOrder byteOrder) {
        return Memory.wrap(arr, 0, arr.length, byteOrder);
    }

    public static Memory wrap(byte[] arr, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, arr.length);
        ResourceState state = new ResourceState(arr, Prim.BYTE, lengthBytes);
        state.putRegionOffset(offsetBytes);
        state.putResourceOrder(byteOrder);
        return BaseWritableMemoryImpl.newInstance(state, true);
    }

    public static Memory wrap(char[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.CHAR, arr.length), true);
    }

    public static Memory wrap(short[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.SHORT, arr.length), true);
    }

    public static Memory wrap(int[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.INT, arr.length), true);
    }

    public static Memory wrap(long[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.LONG, arr.length), true);
    }

    public static Memory wrap(float[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.FLOAT, arr.length), true);
    }

    public static Memory wrap(double[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.DOUBLE, arr.length), true);
    }

    public abstract boolean getBoolean(long var1);

    public abstract void getBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public abstract byte getByte(long var1);

    public abstract void getByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract char getChar(long var1);

    public abstract void getCharArray(long var1, char[] var3, int var4, int var5);

    public abstract int getCharsFromUtf8(long var1, int var3, Appendable var4) throws IOException, Utf8CodingException;

    public final int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, StringBuilder dst) throws Utf8CodingException {
        try {
            dst.ensureCapacity(dst.length() + utf8LengthBytes);
            return this.getCharsFromUtf8(offsetBytes, utf8LengthBytes, (Appendable)dst);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public abstract double getDouble(long var1);

    public abstract void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract float getFloat(long var1);

    public abstract void getFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract int getInt(long var1);

    public abstract void getIntArray(long var1, int[] var3, int var4, int var5);

    public abstract long getLong(long var1);

    public abstract void getLongArray(long var1, long[] var3, int var4, int var5);

    public abstract short getShort(long var1);

    public abstract void getShortArray(long var1, short[] var3, int var4, int var5);

    public abstract int compareTo(long var1, long var3, Memory var5, long var6, long var8);

    public abstract void copyTo(long var1, WritableMemory var3, long var4, long var6);

    public abstract void writeTo(long var1, long var3, WritableByteChannel var5) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract boolean equalTo(long var1, Memory var3, long var4, long var6);

    public abstract int hashCode();

    public abstract void checkValidAndBounds(long var1, long var3);

    public abstract long getCapacity();

    public abstract long getCumulativeOffset(long var1);

    public abstract ByteOrder getResourceOrder();

    public abstract boolean hasArray();

    public abstract boolean hasByteBuffer();

    public abstract boolean isDirect();

    public abstract boolean isReadOnly();

    public abstract boolean isSameResource(Memory var1);

    public abstract boolean isValid();

    public abstract boolean isSwapBytes();

    public abstract String toHexString(String var1, long var2, int var4);

    static String toHex(String preamble, long offsetBytes, int lengthBytes, ResourceState state, boolean localReadOnly) {
        long uObjHeader;
        String uObjStr;
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, state.getCapacity());
        StringBuilder sb = new StringBuilder();
        Object uObj = state.getUnsafeObject();
        if (uObj == null) {
            uObjStr = "null";
            uObjHeader = 0L;
        } else {
            uObjStr = uObj.getClass().getSimpleName() + ", " + ((long)uObj.hashCode() & 0xFFFFFFFFL);
            uObjHeader = UnsafeUtil.unsafe.arrayBaseOffset(uObj.getClass());
        }
        ByteBuffer bb = state.getByteBuffer();
        String bbStr = bb == null ? "null" : bb.getClass().getSimpleName() + ", " + ((long)bb.hashCode() & 0xFFFFFFFFL);
        MemoryRequestServer memReqSvr = state.getMemoryRequestServer();
        String memReqStr = memReqSvr == null ? "null" : memReqSvr.getClass().getSimpleName() + ", " + ((long)memReqSvr.hashCode() & 0xFFFFFFFFL);
        long cumBaseOffset = state.getCumBaseOffset();
        sb.append(preamble).append(UnsafeUtil.LS);
        sb.append("UnsafeObj, hashCode : ").append(uObjStr).append(UnsafeUtil.LS);
        sb.append("UnsafeObjHeader     : ").append(uObjHeader).append(UnsafeUtil.LS);
        sb.append("ByteBuf, hashCode   : ").append(bbStr).append(UnsafeUtil.LS);
        sb.append("RegionOffset        : ").append(state.getRegionOffset()).append(UnsafeUtil.LS);
        sb.append("Capacity            : ").append(state.getCapacity()).append(UnsafeUtil.LS);
        sb.append("CumBaseOffset       : ").append(cumBaseOffset).append(UnsafeUtil.LS);
        sb.append("MemReq, hashCode    : ").append(memReqStr).append(UnsafeUtil.LS);
        sb.append("Valid               : ").append(state.isValid()).append(UnsafeUtil.LS);
        sb.append("Local Read Only     : ").append(localReadOnly).append(UnsafeUtil.LS);
        sb.append("Resource Read Only  : ").append(state.isResourceReadOnly()).append(UnsafeUtil.LS);
        sb.append("Resource Endianness : ").append(state.getResourceOrder().toString()).append(UnsafeUtil.LS);
        sb.append("JDK Major Version   : ").append(UnsafeUtil.JDK).append(UnsafeUtil.LS);
        sb.append("Data, littleEndian  :  0  1  2  3  4  5  6  7");
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = UnsafeUtil.unsafe.getByte(uObj, cumBaseOffset + offsetBytes + i) & 0xFF;
            if (i % 8L == 0L) {
                sb.append(String.format("%n%20s: ", offsetBytes + i));
            }
            sb.append(String.format("%02x ", b));
        }
        sb.append(UnsafeUtil.LS);
        return sb.toString();
    }

    public static long getCurrentDirectMemoryAllocations() {
        return ResourceState.currentDirectMemoryAllocations_.get();
    }

    public static long getCurrentDirectMemoryAllocated() {
        return ResourceState.currentDirectMemoryAllocated_.get();
    }

    public static long getCurrentDirectMemoryMapAllocations() {
        return ResourceState.currentDirectMemoryMapAllocations_.get();
    }

    public static long getCurrentDirectMemoryMapAllocated() {
        return ResourceState.currentDirectMemoryMapAllocated_.get();
    }

    abstract ResourceState getResourceState();
}

