/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AccessByteBuffer;
import com.yahoo.memory.Buffer;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.Ints;
import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.NonNativeWritableMemoryImpl;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Utf8;
import com.yahoo.memory.Utf8CodingException;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableMemory;
import com.yahoo.memory.WritableMemoryImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

abstract class BaseWritableMemoryImpl
extends WritableMemory {
    final ResourceState state;
    final Object unsafeObj;
    final long capacity;
    final long cumBaseOffset;
    final boolean localReadOnly;
    static final WritableMemoryImpl ZERO_SIZE_MEMORY;

    BaseWritableMemoryImpl(ResourceState state, boolean localReadOnly) {
        this.unsafeObj = state.getUnsafeObject();
        this.state = state;
        this.capacity = state.getCapacity();
        this.cumBaseOffset = state.getCumBaseOffset();
        this.localReadOnly = localReadOnly;
    }

    static BaseWritableMemoryImpl newInstance(ResourceState state, boolean localReadOnly) {
        if (state.getCapacity() == 0L) {
            return ZERO_SIZE_MEMORY;
        }
        if (state.getResourceOrder() == ByteOrder.nativeOrder()) {
            return new WritableMemoryImpl(state, localReadOnly);
        }
        return new NonNativeWritableMemoryImpl(state, localReadOnly);
    }

    @Override
    public Memory region(long offsetBytes, long capacityBytes) {
        return this.writableRegionImpl(offsetBytes, capacityBytes, true);
    }

    @Override
    public WritableMemory writableRegion(long offsetBytes, long capacityBytes) {
        return this.writableRegionImpl(offsetBytes, capacityBytes, this.localReadOnly);
    }

    abstract WritableMemory writableRegionImpl(long var1, long var3, boolean var5);

    @Override
    public Buffer asBuffer() {
        return this.asWritableBufferImpl(true);
    }

    @Override
    public WritableBuffer asWritableBuffer() {
        return this.asWritableBufferImpl(this.localReadOnly);
    }

    abstract WritableBuffer asWritableBufferImpl(boolean var1);

    @Override
    public final boolean getBoolean(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        long copyBytes = lengthBooleans;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBooleans, lengthBooleans, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)dstOffsetBooleans, copyBytes);
    }

    @Override
    public final byte getByte(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getByte(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final void getByteArray(long offsetBytes, byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        long copyBytes = lengthBytes;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBytes, lengthBytes, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)dstOffsetBytes, copyBytes);
    }

    @Override
    public final int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, Appendable dst) throws IOException, Utf8CodingException {
        this.checkValidAndBounds(offsetBytes, utf8LengthBytes);
        return Utf8.getCharsFromUtf8(offsetBytes, utf8LengthBytes, dst, this.state);
    }

    final char getNativeOrderedChar(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getChar(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final int getNativeOrderedInt(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final long getNativeOrderedLong(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final short getNativeOrderedShort(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getShort(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final int compareTo(long thisOffsetBytes, long thisLengthBytes, Memory thatMem, long thatOffsetBytes, long thatLengthBytes) {
        return CompareAndCopy.compare(this.state, thisOffsetBytes, thisLengthBytes, thatMem.getResourceState(), thatOffsetBytes, thatLengthBytes);
    }

    @Override
    public final void copyTo(long srcOffsetBytes, WritableMemory destination, long dstOffsetBytes, long lengthBytes) {
        CompareAndCopy.copy(this.state, srcOffsetBytes, destination.getResourceState(), dstOffsetBytes, lengthBytes);
    }

    @Override
    public final void writeTo(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        this.checkValidAndBounds(offsetBytes, lengthBytes);
        if (this.unsafeObj instanceof byte[]) {
            this.writeByteArrayTo((byte[])this.unsafeObj, offsetBytes, lengthBytes, out);
        } else if (this.unsafeObj == null) {
            this.writeDirectMemoryTo(offsetBytes, lengthBytes, out);
        } else {
            this.writeToWithExtraCopy(offsetBytes, lengthBytes, out);
        }
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof Memory ? CompareAndCopy.equals(this.state, ((Memory)that).getResourceState()) : false;
    }

    @Override
    public final boolean equalTo(long thisOffsetBytes, Memory that, long thatOffsetBytes, long lengthBytes) {
        return CompareAndCopy.equals(this.state, thisOffsetBytes, that.getResourceState(), thatOffsetBytes, lengthBytes);
    }

    @Override
    public final int hashCode() {
        return CompareAndCopy.hashCode(this.state);
    }

    @Override
    public final void checkValidAndBounds(long offsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, this.capacity);
    }

    @Override
    public final long getCapacity() {
        this.assertValid();
        return this.capacity;
    }

    @Override
    public final long getCumulativeOffset(long offsetBytes) {
        this.assertValid();
        return this.cumBaseOffset + offsetBytes;
    }

    @Override
    public final long getRegionOffset(long offsetBytes) {
        this.assertValid();
        return this.state.getRegionOffset() + offsetBytes;
    }

    @Override
    public final ByteOrder getResourceOrder() {
        this.assertValid();
        return this.state.getResourceOrder();
    }

    @Override
    public final boolean hasArray() {
        this.assertValid();
        return this.unsafeObj != null;
    }

    @Override
    public final boolean hasByteBuffer() {
        this.assertValid();
        return this.state.getByteBuffer() != null;
    }

    @Override
    public final boolean isDirect() {
        this.assertValid();
        return this.state.isDirect();
    }

    @Override
    public final boolean isReadOnly() {
        this.assertValid();
        return this.state.isResourceReadOnly() || this.localReadOnly;
    }

    @Override
    public final boolean isSameResource(Memory that) {
        if (that == null) {
            return false;
        }
        this.checkValid();
        ((BaseWritableMemoryImpl)that).checkValid();
        return this.state.isSameResource(that.getResourceState());
    }

    @Override
    public final boolean isValid() {
        return this.state.isValid();
    }

    @Override
    public final boolean isSwapBytes() {
        this.assertValid();
        return this.state.isSwapBytes();
    }

    @Override
    public final String toHexString(String header, long offsetBytes, int lengthBytes) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(UnsafeUtil.LS);
        sb.append("Header Comment      : ").append(header).append(UnsafeUtil.LS);
        sb.append("Call Parameters     : ").append(call);
        return Memory.toHex(sb.toString(), offsetBytes, lengthBytes, this.state, this.localReadOnly);
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        long copyBytes = lengthBooleans;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBooleans, lengthBooleans, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)srcOffsetBooleans, this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final void putByteArray(long offsetBytes, byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        long copyBytes = lengthBytes;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBytes, lengthBytes, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)srcOffsetBytes, this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public final long putCharsToUtf8(long offsetBytes, CharSequence src) {
        this.checkValid();
        return Utf8.putCharsToUtf8(offsetBytes, src, this.state);
    }

    final void putNativeOrderedChar(long offsetBytes, char value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putChar(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedInt(long offsetBytes, int value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedLong(long offsetBytes, long value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedShort(long offsetBytes, short value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putShort(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final Object getArray() {
        this.assertValid();
        return this.unsafeObj;
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        this.assertValid();
        return this.state.getByteBuffer();
    }

    @Override
    public final void clear() {
        this.fill(0L, this.capacity, (byte)0);
    }

    @Override
    public final void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public final void clearBits(long offsetBytes, byte bitMask) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        long cumBaseOff = this.cumBaseOffset + offsetBytes;
        int value = UnsafeUtil.unsafe.getByte(this.unsafeObj, cumBaseOff) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.unsafeObj, cumBaseOff, (byte)(value &= ~bitMask));
    }

    @Override
    public final void fill(byte value) {
        this.fill(0L, this.capacity, value);
    }

    @Override
    public final void fill(long offsetBytes, long lengthBytes, byte value) {
        this.checkValidAndBoundsForWrite(offsetBytes, lengthBytes);
        while (lengthBytes > 0L) {
            long chunk = Math.min(lengthBytes, 0x100000L);
            UnsafeUtil.unsafe.setMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, chunk, value);
            offsetBytes += chunk;
            lengthBytes -= chunk;
        }
    }

    @Override
    public final void setBits(long offsetBytes, byte bitMask) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        long myOffset = this.cumBaseOffset + offsetBytes;
        byte value = UnsafeUtil.unsafe.getByte(this.unsafeObj, myOffset);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, myOffset, (byte)(value | bitMask));
    }

    @Override
    public final MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.state.getMemoryRequestServer();
    }

    private void writeByteArrayTo(byte[] unsafeObj, long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        int off = Ints.checkedCast(this.cumBaseOffset + offsetBytes - UnsafeUtil.ARRAY_BYTE_BASE_OFFSET);
        int len = Ints.checkedCast(lengthBytes);
        ByteBuffer bufToWrite = ByteBuffer.wrap(unsafeObj, off, len);
        BaseWritableMemoryImpl.writeFully(bufToWrite, out);
    }

    private void writeDirectMemoryTo(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        long addr = this.getCumulativeOffset(offsetBytes);
        while (lengthBytes > 0L) {
            int chunk = (int)Math.min(0x100000L, lengthBytes);
            ByteBuffer bufToWrite = AccessByteBuffer.getDummyDirectByteBuffer(addr, chunk);
            BaseWritableMemoryImpl.writeFully(bufToWrite, out);
            addr += (long)chunk;
            lengthBytes -= (long)chunk;
        }
    }

    private void writeToWithExtraCopy(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        int bufLen = Ints.checkedCast(Math.max(8L, Math.min(this.capacity / 1024L & 0xFFFFFFFFFFFFFFF8L, 4096L)));
        byte[] buf = new byte[bufLen];
        ByteBuffer bufToWrite = ByteBuffer.wrap(buf);
        while (lengthBytes > 0L) {
            int chunk = (int)Math.min((long)buf.length, lengthBytes);
            this.getByteArray(offsetBytes, buf, 0, chunk);
            bufToWrite.clear().limit(chunk);
            BaseWritableMemoryImpl.writeFully(bufToWrite, out);
            offsetBytes += (long)chunk;
            lengthBytes -= (long)chunk;
        }
    }

    private static void writeFully(ByteBuffer bufToWrite, WritableByteChannel out) throws IOException {
        while (bufToWrite.remaining() > 0) {
            out.write(bufToWrite);
        }
    }

    @Override
    final ResourceState getResourceState() {
        return this.state;
    }

    final void assertValid() {
        assert (this.state.isValid()) : "Memory not valid.";
    }

    final void checkValid() {
        this.state.checkValid();
    }

    final void assertValidAndBoundsForRead(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacity);
    }

    final void assertValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacity);
        assert (!this.localReadOnly) : "Memory is read-only.";
    }

    final void checkValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, this.capacity);
        if (this.localReadOnly) {
            throw new ReadOnlyException("Memory is read-only.");
        }
    }

    static {
        ResourceState state = new ResourceState(new byte[0], Prim.BYTE, 0L);
        ZERO_SIZE_MEMORY = new WritableMemoryImpl(state, true);
    }
}

