/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AllocateDirect;
import com.yahoo.memory.MemoryManager;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.WritableDirectHandle;
import com.yahoo.memory.WritableMemory;
import com.yahoo.memory.WritableMemoryImpl;

final class DefaultMemoryManager
implements MemoryManager {
    private static final MemoryManager memMgr = new DefaultMemoryManager();

    private DefaultMemoryManager() {
    }

    static MemoryManager getInstance() {
        return memMgr;
    }

    @Override
    public WritableDirectHandle allocateDirect(long capacityBytes) {
        ResourceState state = new ResourceState();
        state.putCapacity(capacityBytes);
        AllocateDirect direct = AllocateDirect.allocate(state);
        WritableMemoryImpl wMem = new WritableMemoryImpl(state);
        WritableDirectHandle handler = new WritableDirectHandle(direct, wMem);
        state.setMemoryRequestServer(this);
        state.setHandle(handler);
        return handler;
    }

    @Override
    public WritableMemory request(long capacityBytes) {
        WritableMemory mem = WritableMemory.allocate((int)capacityBytes);
        mem.setMemoryRequest(this);
        mem.setHandle(null);
        return mem;
    }

    @Override
    public void requestClose(WritableMemory memoryToClose, WritableMemory newMemory) {
        if (memoryToClose.getHandle() != null) {
            memoryToClose.getHandle().close();
        }
    }
}

