/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AccessByteBuffer;
import com.yahoo.memory.DefaultMemoryManager;
import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryManager;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableDirectHandle;
import com.yahoo.memory.WritableMapHandler;
import com.yahoo.memory.WritableMemoryImpl;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class WritableMemory
extends Memory {
    public static WritableMemory wrap(ByteBuffer byteBuf) {
        if (byteBuf.isReadOnly()) {
            throw new ReadOnlyException("ByteBuffer is read-only.");
        }
        ResourceState state = new ResourceState();
        state.putByteBuffer(byteBuf);
        AccessByteBuffer.wrap(state);
        return new WritableMemoryImpl(state);
    }

    public static WritableMapHandler writableMap(File file) throws Exception {
        return WritableMemory.writableMap(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static WritableMapHandler writableMap(File file, long fileOffset, long capacity, ByteOrder byteOrder) throws Exception {
        ResourceState state = new ResourceState();
        state.putFile(file);
        state.putFileOffset(fileOffset);
        state.putCapacity(capacity);
        state.order(byteOrder);
        return WritableMapHandler.map(state);
    }

    public static WritableDirectHandle allocateDirect(long capacityBytes) {
        MemoryManager memMgr = DefaultMemoryManager.getInstance();
        return memMgr.allocateDirect(capacityBytes);
    }

    public abstract WritableMemory writableDuplicate();

    public abstract WritableMemory writableRegion(long var1, long var3);

    public abstract WritableBuffer asWritableBuffer();

    public static WritableMemory allocate(int capacityBytes) {
        byte[] arr = new byte[capacityBytes];
        return new WritableMemoryImpl(new ResourceState(arr, Prim.BYTE, arr.length));
    }

    public static WritableMemory wrap(boolean[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.BOOLEAN, arr.length));
    }

    public static WritableMemory wrap(byte[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.BYTE, arr.length));
    }

    public static WritableMemory wrap(char[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.CHAR, arr.length));
    }

    public static WritableMemory wrap(short[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.SHORT, arr.length));
    }

    public static WritableMemory wrap(int[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.INT, arr.length));
    }

    public static WritableMemory wrap(long[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.LONG, arr.length));
    }

    public static WritableMemory wrap(float[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.FLOAT, arr.length));
    }

    public static WritableMemory wrap(double[] arr) {
        return new WritableMemoryImpl(new ResourceState(arr, Prim.DOUBLE, arr.length));
    }

    public abstract void putBoolean(long var1, boolean var3);

    public abstract void putBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public abstract void putByte(long var1, byte var3);

    public abstract void putByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void putChar(long var1, char var3);

    public abstract void putCharArray(long var1, char[] var3, int var4, int var5);

    public abstract void putDouble(long var1, double var3);

    public abstract void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract void putFloat(long var1, float var3);

    public abstract void putFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void putInt(long var1, int var3);

    public abstract void putIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void putLong(long var1, long var3);

    public abstract void putLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void putShort(long var1, short var3);

    public abstract void putShortArray(long var1, short[] var3, int var4, int var5);

    public abstract long getAndAddLong(long var1, long var3);

    public abstract boolean compareAndSwapLong(long var1, long var3, long var5);

    public abstract long getAndSetLong(long var1, long var3);

    public abstract Object getArray();

    public abstract ByteBuffer getByteBuffer();

    public abstract void clear();

    public abstract void clear(long var1, long var3);

    public abstract void clearBits(long var1, byte var3);

    public abstract void fill(byte var1);

    public abstract void fill(long var1, long var3, byte var5);

    public abstract void setBits(long var1, byte var3);

    public abstract MemoryRequestServer getMemoryRequestServer();

    public abstract void setMemoryRequest(MemoryRequestServer var1);

    public abstract WritableDirectHandle getHandle();

    public abstract void setHandle(WritableDirectHandle var1);
}

