/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import java.nio.ByteBuffer;

class BaseBuffer {
    private long start;
    private long pos;
    private long end;
    private final long cap;

    BaseBuffer(ResourceState state) {
        this.cap = state.getCapacity();
        BaseBuffer baseBuf = state.getBaseBuffer();
        if (baseBuf != null) {
            this.start = baseBuf.getStart();
            this.pos = baseBuf.getPosition();
            this.end = baseBuf.getEnd();
        } else {
            ByteBuffer byteBuf = state.getByteBuffer();
            if (byteBuf != null) {
                this.pos = byteBuf.position();
                this.end = byteBuf.limit();
            } else {
                this.pos = 0L;
                this.end = this.cap;
            }
            this.start = 0L;
        }
        state.putBaseBuffer(this);
    }

    public BaseBuffer setStartPositionEnd(long start, long position, long end) {
        BaseBuffer.assertInvariants(start, position, end, this.cap);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public long getPosition() {
        return this.pos;
    }

    public long getEnd() {
        return this.end;
    }

    public BaseBuffer setPosition(long position) {
        BaseBuffer.assertInvariants(this.start, position, this.end, this.cap);
        this.pos = position;
        return this;
    }

    public BaseBuffer incrementPosition(long increment) {
        BaseBuffer.assertInvariants(this.start, this.pos + increment, this.end, this.cap);
        this.pos += increment;
        return this;
    }

    public BaseBuffer resetPosition() {
        this.pos = this.start;
        return this;
    }

    public long getRemaining() {
        return this.end - this.pos;
    }

    public boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    static final void assertInvariants(long start, long pos, long end, long cap) {
        assert ((start | pos | end | cap | pos - start | end - pos | cap - end) >= 0L) : "Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end);
    }
}

