/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.framework.boot.swagger2.extension.filter;

import com.xzixi.framework.boot.swagger2.extension.exception.Swagger2Exception;
import com.xzixi.framework.boot.swagger2.extension.util.ResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class Swagger2Filter
implements Filter {
    private final String templatePath;
    private JSONObject tag;
    private JSONObject login;
    private JSONObject logout;

    public Swagger2Filter(String templatePath) {
        String template;
        this.templatePath = templatePath;
        if (StringUtils.isEmpty((Object)templatePath)) {
            return;
        }
        ClassPathResource resource = new ClassPathResource(templatePath);
        try {
            int length;
            InputStream in = resource.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            template = out.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new Swagger2Exception("\u8bfb\u53d6\u6a21\u677f\u5931\u8d25\uff01", e);
        }
        JSONObject authentication = JSONObject.fromObject((Object)template);
        this.tag = authentication.getJSONObject("tag");
        this.login = authentication.getJSONObject("login");
        this.logout = authentication.getJSONObject("logout");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (StringUtils.isEmpty((Object)this.templatePath)) {
            chain.doFilter(request, response);
            return;
        }
        ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        byte[] content = responseWrapper.getContent();
        if (content.length > 0) {
            String str = new String(content, StandardCharsets.UTF_8);
            JSONObject swagger = JSONObject.fromObject((Object)str);
            JSONArray tags = swagger.getJSONArray("tags");
            tags.add((Object)this.tag);
            JSONObject paths = swagger.getJSONObject("paths");
            paths.put((Object)"/login", (Object)this.login);
            paths.put((Object)"/logout", (Object)this.logout);
            ServletOutputStream out = response.getOutputStream();
            response.setContentLength(-1);
            out.write(swagger.toString().getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
    }
}

