/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.xw.repo.R;
import java.util.ArrayList;

public class XEditText
extends AppCompatEditText {
    private static final int DEFAULT_PADDING = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    private String mSeparator;
    private int mClearResId;
    private int mShowPwdResId;
    private int mHidePwdResId;
    private ColorStateList mClearDrawableTint;
    private ColorStateList mTogglePwdDrawableTint;
    private int mInteractionPadding;
    private boolean disableClear;
    private boolean togglePwdDrawableEnable;
    private boolean disableEmoji;
    private Drawable mClearDrawable;
    private Drawable mTogglePwdDrawable;
    private OnXTextChangeListener mXTextChangeListener;
    private OnXFocusChangeListener mXFocusChangeListener;
    private OnClearListener mOnClearListener;
    private final TextWatcher mTextWatcher;
    private int mOldLength;
    private int mNowLength;
    private int mSelectionPos;
    private boolean hasFocused;
    private int[] pattern;
    private int[] intervals;
    private boolean hasNoSeparator;
    private boolean isPwdInputType;
    private boolean isPwdShow;
    private Bitmap mBitmap;
    private int mStart;
    private int mTop;
    private int mHalfPadding;

    public XEditText(Context context) {
        this(context, null);
    }

    public XEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public XEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.mTextWatcher = new MyTextWatcher();
        this.addTextChangedListener(this.mTextWatcher);
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                XEditText.this.hasFocused = hasFocus;
                XEditText.this.logicOfCompoundDrawables();
                if (XEditText.this.mXFocusChangeListener != null) {
                    XEditText.this.mXFocusChangeListener.onFocusChange(v, hasFocus);
                }
            }
        });
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        Drawable d;
        int inputType;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.XEditText, defStyleAttr, 0);
        this.mSeparator = a.getString(R.styleable.XEditText_x_separator);
        this.disableClear = a.getBoolean(R.styleable.XEditText_x_disableClear, false);
        this.mClearResId = a.getResourceId(R.styleable.XEditText_x_clearDrawable, R.drawable.x_et_svg_ic_clear_24dp);
        this.togglePwdDrawableEnable = a.getBoolean(R.styleable.XEditText_x_togglePwdDrawableEnable, true);
        this.mShowPwdResId = a.getResourceId(R.styleable.XEditText_x_showPwdDrawable, R.drawable.x_et_svg_ic_show_password_24dp);
        this.mHidePwdResId = a.getResourceId(R.styleable.XEditText_x_hidePwdDrawable, R.drawable.x_et_svg_ic_hide_password_24dp);
        this.mClearDrawableTint = a.hasValue(R.styleable.XEditText_x_clearDrawableTint) ? a.getColorStateList(R.styleable.XEditText_x_clearDrawableTint) : ColorStateList.valueOf((int)this.getCurrentHintTextColor());
        if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp && this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
            this.mTogglePwdDrawableTint = a.hasValue(R.styleable.XEditText_x_togglePwdDrawableTint) ? a.getColorStateList(R.styleable.XEditText_x_togglePwdDrawableTint) : ColorStateList.valueOf((int)this.getCurrentHintTextColor());
        } else if (a.hasValue(R.styleable.XEditText_x_togglePwdDrawableTint)) {
            this.mTogglePwdDrawableTint = a.getColorStateList(R.styleable.XEditText_x_togglePwdDrawableTint);
        }
        this.disableEmoji = a.getBoolean(R.styleable.XEditText_x_disableEmoji, false);
        String pattern = a.getString(R.styleable.XEditText_x_pattern);
        this.mInteractionPadding = a.getDimensionPixelSize(R.styleable.XEditText_x_interactionPadding, DEFAULT_PADDING);
        a.recycle();
        if (this.mSeparator == null) {
            this.mSeparator = "";
        }
        this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
        if (this.mSeparator.length() > 0 && ((inputType = this.getInputType()) == 2 || inputType == 8194 || inputType == 4098)) {
            this.setInputType(3);
        }
        if (this.mInteractionPadding < 0) {
            this.mInteractionPadding = 0;
        }
        this.mHalfPadding = this.mInteractionPadding >> 1;
        if (!this.disableClear && (d = AppCompatResources.getDrawable((Context)context, (int)this.mClearResId)) != null) {
            this.mClearDrawable = DrawableCompat.wrap((Drawable)d);
            this.mClearDrawable.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            DrawableCompat.setTintList((Drawable)this.mClearDrawable.mutate(), (ColorStateList)this.mClearDrawableTint);
        }
        this.dealWithInputTypes(true);
        if (!(this.mSeparator.isEmpty() || this.isPwdInputType || pattern == null || pattern.isEmpty())) {
            boolean ok = true;
            if (pattern.contains(",")) {
                String[] split = pattern.split(",");
                int[] array = new int[split.length];
                for (int i = 0; i < array.length; ++i) {
                    try {
                        array[i] = Integer.parseInt(split[i]);
                        continue;
                    }
                    catch (Exception e) {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    this.setPattern(array, this.mSeparator);
                }
            } else {
                try {
                    int i = Integer.parseInt(pattern);
                    this.setPattern(new int[]{i}, this.mSeparator);
                }
                catch (Exception e) {
                    ok = false;
                }
            }
            if (!ok) {
                Log.e((String)"XEditText", (String)"the Pattern format is incorrect!");
            }
        }
        if (this.disableEmoji) {
            InputFilter[] oldFilters = this.getFilters();
            InputFilter[] newFilters = new InputFilter[oldFilters.length + 1];
            newFilters[oldFilters.length] = new EmojiExcludeFilter();
            System.arraycopy(oldFilters, 0, newFilters, 0, oldFilters.length);
            this.setFilters(newFilters);
        }
    }

    private void dealWithInputTypes(boolean fromXml) {
        int inputType = this.getInputType();
        if (!fromXml && ++inputType == 17) {
            ++inputType;
        }
        boolean bl = this.isPwdInputType = this.togglePwdDrawableEnable && (inputType == 129 || inputType == 18 || inputType == 145 || inputType == 225);
        if (this.isPwdInputType) {
            boolean bl2 = this.isPwdShow = inputType == 145;
            if (this.isPwdShow) {
                this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            } else {
                this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            }
            Drawable d = AppCompatResources.getDrawable((Context)this.getContext(), (int)(this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId));
            if (d != null) {
                this.mTogglePwdDrawable = DrawableCompat.wrap((Drawable)d);
                this.mTogglePwdDrawable.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
                if (this.mTogglePwdDrawableTint != null) {
                    DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)this.mTogglePwdDrawableTint);
                }
            }
            if (!this.disableClear && this.mClearDrawable != null) {
                this.mBitmap = Bitmap.createBitmap((int)this.mClearDrawable.getIntrinsicWidth(), (int)this.mClearDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(this.mBitmap);
                this.mClearDrawable.draw(canvas);
                this.setCompoundDrawablePadding(this.getCompoundDrawablePadding() + this.mBitmap.getWidth() + (this.mInteractionPadding << 1));
            }
        }
        if (!fromXml) {
            this.setTextEx(this.getTextEx());
            this.logicOfCompoundDrawables();
        }
    }

    public void setInputType(int type) {
        super.setInputType(type);
        this.dealWithInputTypes(false);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.logicOfCompoundDrawables();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.hasFocused && !this.disableClear && this.mBitmap != null && this.isPwdInputType && !this.isTextEmpty()) {
            if (this.isRtl()) {
                if (this.mStart * this.mTop == 0) {
                    this.mStart = ViewCompat.getPaddingEnd((View)this) + this.mTogglePwdDrawable.getIntrinsicWidth() + this.mInteractionPadding;
                    this.mTop = this.getHeight() - this.mBitmap.getHeight() >> 1;
                }
            } else if (this.mStart * this.mTop == 0) {
                this.mStart = this.getWidth() - ViewCompat.getPaddingEnd((View)this) - this.mTogglePwdDrawable.getIntrinsicWidth() - this.mBitmap.getWidth() - this.mInteractionPadding;
                this.mTop = this.getHeight() - this.mBitmap.getHeight() >> 1;
            }
            canvas.drawBitmap(this.mBitmap, (float)(this.mStart + this.getScrollX()), (float)this.mTop, null);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        Editable editable;
        boolean inAreaX;
        int end;
        float eventX;
        boolean inAreaY;
        int top;
        int dh;
        int dw;
        if (!this.isEnabled()) {
            return super.onTouchEvent(event);
        }
        if (this.hasFocused && this.isPwdInputType && event.getAction() == 1) {
            dw = this.mTogglePwdDrawable.getIntrinsicWidth();
            dh = this.mTogglePwdDrawable.getIntrinsicHeight();
            top = this.getHeight() - dh >> 1;
            inAreaY = event.getY() >= (float)(top - this.mInteractionPadding) && event.getY() <= (float)(top + dh + this.mInteractionPadding);
            eventX = event.getX();
            if (this.isRtl()) {
                end = ViewCompat.getPaddingEnd((View)this);
                inAreaX = eventX >= (float)(end - this.mHalfPadding) && eventX <= (float)(end + dw + this.mHalfPadding);
            } else {
                end = this.getWidth() - ViewCompat.getPaddingEnd((View)this);
                boolean bl = inAreaX = eventX <= (float)(end + this.mHalfPadding) && eventX >= (float)(end - dw - this.mHalfPadding);
            }
            if (inAreaX && inAreaY) {
                boolean bl = this.isPwdShow = !this.isPwdShow;
                if (this.isPwdShow) {
                    this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                } else {
                    this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                this.setSelection(this.getSelectionStart(), this.getSelectionEnd());
                Drawable d = AppCompatResources.getDrawable((Context)this.getContext(), (int)(this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId));
                if (d != null) {
                    this.mTogglePwdDrawable = DrawableCompat.wrap((Drawable)d);
                    this.mTogglePwdDrawable.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
                    if (this.mTogglePwdDrawableTint != null) {
                        DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)this.mTogglePwdDrawableTint);
                    }
                    this.setCompoundDrawablesCompat(this.mTogglePwdDrawable);
                }
            }
            if (!this.disableClear) {
                if (this.isRtl()) {
                    inAreaX = eventX >= (float)((end += dw + this.mInteractionPadding) - this.mHalfPadding) && eventX <= (float)(end + this.mBitmap.getWidth() + this.mHalfPadding);
                } else {
                    boolean bl = inAreaX = eventX <= (float)((end -= dw + this.mInteractionPadding) + this.mHalfPadding) && eventX >= (float)(end - this.mBitmap.getWidth() - this.mHalfPadding);
                }
                if (inAreaX && inAreaY) {
                    this.setError(null);
                    editable = this.getText();
                    if (editable != null) {
                        editable.clear();
                    }
                    if (this.mOnClearListener != null) {
                        this.mOnClearListener.onClear();
                    }
                }
            }
        }
        if (this.hasFocused && !this.disableClear && !this.isPwdInputType && event.getAction() == 1) {
            dw = this.mClearDrawable.getIntrinsicWidth();
            dh = this.mClearDrawable.getIntrinsicHeight();
            top = this.getHeight() - dh >> 1;
            inAreaY = event.getY() >= (float)(top - this.mInteractionPadding) && event.getY() <= (float)(top + dh + this.mInteractionPadding);
            eventX = event.getX();
            if (this.isRtl()) {
                end = ViewCompat.getPaddingEnd((View)this);
                inAreaX = eventX >= (float)(end - this.mInteractionPadding) && eventX <= (float)(end + dw + this.mInteractionPadding);
            } else {
                end = this.getWidth() - ViewCompat.getPaddingEnd((View)this);
                boolean bl = inAreaX = eventX <= (float)(end + this.mInteractionPadding) && eventX >= (float)(end - dw - this.mInteractionPadding);
            }
            if (inAreaX && inAreaY) {
                this.setError(null);
                editable = this.getText();
                if (editable != null) {
                    editable.clear();
                }
                if (this.mOnClearListener != null) {
                    this.mOnClearListener.onClear();
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean onTextContextMenuItem(int id) {
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        if (clipboardManager != null) {
            ClipData.Item item;
            ClipData clip;
            if (id == 0x1020020 || id == 0x1020021) {
                ClipData.Item item2;
                super.onTextContextMenuItem(id);
                ClipData clip2 = clipboardManager.getPrimaryClip();
                if (clip2 != null && (item2 = clip2.getItemAt(0)) != null && item2.getText() != null) {
                    String s = item2.getText().toString().replace(this.mSeparator, "");
                    clipboardManager.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)s));
                    return true;
                }
            } else if (id == 0x1020022 && (clip = clipboardManager.getPrimaryClip()) != null && (item = clip.getItemAt(0)) != null && item.getText() != null) {
                String txt;
                int end;
                String content = item.getText().toString().replace(this.mSeparator, "");
                String existedTxt = this.getTextNoneNull();
                int start = this.getSelectionStart();
                if (start * (end = this.getSelectionEnd()) >= 0) {
                    String startHalfEx = existedTxt.substring(0, start).replace(this.mSeparator, "");
                    txt = startHalfEx + content;
                    String endHalfEx = existedTxt.substring(end).replace(this.mSeparator, "");
                    txt = txt + endHalfEx;
                } else {
                    txt = existedTxt.replace(this.mSeparator, "") + content;
                }
                this.setTextEx(txt);
                return true;
            }
        }
        return super.onTextContextMenuItem(id);
    }

    private boolean isRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private void logicOfCompoundDrawables() {
        if (!this.isEnabled() || !this.hasFocused || this.isTextEmpty() && !this.isPwdInputType) {
            this.setCompoundDrawablesCompat(null);
            if (!this.isTextEmpty() && this.isPwdInputType) {
                this.invalidate();
            }
        } else if (this.isPwdInputType) {
            if (this.mTogglePwdDrawableTint != null) {
                DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)this.mTogglePwdDrawableTint);
            }
            this.setCompoundDrawablesCompat(this.mTogglePwdDrawable);
        } else if (!this.isTextEmpty() && !this.disableClear) {
            this.setCompoundDrawablesCompat(this.mClearDrawable);
        }
    }

    private void setCompoundDrawablesCompat(Drawable drawableEnd) {
        Drawable[] drawables = TextViewCompat.getCompoundDrawablesRelative((TextView)this);
        TextViewCompat.setCompoundDrawablesRelative((TextView)this, (Drawable)drawables[0], (Drawable)drawables[1], (Drawable)drawableEnd, (Drawable)drawables[3]);
    }

    private boolean isTextEmpty() {
        return this.getTextNoneNull().trim().length() == 0;
    }

    public String getSeparator() {
        return this.mSeparator;
    }

    public void setSeparator(@NonNull String separator) {
        int inputType;
        if (this.mSeparator.equals(separator)) {
            return;
        }
        this.mSeparator = separator;
        this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
        if (this.mSeparator.length() > 0 && ((inputType = this.getInputType()) == 2 || inputType == 8194 || inputType == 4098)) {
            this.setInputType(3);
        }
    }

    public void setPattern(@NonNull int[] pattern, @NonNull String separator) {
        this.setSeparator(separator);
        this.setPattern(pattern);
    }

    public void setPattern(@NonNull int[] pattern) {
        this.pattern = pattern;
        this.intervals = new int[pattern.length];
        int sum = 0;
        for (int i = 0; i < pattern.length; ++i) {
            this.intervals[i] = sum += pattern[i];
        }
        int maxLength = this.intervals[this.intervals.length - 1] + pattern.length - 1;
        InputFilter[] oldFilters = this.getFilters();
        ArrayList<Object> list = new ArrayList<Object>();
        for (InputFilter filter : oldFilters) {
            if (filter instanceof InputFilter.LengthFilter) continue;
            list.add(filter);
        }
        list.add(new InputFilter.LengthFilter(maxLength));
        InputFilter[] newFilters = new InputFilter[list.size()];
        this.setFilters(list.toArray(newFilters));
    }

    @Deprecated
    public void setTextToSeparate(@NonNull CharSequence c) {
        this.setTextToSeparate(c, true);
    }

    public void setTextEx(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text) || this.hasNoSeparator) {
            this.setText(text);
            this.setSelection(this.getTextNoneNull().length());
        } else {
            this.setTextToSeparate(text, true);
        }
    }

    private void setTextToSeparate(@NonNull CharSequence c, boolean fromUser) {
        if (c.length() == 0 || this.intervals == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int length1 = c.length();
        for (int i = 0; i < length1; ++i) {
            builder.append(c.subSequence(i, i + 1));
            int length2 = this.intervals.length;
            for (int j = 0; j < length2; ++j) {
                if (i != this.intervals[j] || j >= length2 - 1) continue;
                builder.insert(builder.length() - 1, this.mSeparator);
                if (this.mSelectionPos != builder.length() - 1 || this.mSelectionPos <= this.intervals[j]) continue;
                if (this.mNowLength > this.mOldLength) {
                    this.mSelectionPos += this.mSeparator.length();
                    continue;
                }
                this.mSelectionPos -= this.mSeparator.length();
            }
        }
        String text = builder.toString();
        this.setText(text);
        if (fromUser) {
            int maxLength = this.intervals[this.intervals.length - 1] + this.pattern.length - 1;
            int index = Math.min(maxLength, text.length());
            try {
                this.setSelection(index);
            }
            catch (IndexOutOfBoundsException e) {
                int last;
                String lenStr;
                String message = e.getMessage();
                if (!TextUtils.isEmpty((CharSequence)message) && message.contains(" ") && TextUtils.isDigitsOnly((CharSequence)(lenStr = message.substring((last = message.lastIndexOf(" ")) + 1)))) {
                    this.setSelection(Integer.parseInt(lenStr));
                }
            }
        } else {
            if (this.mSelectionPos > text.length()) {
                this.mSelectionPos = text.length();
            }
            if (this.mSelectionPos < 0) {
                this.mSelectionPos = 0;
            }
            this.setSelection(this.mSelectionPos);
        }
    }

    @NonNull
    public String getTextTrimmed() {
        return this.getTextEx().trim();
    }

    @NonNull
    public String getTextEx() {
        if (this.hasNoSeparator) {
            return this.getTextNoneNull();
        }
        return this.getTextNoneNull().replaceAll(this.mSeparator, "");
    }

    @Deprecated
    public String getTrimmedString() {
        if (this.hasNoSeparator) {
            return this.getTextNoneNull().trim();
        }
        return this.getTextNoneNull().replaceAll(this.mSeparator, "").trim();
    }

    private String getTextNoneNull() {
        Editable editable = this.getText();
        return editable == null ? "" : editable.toString();
    }

    public boolean hasNoSeparator() {
        return this.hasNoSeparator;
    }

    public void setNoSeparator() {
        this.hasNoSeparator = true;
        this.mSeparator = "";
        this.intervals = null;
    }

    public void setClearDrawable(@DrawableRes int resId) {
        this.mClearResId = resId;
        this.setClearDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setClearDrawable(@Nullable Drawable drawable2) {
        if (!this.disableClear && drawable2 != null) {
            this.mClearDrawable = DrawableCompat.wrap((Drawable)drawable2);
            this.mClearDrawable.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            if (this.mClearDrawableTint != null) {
                DrawableCompat.setTintList((Drawable)this.mClearDrawable.mutate(), (ColorStateList)this.mClearDrawableTint);
            }
        }
    }

    public void setTogglePwdDrawables(@DrawableRes int showResId, @DrawableRes int hideResId) {
        this.mShowPwdResId = showResId;
        this.mHidePwdResId = hideResId;
        this.setTogglePwdDrawables(AppCompatResources.getDrawable((Context)this.getContext(), (int)showResId), AppCompatResources.getDrawable((Context)this.getContext(), (int)showResId));
    }

    public void setTogglePwdDrawables(@Nullable Drawable showDrawable, @Nullable Drawable hideDrawable) {
        if (this.isPwdShow && showDrawable != null) {
            this.mTogglePwdDrawable = DrawableCompat.wrap((Drawable)showDrawable);
            this.mTogglePwdDrawable.setBounds(0, 0, showDrawable.getIntrinsicWidth(), showDrawable.getIntrinsicHeight());
            if (this.mTogglePwdDrawableTint != null) {
                DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)this.mTogglePwdDrawableTint);
            }
        }
        if (!this.isPwdShow && hideDrawable != null) {
            this.mTogglePwdDrawable = DrawableCompat.wrap((Drawable)hideDrawable);
            this.mTogglePwdDrawable.setBounds(0, 0, hideDrawable.getIntrinsicWidth(), hideDrawable.getIntrinsicHeight());
            if (this.mTogglePwdDrawableTint != null) {
                DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)this.mTogglePwdDrawableTint);
            }
        }
    }

    public void setClearDrawableTint(@NonNull ColorStateList colorStateList) {
        this.mClearDrawableTint = colorStateList;
        if (this.mClearDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mClearDrawable.mutate(), (ColorStateList)colorStateList);
        }
    }

    public void setTogglePwdDrawablesTint(@NonNull ColorStateList colorStateList) {
        this.mTogglePwdDrawableTint = colorStateList;
        if (this.mTogglePwdDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mTogglePwdDrawable.mutate(), (ColorStateList)colorStateList);
        }
    }

    public void setInteractionPadding(int paddingInDp) {
        if (paddingInDp >= 0) {
            this.mInteractionPadding = paddingInDp;
            this.mHalfPadding = paddingInDp >> 1;
        }
    }

    public void setDisableClear(boolean disable) {
        if (this.disableClear == disable) {
            return;
        }
        this.disableClear = disable;
        if (this.isPwdInputType && this.mBitmap != null) {
            int padding = this.getCompoundDrawablePadding();
            padding = disable ? (padding -= this.mBitmap.getWidth() + this.mInteractionPadding) : (padding += this.mBitmap.getWidth() + this.mInteractionPadding);
            this.setCompoundDrawablePadding(padding);
        }
    }

    public void setTogglePwdDrawableEnable(boolean enable) {
        if (this.togglePwdDrawableEnable == enable) {
            return;
        }
        this.togglePwdDrawableEnable = enable;
        this.dealWithInputTypes(false);
    }

    public void setDisableEmoji(boolean disableEmoji) {
        InputFilter[] newFilters;
        if (this.disableEmoji == disableEmoji) {
            return;
        }
        this.disableEmoji = disableEmoji;
        InputFilter[] oldFilters = this.getFilters();
        if (disableEmoji) {
            newFilters = new InputFilter[oldFilters.length + 1];
            newFilters[oldFilters.length] = new EmojiExcludeFilter();
            System.arraycopy(oldFilters, 0, newFilters, 0, oldFilters.length);
        } else {
            ArrayList<InputFilter> list = new ArrayList<InputFilter>();
            for (InputFilter filter : oldFilters) {
                if (filter instanceof EmojiExcludeFilter) continue;
                list.add(filter);
            }
            newFilters = new InputFilter[list.size()];
            list.toArray(newFilters);
        }
        this.setFilters(newFilters);
    }

    public void setOnXTextChangeListener(OnXTextChangeListener listener) {
        this.mXTextChangeListener = listener;
    }

    public void setOnXFocusChangeListener(OnXFocusChangeListener listener) {
        this.mXFocusChangeListener = listener;
    }

    public void setOnClearListener(OnClearListener listener) {
        this.mOnClearListener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putString("separator", this.mSeparator);
        bundle.putIntArray("pattern", this.pattern);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mSeparator = bundle.getString("separator");
            this.pattern = bundle.getIntArray("pattern");
            this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
            if (this.pattern != null) {
                this.setPattern(this.pattern);
            }
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private static class EmojiExcludeFilter
    implements InputFilter {
        private EmojiExcludeFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                int type = Character.getType(source.charAt(i));
                if (type != 19 && type != 28) continue;
                return "";
            }
            return null;
        }
    }

    public static interface OnClearListener {
        public void onClear();
    }

    public static interface OnXFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface OnXTextChangeListener {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void afterTextChanged(Editable var1);
    }

    private class MyTextWatcher
    implements TextWatcher {
        private MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            XEditText.this.mOldLength = s.length();
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.beforeTextChanged(s, start, count, after);
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            XEditText.this.mNowLength = s.length();
            XEditText.this.mSelectionPos = XEditText.this.getSelectionStart();
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.onTextChanged(s, start, before, count);
            }
        }

        public void afterTextChanged(Editable s) {
            XEditText.this.logicOfCompoundDrawables();
            if (XEditText.this.mSeparator.isEmpty()) {
                if (XEditText.this.mXTextChangeListener != null) {
                    XEditText.this.mXTextChangeListener.afterTextChanged(s);
                }
                return;
            }
            XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
            String trimmedText = XEditText.this.hasNoSeparator ? s.toString().trim() : s.toString().replaceAll(XEditText.this.mSeparator, "").trim();
            XEditText.this.setTextToSeparate(trimmedText, false);
            if (XEditText.this.mXTextChangeListener != null) {
                s.clear();
                s.append((CharSequence)trimmedText);
                XEditText.this.mXTextChangeListener.afterTextChanged(s);
            }
            XEditText.this.addTextChangedListener(XEditText.this.mTextWatcher);
        }
    }
}

