/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.xw.repo.R;

public class XEditText
extends AppCompatEditText {
    private String mSeparator;
    private boolean disableClear;
    private int mClearResId;
    private boolean togglePwdDrawableEnable;
    private boolean disableEmoji;
    private int mShowPwdResId;
    private int mHidePwdResId;
    private Drawable mClearDrawable;
    private Drawable mTogglePwdDrawable;
    private OnXTextChangeListener mXTextChangeListener;
    private OnXFocusChangeListener mXFocusChangeListener;
    private TextWatcher mTextWatcher;
    private int mOldLength;
    private int mNowLength;
    private int mSelectionPos;
    private boolean hasFocused;
    private int[] pattern;
    private int[] intervals;
    private boolean hasNoSeparator;
    private boolean isPwdInputType;
    private boolean isPwdShow;
    private Bitmap mBitmap;
    private int mLeft;
    private int mTop;

    public XEditText(Context context) {
        this(context, null);
    }

    public XEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public XEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        if (this.disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        }
        this.mTextWatcher = new MyTextWatcher();
        this.addTextChangedListener(this.mTextWatcher);
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                XEditText.this.hasFocused = hasFocus;
                XEditText.this.logicOfCompoundDrawables();
                if (XEditText.this.mXFocusChangeListener != null) {
                    XEditText.this.mXFocusChangeListener.onFocusChange(v, hasFocus);
                }
            }
        });
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int inputType;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.XEditText, defStyleAttr, 0);
        this.mSeparator = a.getString(R.styleable.XEditText_x_separator);
        this.disableClear = a.getBoolean(R.styleable.XEditText_x_disableClear, false);
        this.mClearResId = a.getResourceId(R.styleable.XEditText_x_clearDrawable, -1);
        this.togglePwdDrawableEnable = a.getBoolean(R.styleable.XEditText_x_togglePwdDrawableEnable, true);
        this.mShowPwdResId = a.getResourceId(R.styleable.XEditText_x_showPwdDrawable, -1);
        this.mHidePwdResId = a.getResourceId(R.styleable.XEditText_x_hidePwdDrawable, -1);
        this.disableEmoji = a.getBoolean(R.styleable.XEditText_x_disableEmoji, false);
        String pattern = a.getString(R.styleable.XEditText_x_pattern);
        a.recycle();
        if (this.mSeparator == null) {
            this.mSeparator = "";
        }
        this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
        if (this.mSeparator.length() > 0 && ((inputType = this.getInputType()) == 2 || inputType == 8194 || inputType == 4098)) {
            this.setInputType(3);
        }
        if (!this.disableClear) {
            if (this.mClearResId == -1) {
                this.mClearResId = R.drawable.x_et_svg_ic_clear_24dp;
            }
            this.mClearDrawable = AppCompatResources.getDrawable((Context)context, (int)this.mClearResId);
            if (this.mClearDrawable != null) {
                this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
                if (this.mClearResId == R.drawable.x_et_svg_ic_clear_24dp) {
                    DrawableCompat.setTint((Drawable)this.mClearDrawable, (int)this.getCurrentHintTextColor());
                }
            }
        }
        this.dealWithInputTypes(true);
        if (!(this.mSeparator.isEmpty() || this.isPwdInputType || pattern == null || pattern.isEmpty())) {
            boolean ok = true;
            if (pattern.contains(",")) {
                String[] split = pattern.split(",");
                int[] array = new int[split.length];
                for (int i = 0; i < array.length; ++i) {
                    try {
                        array[i] = Integer.parseInt(split[i]);
                        continue;
                    }
                    catch (Exception e) {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    this.setPattern(array, this.mSeparator);
                }
            } else {
                try {
                    int i = Integer.parseInt(pattern);
                    this.setPattern(new int[]{i}, this.mSeparator);
                }
                catch (Exception e) {
                    ok = false;
                }
            }
            if (!ok) {
                Log.e((String)"XEditText", (String)"the Pattern format is incorrect!");
            }
        }
    }

    private void dealWithInputTypes(boolean fromXml) {
        int inputType = this.getInputType();
        if (!fromXml && ++inputType == 17) {
            ++inputType;
        }
        boolean bl = this.isPwdInputType = this.togglePwdDrawableEnable && (inputType == 129 || inputType == 18 || inputType == 145 || inputType == 225);
        if (this.isPwdInputType) {
            boolean bl2 = this.isPwdShow = inputType == 145;
            if (this.isPwdShow) {
                this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            } else {
                this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            }
            if (this.mShowPwdResId == -1) {
                this.mShowPwdResId = R.drawable.x_et_svg_ic_show_password_24dp;
            }
            if (this.mHidePwdResId == -1) {
                this.mHidePwdResId = R.drawable.x_et_svg_ic_hide_password_24dp;
            }
            int tId = this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId;
            this.mTogglePwdDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)tId);
            if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
            }
            this.mTogglePwdDrawable.setBounds(0, 0, this.mTogglePwdDrawable.getIntrinsicWidth(), this.mTogglePwdDrawable.getIntrinsicHeight());
            if (this.mClearResId == -1) {
                this.mClearResId = R.drawable.x_et_svg_ic_clear_24dp;
            }
            if (!this.disableClear) {
                this.mBitmap = this.getBitmapFromVectorDrawable(this.getContext(), this.mClearResId, this.mClearResId == R.drawable.x_et_svg_ic_clear_24dp);
            }
        }
        if (!fromXml) {
            this.setTextEx(this.getTextEx());
            this.logicOfCompoundDrawables();
        }
    }

    private Bitmap getBitmapFromVectorDrawable(Context context, int drawableId, boolean tint) {
        Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)drawableId);
        if (drawable2 == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
        }
        if (tint) {
            DrawableCompat.setTint((Drawable)drawable2, (int)this.getCurrentHintTextColor());
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public void setInputType(int type) {
        super.setInputType(type);
        this.dealWithInputTypes(false);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.hasFocused && this.mBitmap != null && this.isPwdInputType && !this.isTextEmpty()) {
            if (this.mLeft * this.mTop == 0) {
                this.mLeft = this.getMeasuredWidth() - this.getPaddingRight() - this.mTogglePwdDrawable.getIntrinsicWidth() - this.mBitmap.getWidth() - this.dp2px(4);
                this.mTop = this.getMeasuredHeight() - this.mBitmap.getHeight() >> 1;
            }
            canvas.drawBitmap(this.mBitmap, (float)this.mLeft, (float)this.mTop, null);
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.performClick();
        }
        if (this.hasFocused && this.isPwdInputType && event.getAction() == 1) {
            boolean isAreaY;
            int w = this.mTogglePwdDrawable.getIntrinsicWidth();
            int h = this.mTogglePwdDrawable.getIntrinsicHeight();
            int top = this.getMeasuredHeight() - h >> 1;
            int right = this.getMeasuredWidth() - this.getPaddingRight();
            boolean isAreaX = event.getX() <= (float)right && event.getX() >= (float)(right - w);
            boolean bl = isAreaY = event.getY() >= (float)top && event.getY() <= (float)(top + h);
            if (isAreaX && isAreaY) {
                boolean bl2 = this.isPwdShow = !this.isPwdShow;
                if (this.isPwdShow) {
                    this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                } else {
                    this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                this.setSelection(this.getSelectionStart(), this.getSelectionEnd());
                this.mTogglePwdDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)(this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId));
                if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                    DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
                }
                this.mTogglePwdDrawable.setBounds(0, 0, this.mTogglePwdDrawable.getIntrinsicWidth(), this.mTogglePwdDrawable.getIntrinsicHeight());
                this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mTogglePwdDrawable, this.getCompoundDrawables()[3]);
                this.invalidate();
            }
            if (!this.disableClear) {
                boolean bl3 = isAreaX = event.getX() <= (float)(right -= w + this.dp2px(4)) && event.getX() >= (float)(right - this.mBitmap.getWidth());
                if (isAreaX && isAreaY) {
                    this.setError(null);
                    this.setText("");
                }
            }
        }
        if (this.hasFocused && !this.disableClear && !this.isPwdInputType && event.getAction() == 1) {
            boolean isAreaY;
            Rect rect = this.mClearDrawable.getBounds();
            int rectW = rect.width();
            int rectH = rect.height();
            int top = this.getMeasuredHeight() - rectH >> 1;
            int right = this.getMeasuredWidth() - this.getPaddingRight();
            boolean isAreaX = event.getX() <= (float)right && event.getX() >= (float)(right - rectW);
            boolean bl = isAreaY = event.getY() >= (float)top && event.getY() <= (float)(top + rectH);
            if (isAreaX && isAreaY) {
                this.setError(null);
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean onTextContextMenuItem(int id) {
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        if (clipboardManager != null) {
            ClipData.Item item;
            ClipData clip;
            if (id == 0x1020020 || id == 0x1020021) {
                ClipData.Item item2;
                super.onTextContextMenuItem(id);
                ClipData clip2 = clipboardManager.getPrimaryClip();
                if (clip2 != null && (item2 = clip2.getItemAt(0)) != null && item2.getText() != null) {
                    String s = item2.getText().toString().replace(this.mSeparator, "");
                    clipboardManager.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)s));
                    return true;
                }
            } else if (id == 0x1020022 && (clip = clipboardManager.getPrimaryClip()) != null && (item = clip.getItemAt(0)) != null && item.getText() != null) {
                String content = item.getText().toString().replace(this.mSeparator, "");
                this.setTextEx(this.getText_() + content);
                return true;
            }
        }
        return super.onTextContextMenuItem(id);
    }

    private void logicOfCompoundDrawables() {
        if (!this.hasFocused || this.isTextEmpty() && !this.isPwdInputType) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
            if (!this.isTextEmpty() && this.isPwdInputType) {
                this.invalidate();
            }
        } else if (this.isPwdInputType) {
            if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
            }
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mTogglePwdDrawable, this.getCompoundDrawables()[3]);
        } else if (!this.isTextEmpty() && !this.disableClear) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mClearDrawable, this.getCompoundDrawables()[3]);
        }
    }

    private boolean isTextEmpty() {
        return this.getText_().trim().length() == 0;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public void setSeparator(@NonNull String separator) {
        int inputType;
        this.mSeparator = separator;
        this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
        if (this.mSeparator.length() > 0 && ((inputType = this.getInputType()) == 2 || inputType == 8194 || inputType == 4098)) {
            this.setInputType(3);
        }
    }

    public void setPattern(@NonNull int[] pattern, @NonNull String separator) {
        this.setSeparator(separator);
        this.setPattern(pattern);
    }

    public void setPattern(@NonNull int[] pattern) {
        this.pattern = pattern;
        this.intervals = new int[pattern.length];
        int sum = 0;
        for (int i = 0; i < pattern.length; ++i) {
            this.intervals[i] = sum += pattern[i];
        }
        int maxLength = this.intervals[this.intervals.length - 1] + pattern.length - 1;
        InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        this.setFilters(filters);
    }

    @Deprecated
    public void setTextToSeparate(@NonNull CharSequence c) {
        this.setTextToSeparate(c, true);
    }

    public void setTextEx(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text) || this.hasNoSeparator) {
            this.setText(text);
            if (text != null && text.length() > 0) {
                this.setSelection(text.length());
            }
        } else {
            this.setTextToSeparate(text, true);
        }
    }

    private void setTextToSeparate(@NonNull CharSequence c, boolean fromUser) {
        if (c.length() == 0 || this.intervals == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int length1 = c.length();
        for (int i = 0; i < length1; ++i) {
            builder.append(c.subSequence(i, i + 1));
            int length2 = this.intervals.length;
            for (int j = 0; j < length2; ++j) {
                if (i != this.intervals[j] || j >= length2 - 1) continue;
                builder.insert(builder.length() - 1, this.mSeparator);
                if (this.mSelectionPos != builder.length() - 1 || this.mSelectionPos <= this.intervals[j]) continue;
                if (this.mNowLength > this.mOldLength) {
                    this.mSelectionPos += this.mSeparator.length();
                    continue;
                }
                this.mSelectionPos -= this.mSeparator.length();
            }
        }
        String text = builder.toString();
        this.setText(text);
        if (fromUser) {
            int maxLength = this.intervals[this.intervals.length - 1] + this.pattern.length - 1;
            this.setSelection(Math.min(maxLength, text.length()));
        } else {
            if (this.mSelectionPos > text.length()) {
                this.mSelectionPos = text.length();
            }
            if (this.mSelectionPos < 0) {
                this.mSelectionPos = 0;
            }
            this.setSelection(this.mSelectionPos);
        }
    }

    @NonNull
    public String getTextTrimmed() {
        return this.getTextEx().trim();
    }

    @NonNull
    public String getTextEx() {
        if (this.hasNoSeparator) {
            return this.getText_();
        }
        return this.getText_().replaceAll(this.mSeparator, "");
    }

    @Deprecated
    public String getTrimmedString() {
        if (this.hasNoSeparator) {
            return this.getText_().trim();
        }
        return this.getText_().replaceAll(this.mSeparator, "").trim();
    }

    private String getText_() {
        Editable editable = this.getText();
        return editable == null ? "" : editable.toString();
    }

    public boolean hasNoSeparator() {
        return this.hasNoSeparator;
    }

    public void setNoSeparator() {
        this.hasNoSeparator = true;
        this.mSeparator = "";
        this.intervals = null;
    }

    public void setDisableEmoji(boolean disableEmoji) {
        this.disableEmoji = disableEmoji;
        if (disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        } else {
            this.setFilters(new InputFilter[0]);
        }
    }

    public void setOnXTextChangeListener(OnXTextChangeListener listener) {
        this.mXTextChangeListener = listener;
    }

    public void setOnXFocusChangeListener(OnXFocusChangeListener listener) {
        this.mXFocusChangeListener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putString("separator", this.mSeparator);
        bundle.putIntArray("pattern", this.pattern);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mSeparator = bundle.getString("separator");
            this.pattern = bundle.getIntArray("pattern");
            this.hasNoSeparator = TextUtils.isEmpty((CharSequence)this.mSeparator);
            if (this.pattern != null) {
                this.setPattern(this.pattern);
            }
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private class EmojiExcludeFilter
    implements InputFilter {
        private EmojiExcludeFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                int type = Character.getType(source.charAt(i));
                if (type != 19 && type != 28) continue;
                return "";
            }
            return null;
        }
    }

    public static interface OnXFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface OnXTextChangeListener {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void afterTextChanged(Editable var1);
    }

    private class MyTextWatcher
    implements TextWatcher {
        private MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            XEditText.this.mOldLength = s.length();
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.beforeTextChanged(s, start, count, after);
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            XEditText.this.mNowLength = s.length();
            XEditText.this.mSelectionPos = XEditText.this.getSelectionStart();
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.onTextChanged(s, start, before, count);
            }
        }

        public void afterTextChanged(Editable s) {
            XEditText.this.logicOfCompoundDrawables();
            if (XEditText.this.mSeparator.isEmpty()) {
                if (XEditText.this.mXTextChangeListener != null) {
                    XEditText.this.mXTextChangeListener.afterTextChanged(s);
                }
                return;
            }
            XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
            String trimmedText = XEditText.this.hasNoSeparator ? s.toString().trim() : s.toString().replaceAll(XEditText.this.mSeparator, "").trim();
            XEditText.this.setTextToSeparate(trimmedText, false);
            if (XEditText.this.mXTextChangeListener != null) {
                s.clear();
                s.append((CharSequence)trimmedText);
                XEditText.this.mXTextChangeListener.afterTextChanged(s);
            }
            XEditText.this.addTextChangedListener(XEditText.this.mTextWatcher);
        }
    }
}

