/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.xw.repo.R;

public class XEditText
extends AppCompatEditText {
    private String mSeparator;
    private boolean disableClear;
    private Drawable mClearDrawable;
    private Drawable mTogglePwdDrawable;
    private boolean disableEmoji;
    private int mShowPwdResId;
    private int mHidePwdResId;
    private OnXTextChangeListener mXTextChangeListener;
    private TextWatcher mTextWatcher;
    private int mPreLength;
    private boolean hasFocused;
    private int[] pattern;
    private int[] intervals;
    private int mMaxLength = Integer.MAX_VALUE;
    private boolean hasNoSeparator;
    private boolean isPwdInputType;
    private boolean isPwdShow;
    private Bitmap mBitmap;
    private Paint mPaint;

    public XEditText(Context context) {
        this(context, null);
    }

    public XEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public XEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        int inputType = this.getInputType();
        if (inputType == 2 || inputType == 8194 || inputType == 4098) {
            this.setInputType(3);
        }
        if (this.disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        }
        this.mTextWatcher = new MyTextWatcher();
        this.addTextChangedListener(this.mTextWatcher);
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                XEditText.this.hasFocused = hasFocus;
                XEditText.this.markerFocusChangeLogic();
            }
        });
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int inputType;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.XEditText, defStyleAttr, 0);
        this.mSeparator = a.getString(R.styleable.XEditText_x_separator);
        if (this.mSeparator == null) {
            this.mSeparator = "";
        }
        this.disableClear = a.getBoolean(R.styleable.XEditText_x_disableClear, false);
        if (!this.disableClear) {
            int cdId = a.getResourceId(R.styleable.XEditText_x_clearDrawable, -1);
            if (cdId == -1) {
                cdId = R.drawable.x_et_svg_ic_clear_24dp;
            }
            this.mClearDrawable = ContextCompat.getDrawable((Context)context, (int)cdId);
            this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
            if (cdId == R.drawable.x_et_svg_ic_clear_24dp) {
                DrawableCompat.setTint((Drawable)this.mClearDrawable, (int)this.getCurrentHintTextColor());
            }
        }
        if ((inputType = this.getInputType()) == 129 || inputType == 145 || inputType == 18 || inputType == 225) {
            this.isPwdInputType = true;
            this.isPwdShow = inputType == 145;
            this.mMaxLength = 20;
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mShowPwdResId = a.getResourceId(R.styleable.XEditText_x_showPwdDrawable, -1);
            this.mHidePwdResId = a.getResourceId(R.styleable.XEditText_x_hidePwdDrawable, -1);
            if (this.mShowPwdResId == -1) {
                this.mShowPwdResId = R.drawable.x_et_svg_ic_show_password_24dp;
            }
            if (this.mHidePwdResId == -1) {
                this.mHidePwdResId = R.drawable.x_et_svg_ic_hide_password_24dp;
            }
            int tId = this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId;
            this.mTogglePwdDrawable = ContextCompat.getDrawable((Context)context, (int)tId);
            if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
            }
            this.mTogglePwdDrawable.setBounds(0, 0, this.mTogglePwdDrawable.getIntrinsicWidth(), this.mTogglePwdDrawable.getIntrinsicHeight());
            int cdId = a.getResourceId(R.styleable.XEditText_x_clearDrawable, -1);
            if (cdId == -1) {
                cdId = R.drawable.x_et_svg_ic_clear_24dp;
            }
            this.mBitmap = this.getBitmapFromVectorDrawable(context, cdId, cdId == R.drawable.x_et_svg_ic_clear_24dp);
        }
        this.disableEmoji = a.getBoolean(R.styleable.XEditText_x_disableEmoji, false);
        a.recycle();
    }

    private Bitmap getBitmapFromVectorDrawable(Context context, int drawableId, boolean tint) {
        Drawable drawable2 = AppCompatDrawableManager.get().getDrawable(context, drawableId);
        if (Build.VERSION.SDK_INT < 21) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
        }
        if (tint) {
            DrawableCompat.setTint((Drawable)drawable2, (int)this.getCurrentHintTextColor());
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.hasFocused && this.isPwdInputType && !this.isTextEmpty()) {
            int left = this.getMeasuredWidth() - this.getPaddingRight() - this.getCompoundDrawablePadding() - this.mTogglePwdDrawable.getIntrinsicWidth() - this.mBitmap.getWidth() - this.dp2px(4);
            int top = this.getMeasuredHeight() - this.mBitmap.getHeight() >> 1;
            canvas.drawBitmap(this.mBitmap, (float)left, (float)top, this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.hasFocused && this.isPwdInputType && event.getAction() == 1) {
            boolean isAreaY;
            int w = this.mTogglePwdDrawable.getIntrinsicWidth();
            int h = this.mTogglePwdDrawable.getIntrinsicHeight();
            int top = this.getMeasuredHeight() - h >> 1;
            int right = this.getMeasuredWidth() - this.getPaddingRight() - this.getCompoundDrawablePadding();
            boolean isAreaX = event.getX() <= (float)right && event.getX() >= (float)(right - w);
            boolean bl = isAreaY = event.getY() >= (float)top && event.getY() <= (float)(top + h);
            if (isAreaX && isAreaY) {
                boolean bl2 = this.isPwdShow = !this.isPwdShow;
                if (this.isPwdShow) {
                    this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                } else {
                    this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                this.setSelection(this.getSelectionStart(), this.getSelectionEnd());
                this.mTogglePwdDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)(this.isPwdShow ? this.mShowPwdResId : this.mHidePwdResId));
                if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                    DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
                }
                this.mTogglePwdDrawable.setBounds(0, 0, this.mTogglePwdDrawable.getIntrinsicWidth(), this.mTogglePwdDrawable.getIntrinsicHeight());
                this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mTogglePwdDrawable, this.getCompoundDrawables()[3]);
                this.invalidate();
            }
            boolean bl3 = isAreaX = event.getX() <= (float)(right -= w + this.dp2px(4)) && event.getX() >= (float)(right - this.mBitmap.getWidth());
            if (isAreaX && isAreaY) {
                this.setError(null);
                this.setText("");
            }
        }
        if (this.hasFocused && !this.disableClear && !this.isPwdInputType && event.getAction() == 1) {
            boolean isAreaY;
            Rect rect = this.mClearDrawable.getBounds();
            int rectW = rect.width();
            int rectH = rect.height();
            int top = this.getMeasuredHeight() - rectH >> 1;
            int right = this.getMeasuredWidth() - this.getPaddingRight() - this.getCompoundDrawablePadding();
            boolean isAreaX = event.getX() <= (float)right && event.getX() >= (float)(right - rectW);
            boolean bl = isAreaY = event.getY() >= (float)top && event.getY() <= (float)(top + rectH);
            if (isAreaX && isAreaY) {
                this.setError(null);
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean onTextContextMenuItem(int id) {
        ClipData clip;
        ClipData.Item item;
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        if (id == 0x1020020 || id == 0x1020021) {
            super.onTextContextMenuItem(id);
            ClipData clip2 = clipboardManager.getPrimaryClip();
            ClipData.Item item2 = clip2.getItemAt(0);
            if (item2 != null && item2.getText() != null) {
                String s = item2.getText().toString().replace(this.mSeparator, "");
                clipboardManager.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)s));
                return true;
            }
        } else if (id == 0x1020022 && (item = (clip = clipboardManager.getPrimaryClip()).getItemAt(0)) != null && item.getText() != null) {
            this.setTextToSeparate((this.getText().toString() + item.getText().toString()).replace(this.mSeparator, ""));
            return true;
        }
        return super.onTextContextMenuItem(id);
    }

    private void markerFocusChangeLogic() {
        if (!this.hasFocused || this.isTextEmpty() && !this.isPwdInputType) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
            if (!this.isTextEmpty() && this.isPwdInputType) {
                this.invalidate();
            }
        } else if (this.isPwdInputType) {
            if (this.mShowPwdResId == R.drawable.x_et_svg_ic_show_password_24dp || this.mHidePwdResId == R.drawable.x_et_svg_ic_hide_password_24dp) {
                DrawableCompat.setTint((Drawable)this.mTogglePwdDrawable, (int)this.getCurrentHintTextColor());
            }
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mTogglePwdDrawable, this.getCompoundDrawables()[3]);
        } else if (!this.isTextEmpty() && !this.disableClear) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.mClearDrawable, this.getCompoundDrawables()[3]);
        }
    }

    private boolean isTextEmpty() {
        return this.getText().toString().trim().length() == 0;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public void setSeparator(@NonNull String separator) {
        this.mSeparator = separator;
    }

    public void setPattern(@NonNull int[] pattern, @NonNull String separator) {
        this.setSeparator(separator);
        this.setPattern(pattern);
    }

    public void setPattern(@NonNull int[] pattern) {
        this.pattern = pattern;
        this.intervals = new int[pattern.length];
        int count = 0;
        int sum = 0;
        for (int i = 0; i < pattern.length; ++i) {
            this.intervals[i] = (sum += pattern[i]) + count;
            if (i >= pattern.length - 1) continue;
            count += this.mSeparator.length();
        }
        this.mMaxLength = this.intervals[this.intervals.length - 1];
        InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(this.mMaxLength)};
        this.setFilters(filters);
    }

    public void setTextToSeparate(@NonNull CharSequence c) {
        if (c.length() == 0) {
            return;
        }
        this.setText("");
        for (int i = 0; i < c.length(); ++i) {
            this.append(c.subSequence(i, i + 1));
        }
    }

    public String getNonSeparatorText() {
        return this.getText().toString().replaceAll(this.mSeparator, "");
    }

    public boolean hasNoSeparator() {
        return this.hasNoSeparator;
    }

    public void setHasNoSeparator(boolean hasNoSeparator) {
        this.hasNoSeparator = hasNoSeparator;
        if (hasNoSeparator) {
            this.mSeparator = "";
        }
    }

    public void setDisableEmoji(boolean disableEmoji) {
        this.disableEmoji = disableEmoji;
        if (disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        } else {
            this.setFilters(new InputFilter[0]);
        }
    }

    public void setOnXTextChangeListener(OnXTextChangeListener listener) {
        this.mXTextChangeListener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putString("separator", this.mSeparator);
        bundle.putIntArray("pattern", this.pattern);
        bundle.putBoolean("hasNoSeparator", this.hasNoSeparator);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mSeparator = bundle.getString("separator");
            this.pattern = bundle.getIntArray("pattern");
            this.hasNoSeparator = bundle.getBoolean("hasNoSeparator");
            if (this.pattern != null) {
                this.setPattern(this.pattern);
            }
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private class EmojiExcludeFilter
    implements InputFilter {
        private EmojiExcludeFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                int type = Character.getType(source.charAt(i));
                if (type != 19 && type != 28) continue;
                return "";
            }
            return null;
        }
    }

    public static interface OnXTextChangeListener {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void afterTextChanged(Editable var1);
    }

    private class MyTextWatcher
    implements TextWatcher {
        private MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            XEditText.this.mPreLength = s.length();
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.beforeTextChanged(s, start, count, after);
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.onTextChanged(s, start, before, count);
            }
        }

        public void afterTextChanged(Editable s) {
            if (XEditText.this.mXTextChangeListener != null) {
                XEditText.this.mXTextChangeListener.afterTextChanged(s);
            }
            int currLength = s.length();
            if (XEditText.this.hasNoSeparator) {
                XEditText.this.mMaxLength = currLength;
            }
            XEditText.this.markerFocusChangeLogic();
            if (currLength > XEditText.this.mMaxLength) {
                XEditText.this.getText().delete(currLength - 1, currLength);
                return;
            }
            if (XEditText.this.pattern == null) {
                return;
            }
            for (int i = 0; i < XEditText.this.pattern.length; ++i) {
                if (currLength - 1 != XEditText.this.intervals[i]) continue;
                if (currLength > XEditText.this.mPreLength) {
                    if (currLength < XEditText.this.mMaxLength) {
                        XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
                        XEditText.this.getText().insert(currLength - 1, (CharSequence)XEditText.this.mSeparator);
                    }
                } else if (XEditText.this.mPreLength <= XEditText.this.mMaxLength) {
                    XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
                    XEditText.this.getText().delete(currLength - 1, currLength);
                }
                XEditText.this.addTextChangedListener(XEditText.this.mTextWatcher);
                break;
            }
        }
    }
}

