/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo.xedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.xw.repo.xedittext.R;

public class XEditText
extends EditText {
    private OnTextChangeListener mTextChangeListener;
    private OnMarkerClickListener mMarkerClickListener;
    private TextWatcher mTextWatcher;
    private int preLength;
    private int currLength;
    private Drawable mRightMarkerDrawable;
    private Drawable mLeftDrawable;
    private boolean hasFocused;
    private int[] pattern = new int[]{1000};
    private int[] intervals;
    private String separator;
    private int maxLength;
    private boolean hasNoSeparator;
    private boolean customizeMarkerEnable;
    private ShowMarkerTime mShowMarkerTime;
    private Paint mTextPaint;
    private Rect mRect;
    private Rect mTextRect;
    private Bitmap mBitmap;
    private Paint mBitPaint;
    private boolean iOSStyleEnable;
    private boolean iOSFrameHide;
    private CharSequence mHintCharSeq;
    private boolean disableEmoji;

    public XEditText(Context context) {
        this(context, null);
    }

    public XEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public XEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.XEditText, defStyleAttr, 0);
        this.separator = a.getString(R.styleable.XEditText_x_separator);
        if (this.separator == null) {
            this.separator = "";
        }
        this.customizeMarkerEnable = a.getBoolean(R.styleable.XEditText_x_customizeMarkerEnable, false);
        int which = a.getInt(R.styleable.XEditText_x_showMarkerTime, 0);
        switch (which) {
            case 0: {
                this.mShowMarkerTime = ShowMarkerTime.AFTER_INPUT;
                break;
            }
            case 1: {
                this.mShowMarkerTime = ShowMarkerTime.BEFORE_INPUT;
                break;
            }
            case 2: {
                this.mShowMarkerTime = ShowMarkerTime.ALWAYS;
            }
        }
        this.iOSStyleEnable = a.getBoolean(R.styleable.XEditText_x_iOSStyleEnable, false);
        this.disableEmoji = a.getBoolean(R.styleable.XEditText_x_disableEmoji, false);
        a.recycle();
        this.init();
    }

    private void init() {
        if (this.getInputType() == 2) {
            this.setInputType(3);
        }
        this.setPattern(this.pattern);
        this.mTextWatcher = new MyTextWatcher();
        this.addTextChangedListener(this.mTextWatcher);
        this.mRightMarkerDrawable = this.getCompoundDrawables()[2];
        if (this.customizeMarkerEnable && this.mRightMarkerDrawable != null) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
            this.setHasNoSeparator(true);
        }
        if (this.mRightMarkerDrawable == null) {
            this.mRightMarkerDrawable = this.getResources().getDrawable(R.drawable.icon_x_edit_text_clear);
            if (this.mRightMarkerDrawable != null) {
                this.mRightMarkerDrawable.setBounds(0, 0, this.mRightMarkerDrawable.getIntrinsicWidth(), this.mRightMarkerDrawable.getIntrinsicHeight());
            }
        }
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                XEditText.this.hasFocused = hasFocus;
                XEditText.this.markerFocusChangeLogic();
                XEditText.this.iOSFocusChangeLogic();
            }
        });
        if (this.iOSStyleEnable) {
            this.initiOSObjects();
        }
        if (this.disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        }
    }

    private void initiOSObjects() {
        this.mLeftDrawable = this.getCompoundDrawables()[0];
        if (this.mLeftDrawable != null) {
            if (this.mBitmap == null || this.mBitPaint == null) {
                BitmapDrawable bd = (BitmapDrawable)this.mLeftDrawable;
                this.mBitmap = bd.getBitmap();
                this.mBitPaint = new Paint();
                this.mBitPaint.setAntiAlias(true);
            }
            this.setCompoundDrawables(null, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
        }
        this.mHintCharSeq = this.getHint();
        if (this.mHintCharSeq != null) {
            this.setHint("");
            if (this.mRect == null || this.mTextRect == null || this.mTextPaint == null) {
                this.mRect = new Rect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                this.mTextRect = new Rect();
                this.mTextPaint = new Paint();
                this.mTextPaint.setAntiAlias(true);
                this.mTextPaint.setTextSize(this.getTextSize());
                this.mTextPaint.setColor(this.getCurrentHintTextColor());
                this.mTextPaint.setTextAlign(Paint.Align.CENTER);
                this.mTextPaint.getTextBounds(this.mHintCharSeq.toString(), 0, this.mHintCharSeq.length(), this.mTextRect);
            }
        }
        this.iOSFrameHide = false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.iOSStyleEnable) {
            if (this.iOSFrameHide) {
                return;
            }
            if (this.mHintCharSeq != null) {
                Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
                int textCenterY = (this.mRect.bottom + this.mRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
                canvas.drawText(this.mHintCharSeq.toString(), (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2 + textCenterY), this.mTextPaint);
            }
            if (this.mBitmap != null) {
                canvas.drawBitmap(this.mBitmap, (float)((canvas.getWidth() - this.mTextRect.width()) / 2 - this.mBitmap.getWidth() - this.getCompoundDrawablePadding()), (float)((canvas.getHeight() - this.mBitmap.getHeight()) / 2), this.mBitPaint);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.hasFocused && this.mRightMarkerDrawable != null && event.getAction() == 1) {
            boolean isAreaY;
            Rect rect = this.mRightMarkerDrawable.getBounds();
            int height = rect.height();
            int rectTopY = (this.getHeight() - height) / 2;
            boolean isAreaX = event.getX() >= (float)(this.getWidth() - this.getTotalPaddingRight()) && event.getX() <= (float)(this.getWidth() - this.getPaddingRight());
            boolean bl = isAreaY = event.getY() >= (float)rectTopY && event.getY() <= (float)(rectTopY + height);
            if (isAreaX && isAreaY) {
                if (this.customizeMarkerEnable) {
                    this.hideInputMethod();
                    if (this.mMarkerClickListener != null) {
                        this.mMarkerClickListener.onMarkerClick(event.getRawX(), event.getRawY());
                    }
                    return true;
                }
                this.setError(null);
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator can't be null !");
        }
        this.separator = separator;
    }

    public void setPattern(int[] pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can't be null !");
        }
        this.pattern = pattern;
        this.intervals = new int[pattern.length];
        int count = 0;
        int sum = 0;
        for (int i = 0; i < pattern.length; ++i) {
            this.intervals[i] = (sum += pattern[i]) + count;
            if (i >= pattern.length - 1) continue;
            count += this.separator.length();
        }
        this.maxLength = this.intervals[this.intervals.length - 1];
    }

    public void setRightMarkerDrawable(int resId) {
        this.mRightMarkerDrawable = this.getResources().getDrawable(resId);
    }

    public void setTextToSeparate(CharSequence c) {
        if (c == null || c.length() == 0) {
            return;
        }
        this.setText("");
        for (int i = 0; i < c.length(); ++i) {
            this.append(c.subSequence(i, i + 1));
        }
    }

    public String getNonSeparatorText() {
        return this.getText().toString().replaceAll(this.separator, "");
    }

    public void setCustomizeMarkerEnable(boolean customizeMarkerEnable) {
        this.customizeMarkerEnable = customizeMarkerEnable;
        if (customizeMarkerEnable && this.mRightMarkerDrawable != null) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
            this.setHasNoSeparator(true);
        }
    }

    public void setShowMarkerTime(ShowMarkerTime showMarkerTime) {
        this.mShowMarkerTime = showMarkerTime;
    }

    public boolean hasNoSeparator() {
        return this.hasNoSeparator;
    }

    public void setHasNoSeparator(boolean hasNoSeparator) {
        this.hasNoSeparator = hasNoSeparator;
        if (hasNoSeparator) {
            this.separator = "";
        }
    }

    public void setiOSStyleEnable(boolean iOSStyleEnable) {
        this.iOSStyleEnable = iOSStyleEnable;
        if (iOSStyleEnable) {
            this.initiOSObjects();
        } else {
            this.setCompoundDrawables(this.mLeftDrawable, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
            this.setHint(this.mHintCharSeq);
            this.iOSFrameHide = true;
        }
        this.invalidate();
    }

    public void setDisableEmoji(boolean disableEmoji) {
        this.disableEmoji = disableEmoji;
        if (disableEmoji) {
            this.setFilters(new InputFilter[]{new EmojiExcludeFilter()});
        } else {
            this.setFilters(new InputFilter[0]);
        }
    }

    public void setOnTextChangeListener(OnTextChangeListener listener) {
        this.mTextChangeListener = listener;
    }

    public void setOnMarkerClickListener(OnMarkerClickListener markerClickListener) {
        this.mMarkerClickListener = markerClickListener;
    }

    private void markerFocusChangeLogic() {
        if (!this.hasFocused) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
            return;
        }
        Drawable drawable2 = null;
        switch (this.mShowMarkerTime) {
            case ALWAYS: {
                drawable2 = this.mRightMarkerDrawable;
                break;
            }
            case BEFORE_INPUT: {
                if (this.currLength != 0) break;
                drawable2 = this.mRightMarkerDrawable;
                break;
            }
            case AFTER_INPUT: {
                if (this.currLength <= 0) break;
                drawable2 = this.mRightMarkerDrawable;
            }
        }
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], drawable2, this.getCompoundDrawables()[3]);
    }

    private void iOSFocusChangeLogic() {
        if (!this.iOSStyleEnable) {
            return;
        }
        if (this.hasFocused) {
            if (this.mLeftDrawable != null) {
                this.setCompoundDrawables(this.mLeftDrawable, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
            }
            if (this.mHintCharSeq != null) {
                this.setHint(this.mHintCharSeq);
            }
            this.iOSFrameHide = true;
            this.invalidate();
        } else if (this.currLength == 0) {
            this.initiOSObjects();
            this.invalidate();
        }
    }

    private void hideInputMethod() {
        InputMethodManager inputManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private class EmojiExcludeFilter
    implements InputFilter {
        private EmojiExcludeFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                int type = Character.getType(source.charAt(i));
                if (type != 19 && type != 28) continue;
                return "";
            }
            return null;
        }
    }

    public static enum ShowMarkerTime {
        BEFORE_INPUT,
        AFTER_INPUT,
        ALWAYS;

    }

    public static interface OnMarkerClickListener {
        public void onMarkerClick(float var1, float var2);
    }

    public static interface OnTextChangeListener {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void afterTextChanged(Editable var1);
    }

    private class MyTextWatcher
    implements TextWatcher {
        private MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            XEditText.this.preLength = s.length();
            if (XEditText.this.mTextChangeListener != null) {
                XEditText.this.mTextChangeListener.beforeTextChanged(s, start, count, after);
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (XEditText.this.mTextChangeListener != null) {
                XEditText.this.mTextChangeListener.onTextChanged(s, start, before, count);
            }
        }

        public void afterTextChanged(Editable s) {
            if (XEditText.this.mTextChangeListener != null) {
                XEditText.this.mTextChangeListener.afterTextChanged(s);
            }
            XEditText.this.currLength = s.length();
            if (XEditText.this.hasNoSeparator) {
                XEditText.this.maxLength = XEditText.this.currLength;
            }
            XEditText.this.markerFocusChangeLogic();
            if (XEditText.this.currLength > XEditText.this.maxLength) {
                XEditText.this.getText().delete(XEditText.this.currLength - 1, XEditText.this.currLength);
                return;
            }
            for (int i = 0; i < XEditText.this.pattern.length; ++i) {
                if (XEditText.this.currLength - 1 != XEditText.this.intervals[i]) continue;
                if (XEditText.this.currLength > XEditText.this.preLength) {
                    if (XEditText.this.currLength < XEditText.this.maxLength) {
                        XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
                        XEditText.this.getText().insert(XEditText.this.currLength - 1, (CharSequence)XEditText.this.separator);
                    }
                } else if (XEditText.this.preLength <= XEditText.this.maxLength) {
                    XEditText.this.removeTextChangedListener(XEditText.this.mTextWatcher);
                    XEditText.this.getText().delete(XEditText.this.currLength - 1, XEditText.this.currLength);
                }
                XEditText.this.addTextChangedListener(XEditText.this.mTextWatcher);
                break;
            }
        }
    }
}

