/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo.fillblankview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewTreeObserver;
import com.xw.repo.fillblankview.R;

public class FillBlankView
extends AppCompatEditText {
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_PREFIX_STR = "prefix_str";
    private static final String INSTANCE_SUFFIX_STR = "suffix_str";
    private int mBlankNum;
    private int mBlankSpace;
    private int mBlankSolidColor;
    private int mBlankStrokeColor;
    private int mBlankStrokeWidth;
    private int mBlankCornerRadius;
    private boolean isPasswordMode;
    private int mDotSize;
    private int mDotColor;
    private int mTextMatchedColor;
    private int mTextNotMatchedColor;
    private boolean showTextTemporarily;
    private Paint mPaintBlank;
    private Paint mPaintText;
    private Paint mPaintDot;
    private RectF[] mRectFs;
    private RectF mRectBig;
    private Rect mTextRect;
    private String mPrefixStr;
    private String mSuffixStr;
    private String[] mBlankStrings;
    private int mDotCount;
    private OnTextMatchedListener mListener;
    private String originalText;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            FillBlankView.this.mHandler.removeCallbacksAndMessages(null);
            FillBlankView.this.showTextTemporarily = false;
            FillBlankView.this.invalidate();
        }
    };

    public FillBlankView(Context context) {
        this(context, null);
    }

    public FillBlankView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FillBlankView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        String text;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FillBlankView, defStyleAttr, 0);
        this.mBlankNum = a.getInteger(R.styleable.FillBlankView_blankNum, 6);
        this.mBlankSpace = a.getDimensionPixelSize(R.styleable.FillBlankView_blankSpace, 0);
        this.mBlankSolidColor = a.getColor(R.styleable.FillBlankView_blankSolidColor, this.getDrawingCacheBackgroundColor());
        this.mBlankStrokeColor = a.getColor(R.styleable.FillBlankView_blankStrokeColor, this.getCurrentTextColor());
        this.mBlankStrokeWidth = a.getDimensionPixelSize(R.styleable.FillBlankView_blankStrokeWidth, 1);
        this.mBlankCornerRadius = a.getDimensionPixelSize(R.styleable.FillBlankView_blankCornerRadius, 0);
        this.isPasswordMode = a.getBoolean(R.styleable.FillBlankView_isPasswordMode, false);
        this.mDotSize = a.getDimensionPixelSize(R.styleable.FillBlankView_dotSize, this.dp2px(4));
        this.mDotColor = a.getColor(R.styleable.FillBlankView_dotColor, this.getCurrentTextColor());
        this.mTextMatchedColor = a.getColor(R.styleable.FillBlankView_textMatchedColor, this.getCurrentTextColor());
        this.mTextNotMatchedColor = a.getColor(R.styleable.FillBlankView_textNotMatchedColor, this.getCurrentTextColor());
        a.recycle();
        int inputType = this.getInputType();
        if (inputType == 129 || inputType == 145 || inputType == 18 || inputType == 225) {
            this.isPasswordMode = true;
        }
        if (!(text = this.getText().toString()).isEmpty()) {
            this.mBlankNum = text.length();
        }
        this.initObjects();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    FillBlankView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    FillBlankView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                FillBlankView.this.setText((CharSequence)FillBlankView.this.getText());
                if (FillBlankView.this.isClickable()) {
                    FillBlankView.this.setFocusable(true);
                    FillBlankView.this.setFocusableInTouchMode(true);
                    FillBlankView.this.requestFocus();
                }
                FillBlankView.this.mHandler.sendEmptyMessage(0);
            }
        });
    }

    private void initObjects() {
        this.setCursorVisible(false);
        if (this.mBlankNum <= 0) {
            throw new IllegalArgumentException("the 'blankNum' must be greater than zero !");
        }
        this.mBlankStrings = new String[this.mBlankNum];
        for (int i = 0; i < this.mBlankStrings.length; ++i) {
            this.mBlankStrings[i] = "";
        }
        this.mPaintBlank = new Paint();
        this.mPaintBlank.setAntiAlias(true);
        this.mTextRect = new Rect();
        this.mPaintText = new Paint();
        this.mPaintText.setAntiAlias(true);
        this.mPaintText.setColor(this.getCurrentTextColor());
        this.mPaintText.setTextSize(this.getTextSize());
        this.mPaintDot = new Paint();
        this.mPaintDot.setAntiAlias(true);
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                int length;
                if (s.length() > FillBlankView.this.mBlankNum) {
                    FillBlankView.this.getText().delete(s.length() - 1, s.length());
                    FillBlankView.this.mDotCount = FillBlankView.this.mBlankNum;
                    return;
                }
                FillBlankView.this.mPaintText.setColor(FillBlankView.this.getCurrentTextColor());
                if (FillBlankView.this.isPasswordMode) {
                    FillBlankView.this.mPaintDot.setColor(FillBlankView.this.mDotColor);
                }
                for (int i = 0; i < FillBlankView.this.mBlankNum; ++i) {
                    ((FillBlankView)FillBlankView.this).mBlankStrings[i] = i < s.length() ? s.subSequence(i, i + 1).toString() : "";
                }
                if (FillBlankView.this.getFilledText().equals(FillBlankView.this.originalText)) {
                    if (s.length() == FillBlankView.this.mBlankNum) {
                        FillBlankView.this.mPaintText.setColor(FillBlankView.this.mTextMatchedColor);
                        if (FillBlankView.this.isPasswordMode && FillBlankView.this.mTextMatchedColor != FillBlankView.this.getCurrentTextColor()) {
                            FillBlankView.this.mPaintDot.setColor(FillBlankView.this.mTextMatchedColor);
                        }
                    }
                    if (FillBlankView.this.mListener != null) {
                        FillBlankView.this.mListener.matched(true, FillBlankView.this.originalText);
                    }
                } else {
                    if (s.length() == FillBlankView.this.mBlankNum) {
                        FillBlankView.this.mPaintText.setColor(FillBlankView.this.mTextNotMatchedColor);
                        if (FillBlankView.this.isPasswordMode && FillBlankView.this.mTextNotMatchedColor != FillBlankView.this.getCurrentTextColor()) {
                            FillBlankView.this.mPaintDot.setColor(FillBlankView.this.mTextNotMatchedColor);
                        }
                    }
                    if (FillBlankView.this.mListener != null) {
                        FillBlankView.this.mListener.matched(false, null);
                    }
                }
                if ((length = s.length()) <= FillBlankView.this.mDotCount) {
                    FillBlankView.this.mDotCount = length;
                    FillBlankView.this.invalidate();
                    return;
                }
                FillBlankView.this.mDotCount = length;
                if (FillBlankView.this.isPasswordMode) {
                    FillBlankView.this.showTextTemporarily = true;
                    FillBlankView.this.invalidate();
                    FillBlankView.this.mHandler.sendEmptyMessageDelayed(0, 500L);
                } else {
                    FillBlankView.this.invalidate();
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initSizes();
    }

    private void initSizes() {
        int viewWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int column = this.isEmptyString(this.mPrefixStr) && this.isEmptyString(this.mSuffixStr) ? this.mBlankNum : (!this.isEmptyString(this.mPrefixStr) && !this.isEmptyString(this.mSuffixStr) ? this.mBlankNum + 2 : this.mBlankNum + 1);
        this.mRectFs = new RectF[column];
        int width = (viewWidth - this.mBlankSpace * (column - 1)) / column;
        float top = this.getPaddingTop();
        float bottom = this.getHeight() - this.getPaddingBottom();
        for (int i = 0; i < this.mRectFs.length; ++i) {
            float right;
            float left;
            if (i == 0) {
                left = this.getPaddingLeft();
                right = left + (float)width;
            } else {
                left = width * i + this.mBlankSpace * i + this.getPaddingLeft();
                right = width * (i + 1) + this.mBlankSpace * i + this.getPaddingLeft();
            }
            this.mRectFs[i] = new RectF(left, top, right, bottom);
        }
        if (this.mBlankSpace == 0) {
            this.mRectBig = !this.isEmptyString(this.mPrefixStr) && !this.isEmptyString(this.mSuffixStr) ? new RectF(this.mRectFs[1].left, (float)this.getPaddingTop(), this.mRectFs[this.mRectFs.length - 2].right, (float)(this.getHeight() - this.getPaddingBottom())) : (!this.isEmptyString(this.mPrefixStr) && this.isEmptyString(this.mSuffixStr) ? new RectF(this.mRectFs[1].left, (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingLeft()), (float)(this.getHeight() - this.getPaddingBottom())) : (this.isEmptyString(this.mPrefixStr) && !this.isEmptyString(this.mSuffixStr) ? new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), this.mRectFs[this.mRectFs.length - 2].right, (float)(this.getHeight() - this.getPaddingBottom())) : new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingLeft()), (float)(this.getHeight() - this.getPaddingBottom()))));
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.getBackground() == null) {
            canvas.drawColor(-1);
        } else {
            this.getBackground().draw(canvas);
        }
        for (int i = 0; i < this.mRectFs.length; ++i) {
            if (i == 0 && !this.isEmptyString(this.mPrefixStr)) continue;
            if (this.mRectFs.length > 1 && i == this.mRectFs.length - 1 && !this.isEmptyString(this.mSuffixStr)) break;
            this.mPaintBlank.setStyle(Paint.Style.FILL);
            this.mPaintBlank.setColor(this.mBlankSolidColor);
            canvas.drawRoundRect(this.mRectFs[i], (float)this.mBlankCornerRadius, (float)this.mBlankCornerRadius, this.mPaintBlank);
            if (this.mBlankStrokeWidth <= 0) continue;
            this.mPaintBlank.setStyle(Paint.Style.STROKE);
            this.mPaintBlank.setColor(this.mBlankStrokeColor);
            this.mPaintBlank.setStrokeWidth((float)this.mBlankStrokeWidth);
            if (this.mBlankSpace > 0 && this.mBlankSolidColor != this.mBlankStrokeColor) {
                canvas.drawRoundRect(this.mRectFs[i], (float)this.mBlankCornerRadius, (float)this.mBlankCornerRadius, this.mPaintBlank);
                continue;
            }
            if (this.mBlankSpace != 0) continue;
            if (this.mBlankNum > 1) {
                this.mPaintBlank.setAlpha(110);
                this.mPaintBlank.setStrokeWidth((float)this.mBlankStrokeWidth / 2.0f);
                canvas.drawLine(this.mRectFs[i].right, this.mRectFs[i].top, this.mRectFs[i].right, this.mRectFs[i].bottom, this.mPaintBlank);
                if (i != this.mRectFs.length - 2) continue;
                this.mPaintBlank.setAlpha(255);
                this.mPaintBlank.setStrokeWidth((float)this.mBlankStrokeWidth);
                canvas.drawRoundRect(this.mRectBig, (float)this.mBlankCornerRadius, (float)this.mBlankCornerRadius, this.mPaintBlank);
                break;
            }
            if (this.mBlankNum != 1) continue;
            canvas.drawRoundRect(this.mRectBig, (float)this.mBlankCornerRadius, (float)this.mBlankCornerRadius, this.mPaintBlank);
        }
        Paint.FontMetrics fontMetrics = this.mPaintText.getFontMetrics();
        float textCenterY = ((float)this.getHeight() - fontMetrics.ascent - fontMetrics.descent) / 2.0f;
        if (!this.isEmptyString(this.mPrefixStr)) {
            this.mPaintText.setTextAlign(Paint.Align.RIGHT);
            this.mPaintText.getTextBounds(this.mPrefixStr, 0, this.mPrefixStr.length(), this.mTextRect);
            canvas.drawText(this.mPrefixStr, this.mRectFs[1].left - (float)this.mBlankSpace, textCenterY, this.mPaintText);
        }
        this.mPaintText.setTextAlign(Paint.Align.CENTER);
        for (int i = 0; i < this.mBlankNum; ++i) {
            if (this.isPasswordMode && this.mDotCount > 0 && i <= this.mDotCount - 1) {
                if (i + 1 > this.mDotCount) break;
                if (this.showTextTemporarily && i == this.mDotCount - 1) {
                    this.mPaintText.getTextBounds(this.mBlankStrings[i], 0, this.mBlankStrings[i].length(), this.mTextRect);
                    if (this.isEmptyString(this.mPrefixStr)) {
                        canvas.drawText(this.mBlankStrings[i], this.mRectFs[i].centerX(), textCenterY, this.mPaintText);
                        continue;
                    }
                    canvas.drawText(this.mBlankStrings[i], this.mRectFs[i + 1].centerX(), textCenterY, this.mPaintText);
                    continue;
                }
                if (this.isEmptyString(this.mPrefixStr)) {
                    canvas.drawCircle(this.mRectFs[i].centerX(), this.mRectFs[i].centerY(), (float)this.mDotSize, this.mPaintDot);
                    continue;
                }
                canvas.drawCircle(this.mRectFs[i + 1].centerX(), this.mRectFs[i + 1].centerY(), (float)this.mDotSize, this.mPaintDot);
                continue;
            }
            this.mPaintText.getTextBounds(this.mBlankStrings[i], 0, this.mBlankStrings[i].length(), this.mTextRect);
            if (this.isEmptyString(this.mPrefixStr)) {
                canvas.drawText(this.mBlankStrings[i], this.mRectFs[i].centerX(), textCenterY, this.mPaintText);
                continue;
            }
            canvas.drawText(this.mBlankStrings[i], this.mRectFs[i + 1].centerX(), textCenterY, this.mPaintText);
        }
        if (!this.isEmptyString(this.mSuffixStr)) {
            this.mPaintText.setTextAlign(Paint.Align.LEFT);
            this.mPaintText.getTextBounds(this.mSuffixStr, 0, this.mSuffixStr.length(), this.mTextRect);
            canvas.drawText(this.mSuffixStr, this.mRectFs[this.mRectFs.length - 1].left, textCenterY, this.mPaintText);
        }
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(@NonNull String originalText) {
        this.originalText = originalText;
        if (originalText.isEmpty()) {
            return;
        }
        this.mBlankNum = originalText.length();
        this.mBlankStrings = new String[this.mBlankNum];
        for (int i = 0; i < this.mBlankStrings.length; ++i) {
            this.mBlankStrings[i] = "";
        }
        this.initSizes();
        this.invalidate();
    }

    public void setOriginalText(@NonNull String originalText, int prefixLength, int suffixLength) {
        this.originalText = originalText;
        if (originalText.isEmpty()) {
            return;
        }
        if (originalText.length() <= prefixLength + suffixLength) {
            throw new IllegalArgumentException("the sum of prefixLength and suffixLength must be less than length of originalText");
        }
        this.mBlankNum = originalText.length() - prefixLength - suffixLength;
        this.mPrefixStr = originalText.substring(0, prefixLength);
        this.mSuffixStr = originalText.substring(originalText.length() - suffixLength, originalText.length());
        this.mBlankStrings = new String[this.mBlankNum];
        for (int i = 0; i < this.mBlankStrings.length; ++i) {
            this.mBlankStrings[i] = "";
        }
        this.initSizes();
        this.invalidate();
    }

    public String getFilledText() {
        StringBuilder builder = new StringBuilder();
        if (!this.isEmptyString(this.mPrefixStr)) {
            builder.append(this.mPrefixStr);
        }
        for (String s : this.mBlankStrings) {
            builder.append(s);
        }
        if (!this.isEmptyString(this.mSuffixStr)) {
            builder.append(this.mSuffixStr);
        }
        return builder.toString();
    }

    public int getBlankNum() {
        return this.mBlankNum;
    }

    public void setBlankNum(int blankNum) {
        if (!this.isEmptyString(this.mPrefixStr) || !this.isEmptyString(this.mSuffixStr)) {
            return;
        }
        this.mBlankNum = blankNum;
        if (this.mBlankNum <= 0) {
            throw new IllegalArgumentException("the 'blankNum' must be greater than zero !");
        }
        this.mBlankStrings = new String[this.mBlankNum];
        for (int i = 0; i < this.mBlankStrings.length; ++i) {
            this.mBlankStrings[i] = "";
        }
        this.initSizes();
        this.invalidate();
    }

    public int getBlankSpace() {
        return this.mBlankSpace;
    }

    public void setBlankSpace(int blankSpace) {
        this.mBlankSpace = blankSpace;
        if (this.mBlankSpace < 0) {
            throw new IllegalArgumentException("the number of 'blankSpace' can't be less than zero !");
        }
        this.initSizes();
        this.invalidate();
    }

    public int getBlankSolidColor() {
        return this.mBlankSolidColor;
    }

    public void setBlankSolidColor(int blankSolidColor) {
        this.mBlankSolidColor = blankSolidColor;
        this.invalidate();
    }

    public int getBlankStrokeColor() {
        return this.mBlankStrokeColor;
    }

    public void setBlankStrokeColor(int blankStrokeColor) {
        this.mBlankStrokeColor = blankStrokeColor;
        this.invalidate();
    }

    public int getBlankStrokeWidth() {
        return this.mBlankStrokeWidth;
    }

    public void setBlankStrokeWidth(int blankStrokeWidth) {
        this.mBlankStrokeWidth = blankStrokeWidth;
        this.invalidate();
    }

    public int getBlankCornerRadius() {
        return this.mBlankCornerRadius;
    }

    public void setBlankCornerRadius(int blankCornerRadius) {
        this.mBlankCornerRadius = blankCornerRadius;
        this.invalidate();
    }

    public int getDotSize() {
        return this.mDotSize;
    }

    public void setDotSize(int dotSize) {
        this.mDotSize = dotSize;
        this.invalidate();
    }

    public int getDotColor() {
        return this.mDotColor;
    }

    public void setDotColor(int dotColor) {
        this.mDotColor = dotColor;
        this.invalidate();
    }

    public int getTextMatchedColor() {
        return this.mTextMatchedColor;
    }

    public void setTextMatchedColor(int textMatchedColor) {
        this.mTextMatchedColor = textMatchedColor;
    }

    public int getTextNotMatchedColor() {
        return this.mTextNotMatchedColor;
    }

    public void setTextNotMatchedColor(int textNotMatchedColor) {
        this.mTextNotMatchedColor = textNotMatchedColor;
    }

    public OnTextMatchedListener getOnTextMatchedListener() {
        return this.mListener;
    }

    public void setOnTextMatchedListener(OnTextMatchedListener listener) {
        this.mListener = listener;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private boolean isEmptyString(String string) {
        return string == null || string.isEmpty();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putString(INSTANCE_PREFIX_STR, this.mPrefixStr);
        bundle.putString(INSTANCE_SUFFIX_STR, this.mSuffixStr);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mPrefixStr = bundle.getString(INSTANCE_PREFIX_STR);
            this.mSuffixStr = bundle.getString(INSTANCE_SUFFIX_STR);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public static interface OnTextMatchedListener {
        public void matched(boolean var1, String var2);
    }
}

