/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import com.xw.repo.BubbleSeekBar;
import com.xw.repo.BubbleUtils;

public class BubbleConfigBuilder {
    float min;
    float max;
    float progress;
    boolean floatType;
    int trackSize;
    int secondTrackSize;
    int thumbRadius;
    int thumbRadiusOnDragging;
    int trackColor;
    int secondTrackColor;
    int thumbColor;
    int sectionCount;
    boolean showSectionMark;
    boolean autoAdjustSectionMark;
    boolean showSectionText;
    int sectionTextSize;
    int sectionTextColor;
    int sectionTextPosition;
    int sectionTextInterval;
    boolean showThumbText;
    int thumbTextSize;
    int thumbTextColor;
    boolean showProgressInFloat;
    long animDuration;
    boolean touchToSeek;
    boolean seekBySection;
    int bubbleColor;
    int bubbleTextSize;
    int bubbleTextColor;
    boolean alwaysShowBubble;
    long alwaysShowBubbleDelay;
    boolean hideBubble;
    boolean rtl;
    private BubbleSeekBar mBubbleSeekBar;

    BubbleConfigBuilder(BubbleSeekBar bubbleSeekBar) {
        this.mBubbleSeekBar = bubbleSeekBar;
    }

    public void build() {
        this.mBubbleSeekBar.config(this);
    }

    public BubbleConfigBuilder min(float min) {
        this.min = min;
        this.progress = min;
        return this;
    }

    public BubbleConfigBuilder max(float max) {
        this.max = max;
        return this;
    }

    public BubbleConfigBuilder progress(float progress) {
        this.progress = progress;
        return this;
    }

    public BubbleConfigBuilder floatType() {
        this.floatType = true;
        return this;
    }

    public BubbleConfigBuilder trackSize(int dp) {
        this.trackSize = BubbleUtils.dp2px(dp);
        return this;
    }

    public BubbleConfigBuilder secondTrackSize(int dp) {
        this.secondTrackSize = BubbleUtils.dp2px(dp);
        return this;
    }

    public BubbleConfigBuilder thumbRadius(int dp) {
        this.thumbRadius = BubbleUtils.dp2px(dp);
        return this;
    }

    public BubbleConfigBuilder thumbRadiusOnDragging(int dp) {
        this.thumbRadiusOnDragging = BubbleUtils.dp2px(dp);
        return this;
    }

    public BubbleConfigBuilder trackColor(@ColorInt int color2) {
        this.trackColor = color2;
        this.sectionTextColor = color2;
        return this;
    }

    public BubbleConfigBuilder secondTrackColor(@ColorInt int color2) {
        this.secondTrackColor = color2;
        this.thumbColor = color2;
        this.thumbTextColor = color2;
        this.bubbleColor = color2;
        return this;
    }

    public BubbleConfigBuilder thumbColor(@ColorInt int color2) {
        this.thumbColor = color2;
        return this;
    }

    public BubbleConfigBuilder sectionCount(@IntRange(from=1L) int count) {
        this.sectionCount = count;
        return this;
    }

    public BubbleConfigBuilder showSectionMark() {
        this.showSectionMark = true;
        return this;
    }

    public BubbleConfigBuilder autoAdjustSectionMark() {
        this.autoAdjustSectionMark = true;
        return this;
    }

    public BubbleConfigBuilder showSectionText() {
        this.showSectionText = true;
        return this;
    }

    public BubbleConfigBuilder sectionTextSize(int sp) {
        this.sectionTextSize = BubbleUtils.sp2px(sp);
        return this;
    }

    public BubbleConfigBuilder sectionTextColor(@ColorInt int color2) {
        this.sectionTextColor = color2;
        return this;
    }

    public BubbleConfigBuilder sectionTextPosition(int position) {
        this.sectionTextPosition = position;
        return this;
    }

    public BubbleConfigBuilder sectionTextInterval(@IntRange(from=1L) int interval) {
        this.sectionTextInterval = interval;
        return this;
    }

    public BubbleConfigBuilder showThumbText() {
        this.showThumbText = true;
        return this;
    }

    public BubbleConfigBuilder thumbTextSize(int sp) {
        this.thumbTextSize = BubbleUtils.sp2px(sp);
        return this;
    }

    public BubbleConfigBuilder thumbTextColor(@ColorInt int color2) {
        this.thumbTextColor = color2;
        return this;
    }

    public BubbleConfigBuilder showProgressInFloat() {
        this.showProgressInFloat = true;
        return this;
    }

    public BubbleConfigBuilder animDuration(long duration) {
        this.animDuration = duration;
        return this;
    }

    public BubbleConfigBuilder touchToSeek() {
        this.touchToSeek = true;
        return this;
    }

    public BubbleConfigBuilder seekBySection() {
        this.seekBySection = true;
        return this;
    }

    public BubbleConfigBuilder bubbleColor(@ColorInt int color2) {
        this.bubbleColor = color2;
        return this;
    }

    public BubbleConfigBuilder bubbleTextSize(int sp) {
        this.bubbleTextSize = BubbleUtils.sp2px(sp);
        return this;
    }

    public BubbleConfigBuilder bubbleTextColor(@ColorInt int color2) {
        this.bubbleTextColor = color2;
        return this;
    }

    public BubbleConfigBuilder alwaysShowBubble() {
        this.alwaysShowBubble = true;
        return this;
    }

    public BubbleConfigBuilder alwaysShowBubbleDelay(long delay) {
        this.alwaysShowBubbleDelay = delay;
        return this;
    }

    public BubbleConfigBuilder hideBubble() {
        this.hideBubble = true;
        return this;
    }

    public BubbleConfigBuilder rtl() {
        this.rtl = true;
        return this;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getProgress() {
        return this.progress;
    }

    public boolean isFloatType() {
        return this.floatType;
    }

    public int getTrackSize() {
        return this.trackSize;
    }

    public int getSecondTrackSize() {
        return this.secondTrackSize;
    }

    public int getThumbRadius() {
        return this.thumbRadius;
    }

    public int getThumbRadiusOnDragging() {
        return this.thumbRadiusOnDragging;
    }

    public int getTrackColor() {
        return this.trackColor;
    }

    public int getSecondTrackColor() {
        return this.secondTrackColor;
    }

    public int getThumbColor() {
        return this.thumbColor;
    }

    public int getSectionCount() {
        return this.sectionCount;
    }

    public boolean isShowSectionMark() {
        return this.showSectionMark;
    }

    public boolean isAutoAdjustSectionMark() {
        return this.autoAdjustSectionMark;
    }

    public boolean isShowSectionText() {
        return this.showSectionText;
    }

    public int getSectionTextSize() {
        return this.sectionTextSize;
    }

    public int getSectionTextColor() {
        return this.sectionTextColor;
    }

    public int getSectionTextPosition() {
        return this.sectionTextPosition;
    }

    public int getSectionTextInterval() {
        return this.sectionTextInterval;
    }

    public boolean isShowThumbText() {
        return this.showThumbText;
    }

    public int getThumbTextSize() {
        return this.thumbTextSize;
    }

    public int getThumbTextColor() {
        return this.thumbTextColor;
    }

    public boolean isShowProgressInFloat() {
        return this.showProgressInFloat;
    }

    public long getAnimDuration() {
        return this.animDuration;
    }

    public boolean isTouchToSeek() {
        return this.touchToSeek;
    }

    public boolean isSeekBySection() {
        return this.seekBySection;
    }

    public int getBubbleColor() {
        return this.bubbleColor;
    }

    public int getBubbleTextSize() {
        return this.bubbleTextSize;
    }

    public int getBubbleTextColor() {
        return this.bubbleTextColor;
    }

    public boolean isAlwaysShowBubble() {
        return this.alwaysShowBubble;
    }

    public long getAlwaysShowBubbleDelay() {
        return this.alwaysShowBubbleDelay;
    }

    public boolean isHideBubble() {
        return this.hideBubble;
    }

    public boolean isRtl() {
        return this.rtl;
    }
}

