/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.content.res.Resources;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class BubbleUtils {
    private static final File BUILD_PROP_FILE = new File(Environment.getRootDirectory(), "build.prop");
    private static Properties sBuildProperties;
    private static final Object sBuildPropertiesLock;

    BubbleUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getBuildProperties() {
        Object object = sBuildPropertiesLock;
        synchronized (object) {
            if (sBuildProperties == null) {
                sBuildProperties = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(BUILD_PROP_FILE);
                    sBuildProperties.load(fis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return sBuildProperties;
    }

    static boolean isMIUI() {
        return BubbleUtils.getBuildProperties().containsKey("ro.miui.ui.version.name");
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static int sp2px(int sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static {
        sBuildPropertiesLock = new Object();
    }
}

